/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.WordUtils;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.ColumnPersistenceException;
import org.helenus.driver.ExcludedSuffixKeyException;
import org.helenus.driver.ObjectConversionException;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.DataDecoder;
import org.helenus.driver.impl.DataTypeImpl;
import org.helenus.driver.impl.EmptyOptionalPrimaryKeyException;
import org.helenus.driver.impl.RootClassInfoImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.TypeClassInfoImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.UDTRootClassInfoImpl;
import org.helenus.driver.impl.UDTTypeClassInfoImpl;
import org.helenus.driver.impl.UDTValueWrapper;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.info.FieldInfo;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.ClusteringKey;
import org.helenus.driver.persistence.Column;
import org.helenus.driver.persistence.DataType;
import org.helenus.driver.persistence.Index;
import org.helenus.driver.persistence.Mandatory;
import org.helenus.driver.persistence.PartitionKey;
import org.helenus.driver.persistence.Persisted;
import org.helenus.driver.persistence.Persister;
import org.helenus.driver.persistence.SuffixKey;
import org.helenus.driver.persistence.TypeKey;

public class FieldInfoImpl<T>
implements FieldInfo<T> {
    private final Class<T> clazz;
    private final ClassInfoImpl<T> cinfo;
    public final TableInfoImpl<T> tinfo;
    private final Class<?> declaringClass;
    private final Field field;
    private final String name;
    private final Class<?> type;
    private final boolean isOptional;
    private final Column column;
    private final Persisted persisted;
    private final Persister<?, ?> persister;
    private final SuffixKey suffix;
    private final boolean mandatory;
    private final Index index;
    private final PartitionKey partitionKey;
    private final ClusteringKey clusteringKey;
    private final TypeKey typeKey;
    private final Class<?> multiKeyType;
    private final DataTypeImpl.Definition definition;
    private final DataDecoder<?> decoder;
    private final boolean isFinal;
    private final Object finalValue;
    final Map<Class<? extends T>, BiConsumer<Object, Object>> setters;
    final Map<Class<? extends T>, Function<Object, Object>> getters;
    private volatile boolean isLast = false;

    FieldInfoImpl(ClassInfoImpl<T> cinfo, TableInfoImpl<T> tinfo, FieldInfoImpl<? extends T> field) {
        this(cinfo, tinfo, field, field.mandatory);
    }

    FieldInfoImpl(ClassInfoImpl<T> cinfo, TableInfoImpl<T> tinfo, FieldInfoImpl<? extends T> field, boolean mandatory) {
        this.clazz = cinfo.getObjectClass();
        this.cinfo = cinfo;
        this.tinfo = tinfo;
        this.declaringClass = field.declaringClass;
        this.field = field.field;
        this.name = field.name;
        this.type = field.type;
        this.isOptional = field.isOptional;
        this.column = field.column;
        this.persisted = field.persisted;
        this.persister = field.persister;
        this.suffix = field.suffix;
        this.mandatory = mandatory;
        this.index = field.index;
        this.partitionKey = field.partitionKey;
        this.clusteringKey = field.clusteringKey;
        this.typeKey = field.typeKey;
        this.multiKeyType = field.multiKeyType;
        this.definition = field.definition;
        this.decoder = field.decoder;
        this.isFinal = field.isFinal;
        this.finalValue = field.finalValue;
        this.setters = new HashMap<Class<T>, BiConsumer<Object, Object>>(field.setters);
        this.getters = new HashMap<Class<T>, Function<Object, Object>>(field.getters);
        this.isLast = field.isLast;
    }

    FieldInfoImpl(ClassInfoImpl<T> cinfo, Field field) {
        this.clazz = cinfo.getObjectClass();
        this.cinfo = cinfo;
        this.tinfo = null;
        this.declaringClass = field.getDeclaringClass();
        this.field = field;
        field.setAccessible(true);
        this.isFinal = Modifier.isFinal(field.getModifiers());
        this.name = field.getName();
        this.type = ClassUtils.primitiveToWrapper(DataTypeImpl.unwrapOptionalIfPresent(field.getType(), field.getGenericType()));
        this.isOptional = Optional.class.isAssignableFrom(field.getType());
        this.column = null;
        this.persisted = null;
        this.persister = null;
        this.suffix = field.getAnnotation(SuffixKey.class);
        this.mandatory = true;
        this.index = null;
        this.partitionKey = null;
        this.clusteringKey = null;
        this.typeKey = null;
        this.multiKeyType = null;
        this.definition = null;
        this.decoder = null;
        this.getters = new HashMap<Class<? extends T>, Function<Object, Object>>(6);
        this.setters = new HashMap<Class<? extends T>, BiConsumer<Object, Object>>(6);
        this.findGetter(this.declaringClass);
        this.findSetter(this.declaringClass);
        this.finalValue = this.findFinalValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FieldInfoImpl(TableInfoImpl<T> tinfo, Field field) {
        boolean isInTable;
        this.clazz = tinfo.getObjectClass();
        this.cinfo = (ClassInfoImpl)tinfo.getClassInfo();
        this.tinfo = tinfo;
        this.declaringClass = field.getDeclaringClass();
        this.field = field;
        field.setAccessible(true);
        this.isFinal = Modifier.isFinal(field.getModifiers());
        this.name = field.getName();
        this.type = ClassUtils.primitiveToWrapper(DataTypeImpl.unwrapOptionalIfPresent(field.getType(), field.getGenericType()));
        this.isOptional = Optional.class.isAssignableFrom(field.getType());
        this.persisted = field.getAnnotation(Persisted.class);
        if (this.persisted != null) {
            Validate.isTrue((this.persisted.as() != DataType.INFERRED && !this.persisted.as().isCollection() ? 1 : 0) != 0, (String)"@Persisted annotation cannot be of type '%s': %s.%s", (Object[])new Object[]{this.persisted.as(), this.declaringClass.getName(), field.getName()});
            this.persister = this.newPersister();
        } else {
            this.persister = null;
        }
        this.suffix = field.getAnnotation(SuffixKey.class);
        this.mandatory = field.getType().isPrimitive() || field.getAnnotation(Mandatory.class) != null;
        Validate.isTrue((!this.isOptional || !this.mandatory ? 1 : 0) != 0, (String)"field cannot be annotated with @Mandatory if it is optional: %s.%s", (Object[])new Object[]{this.declaringClass.getName(), field.getName()});
        Map columns = ReflectionUtils.getAnnotationsByType(String.class, Column.class, (AnnotatedElement)field);
        Map indexes = ReflectionUtils.getAnnotationsByType(String.class, Index.class, (AnnotatedElement)field);
        Map partitionKeys = ReflectionUtils.getAnnotationsByType(String.class, PartitionKey.class, (AnnotatedElement)field);
        Map clusteringKeys = ReflectionUtils.getAnnotationsByType(String.class, ClusteringKey.class, (AnnotatedElement)field);
        Map typeKeys = ReflectionUtils.getAnnotationsByType(String.class, TypeKey.class, (AnnotatedElement)field);
        boolean bl = isInTable = tinfo.getTable() != null;
        if (isInTable) {
            Validate.isTrue((indexes.isEmpty() || !columns.isEmpty() ? 1 : 0) != 0, (String)"field must be annotated with @Column if it is annotated with @Index: %s.%s", (Object[])new Object[]{this.declaringClass.getName(), field.getName()});
            Validate.isTrue((partitionKeys.isEmpty() || !columns.isEmpty() ? 1 : 0) != 0, (String)"field must be annotated with @Column if it is annotated with @PartitionKey: %s.%s", (Object[])new Object[]{this.declaringClass.getName(), field.getName()});
            Validate.isTrue((clusteringKeys.isEmpty() || !columns.isEmpty() ? 1 : 0) != 0, (String)"field must be annotated with @Column if it is annotated with @ClusteringKey: %s.%s", (Object[])new Object[]{this.declaringClass.getName(), field.getName()});
            Validate.isTrue((typeKeys.isEmpty() || !columns.isEmpty() ? 1 : 0) != 0, (String)"field must be annotated with @Column if it is annotated with @TypeKey: %s.%s", (Object[])new Object[]{this.declaringClass.getName(), field.getName()});
        }
        String tname = isInTable ? tinfo.getTable().name() : "@all";
        Column column = (Column)columns.get(tname);
        Index index = (Index)indexes.get(tname);
        PartitionKey partitionKey = (PartitionKey)partitionKeys.get(tname);
        ClusteringKey clusteringKey = (ClusteringKey)clusteringKeys.get(tname);
        TypeKey typeKey = (TypeKey)typeKeys.get(tname);
        if (column == null) {
            column = (Column)columns.get("@all");
        }
        this.column = column;
        if (index == null) {
            index = (Index)indexes.get("@all");
        }
        this.index = index;
        if (partitionKey == null) {
            partitionKey = (PartitionKey)partitionKeys.get("@all");
        }
        this.partitionKey = partitionKey;
        if (clusteringKey == null) {
            clusteringKey = (ClusteringKey)clusteringKeys.get("@all");
        }
        this.clusteringKey = clusteringKey;
        if (typeKey == null) {
            typeKey = (TypeKey)typeKeys.get("@all");
        }
        this.typeKey = typeKey;
        if (!isInTable) {
            Validate.isTrue((!this.isIndex() ? 1 : 0) != 0, (String)"field cannot be annotated with @Index: %s.%s", (Object[])new Object[]{this.declaringClass.getName(), field.getName()});
            Validate.isTrue((!this.isStatic() ? 1 : 0) != 0, (String)"field cannot be annotated with @Column(isStatic=true): %s.%s", (Object[])new Object[]{this.declaringClass.getName(), field.getName()});
            Validate.isTrue((!this.isPartitionKey() ? 1 : 0) != 0, (String)"field cannot be annotated with @PartitionKey: %s.%s", (Object[])new Object[]{this.declaringClass.getName(), field.getName()});
            Validate.isTrue((!this.isClusteringKey() ? 1 : 0) != 0, (String)"field cannot be annotated with @ClusteringKey: %s.%s", (Object[])new Object[]{this.declaringClass.getName(), field.getName()});
            if (!(this.cinfo instanceof UDTRootClassInfoImpl) && !(this.cinfo instanceof UDTTypeClassInfoImpl)) {
                Validate.isTrue((!this.isTypeKey() ? 1 : 0) != 0, (String)"field cannot be annotated with @TypeKey: %s.%s", (Object[])new Object[]{this.declaringClass.getName(), field.getName()});
            }
        }
        if (this.isColumn()) {
            this.definition = DataTypeImpl.inferDataTypeFrom(field);
            this.decoder = this.definition.getDecoder(field, this.isMandatory() || this.isPartitionKey() || this.isClusteringKey());
            if (!(!isInTable || clusteringKey == null && partitionKey == null || this.definition.getMainType() != DataType.SET && this.definition.getMainType() != DataType.ORDERED_SET)) {
                Type type = field.getGenericType();
                if (!(type instanceof ParameterizedType)) throw new IllegalArgumentException("unable to determine the element type of multi-field in table '" + tname + "': " + this.declaringClass.getName() + "." + field.getName());
                ParameterizedType ptype = (ParameterizedType)type;
                this.multiKeyType = ReflectionUtils.getRawClass((Type)ptype.getActualTypeArguments()[0]);
            } else {
                this.multiKeyType = null;
            }
        } else {
            this.definition = null;
            this.decoder = null;
            this.multiKeyType = null;
        }
        this.getters = new HashMap<Class<? extends T>, Function<Object, Object>>(6);
        this.setters = new HashMap<Class<? extends T>, BiConsumer<Object, Object>>(6);
        this.findGetter(this.declaringClass);
        this.findSetter(this.declaringClass);
        this.finalValue = this.findFinalValue();
        if (!isInTable) return;
        Validate.isTrue((!this.isIndex() || this.isColumn() ? 1 : 0) != 0, (String)"field in table '%s' must be annotated with @Column if it is annotated with @Index: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        Validate.isTrue((!this.isPartitionKey() || !this.isClusteringKey() ? 1 : 0) != 0, (String)"field in table '%s' must not be annotated with @ClusteringKey if it is annotated with @PartitionKey: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        Validate.isTrue((!this.isPartitionKey() || this.isColumn() ? 1 : 0) != 0, (String)"field in table '%s' must be annotated with @Column if it is annotated with @PartitionKey: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        Validate.isTrue((!this.isClusteringKey() || this.isColumn() ? 1 : 0) != 0, (String)"field in table '%s' must be annotated with @Column if it is annotated with @ClusteringKey: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        Validate.isTrue((!this.isTypeKey() || this.isColumn() ? 1 : 0) != 0, (String)"field in table '%s' must be annotated with @Column if it is annotated with @TypeKey: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        Validate.isTrue((!this.isTypeKey() || this.isMandatory() ? 1 : 0) != 0, (String)"field in table '%s' must be annotated with @Mandatory if it is annotated with @TypeKey: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        Validate.isTrue((!this.isTypeKey() || String.class.equals(this.getType()) ? 1 : 0) != 0, (String)"field in table '%s' must be a String if it is annotated with @TypeKey: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        Validate.isTrue((!this.isTypeKey() || !this.isFinal() ? 1 : 0) != 0, (String)"field in table '%s' must not be final if it is annotated with @TypeKey: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        Validate.isTrue((!this.isTypeKey() || this.cinfo instanceof RootClassInfoImpl || this.cinfo instanceof TypeClassInfoImpl || this.cinfo instanceof UDTRootClassInfoImpl || this.cinfo instanceof UDTTypeClassInfoImpl ? 1 : 0) != 0, (String)"field in table '%s' must not be annotated with @TypeKey if class is annotated with @Entity: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        if (this.isColumn() && this.definition.isCollection()) {
            Validate.isTrue((!this.isClusteringKey() && !this.isPartitionKey() || this.multiKeyType != null ? 1 : 0) != 0, (String)"field in table '%s' cannot be '%s' if it is annotated with @ClusteringKey or @PartitionKey: %s.%s", (Object[])new Object[]{tname, this.definition, this.declaringClass.getName(), field.getName()});
        }
        if (!this.isStatic()) return;
        Validate.isTrue((!this.isPartitionKey() ? 1 : 0) != 0, (String)"field in table '%s' cannot be annotated with @Column(isStatic=true) if it is annotated with @PartitionKey: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        Validate.isTrue((!this.isClusteringKey() ? 1 : 0) != 0, (String)"field in table '%s' cannot be annotated with @Column(isStatic=true) if it is annotated with @ClusteringKey: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
        Validate.isTrue((!this.isSuffixKey() ? 1 : 0) != 0, (String)"field in table '%s' cannot be annotated with @Column(isStatic=true) if it is annotated with @SuffixKey: %s.%s", (Object[])new Object[]{tname, this.declaringClass.getName(), field.getName()});
    }

    FieldInfoImpl(ClassInfoImpl<T> cinfo, SuffixKey suffix) {
        this.clazz = cinfo.getObjectClass();
        this.cinfo = cinfo;
        this.tinfo = null;
        this.declaringClass = cinfo.getObjectClass();
        this.field = null;
        this.isFinal = true;
        this.name = suffix.name();
        this.type = String.class;
        this.isOptional = false;
        this.column = null;
        this.persisted = null;
        this.persister = null;
        this.suffix = suffix;
        this.mandatory = true;
        this.index = null;
        this.partitionKey = null;
        this.clusteringKey = null;
        this.typeKey = null;
        this.multiKeyType = null;
        this.definition = null;
        this.decoder = null;
        this.getters = null;
        this.setters = null;
        this.finalValue = null;
    }

    FieldInfoImpl(ClassInfoImpl<T> cinfo, DataType type, BiConsumer<Object, Object> setter) {
        this.clazz = cinfo.getObjectClass();
        this.cinfo = cinfo;
        this.tinfo = null;
        this.declaringClass = cinfo.getObjectClass();
        this.field = null;
        this.isFinal = false;
        this.name = "c_" + type.CQL;
        this.type = this.clazz.getSuperclass();
        this.isOptional = false;
        this.column = new Column(){

            public Class<? extends Annotation> annotationType() {
                return Column.class;
            }

            public String table() {
                return "@all";
            }

            public String name() {
                return FieldInfoImpl.this.getName();
            }

            public boolean isStatic() {
                return false;
            }
        };
        this.persisted = null;
        this.persister = null;
        this.suffix = null;
        this.mandatory = true;
        this.index = null;
        this.partitionKey = null;
        this.clusteringKey = null;
        this.typeKey = null;
        this.multiKeyType = null;
        this.definition = DataTypeImpl.inferDataTypeFrom(type, this.clazz);
        this.decoder = this.definition.getDecoder(this.clazz);
        this.getters = new HashMap<Class<? extends T>, Function<Object, Object>>(6);
        this.setters = new HashMap<Class<? extends T>, BiConsumer<Object, Object>>(6);
        this.getters.put(cinfo.getObjectClass(), obj -> obj);
        this.setters.put(cinfo.getObjectClass(), setter);
        this.finalValue = null;
    }

    private Persister<?, ?> newPersister() {
        Persister persister;
        if (this.persisted.arguments().length == 0) {
            try {
                persister = (Persister)this.persisted.using().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("unable to instantiate persister: " + this.persisted.using().getName(), e);
            }
        }
        try {
            persister = (Persister)this.persisted.using().getConstructor(String[].class).newInstance(new Object[]{this.persisted.arguments()});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalArgumentException("unable to instantiate persister: " + this.persisted.using().getName() + ", using arguments: " + Arrays.toString(this.persisted.arguments()), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("unable to instantiate persister: " + this.persisted.using().getName() + ", using arguments: " + Arrays.toString(this.persisted.arguments()), e.getTargetException());
        }
        Validate.isTrue((persister.getDecodedClass() != null ? 1 : 0) != 0, (String)"@Persisted annotation's persister must be defined with a decoded class: %s", (Object[])new Object[]{this.persisted.using().getName()});
        Validate.isTrue((persister.getPersistedClass() == this.persisted.as().CLASS ? 1 : 0) != 0, (String)"@Persisted annotation's persister must be defined with persisted class '%s': %s", (Object[])new Object[]{this.persisted.as().CLASS.getName(), this.persisted.using().getName()});
        return persister;
    }

    private void findGetter(Class<?> declaringClass) {
        Method getter = this.findGetterMethod(declaringClass, "get");
        if (getter == null && this.type == Boolean.class || this.type == Boolean.TYPE) {
            getter = this.findGetterMethod(declaringClass, "is");
        }
        if (getter != null) {
            Method g = getter;
            this.getters.put(this.cinfo.getObjectClass(), obj -> {
                try {
                    return g.invoke(obj, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(declaringClass.getName(), e);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new IllegalStateException(declaringClass.getName(), t);
                }
            });
        } else {
            this.getters.put(this.cinfo.getObjectClass(), obj -> {
                try {
                    return this.field.get(obj);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(declaringClass.getName(), e);
                }
            });
        }
    }

    private Method findGetterMethod(Class<?> declaringClass, String prefix) {
        String mname = prefix + WordUtils.capitalize((String)this.name, (char[])new char[]{'_', '-'});
        try {
            Method m = declaringClass.getDeclaredMethod(mname, new Class[0]);
            int mods = m.getModifiers();
            if (Modifier.isAbstract(mods) || Modifier.isStatic(mods)) {
                return null;
            }
            Class wtype = ClassUtils.primitiveToWrapper(this.type);
            Class wrtype = ClassUtils.primitiveToWrapper(DataTypeImpl.unwrapOptionalIfPresent(m.getReturnType(), m.getGenericReturnType()));
            Validate.isTrue((boolean)wtype.isAssignableFrom(wrtype), (String)"expecting getter for field '%s' with return type: %s", (Object[])new Object[]{this.field, this.type.getName()});
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private void findSetter(Class<?> declaringClass) {
        block5: {
            String mname = "set" + WordUtils.capitalize((String)this.name, (char[])new char[]{'_', '-'});
            try {
                Method m = declaringClass.getDeclaredMethod(mname, this.field.getType());
                int mods = m.getModifiers();
                if (Modifier.isAbstract(mods) || Modifier.isStatic(mods)) {
                    return;
                }
                Validate.isTrue((m.getParameterCount() == 1 ? 1 : 0) != 0, (String)"expecting setter for field '%s' with one parameter", (Object[])new Object[]{this.field});
                Class wtype = ClassUtils.primitiveToWrapper(this.type);
                Class wptype = ClassUtils.primitiveToWrapper(DataTypeImpl.unwrapOptionalIfPresent(m.getParameterTypes()[0], m.getParameters()[0].getParameterizedType()));
                if (this.isOptional) {
                    Validate.isTrue((boolean)wtype.isAssignableFrom(wptype), (String)"expecting setter for field '%s' with parameter type: Optional<%s>", (Object[])new Object[]{this.field, this.type.getName()});
                } else {
                    Validate.isTrue((boolean)wtype.isAssignableFrom(wptype), (String)"expecting setter for field '%s' with parameter type: %s", (Object[])new Object[]{this.field, this.type.getName()});
                }
                m.setAccessible(true);
                this.setters.put(this.cinfo.getObjectClass(), (obj, val) -> {
                    try {
                        m.invoke(obj, val);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        throw new IllegalStateException(t);
                    }
                });
            }
            catch (NoSuchMethodException e) {
                if (this.isFinal) break block5;
                this.setters.put(this.cinfo.getObjectClass(), (obj, val) -> {
                    try {
                        this.field.set(obj, val);
                    }
                    catch (IllegalAccessException iae) {
                        throw new IllegalStateException(iae);
                    }
                });
            }
        }
    }

    private Object findFinalValue() {
        if (this.isFinal) {
            Object val;
            try {
                val = this.cinfo.getDefaultValue(this.field);
            }
            catch (IllegalArgumentException e) {
                try {
                    Constructor<T> ctor = this.clazz.getDeclaredConstructor(new Class[0]);
                    ctor.setAccessible(true);
                    T t = ctor.newInstance(new Object[0]);
                    val = this.field.get(t);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException ee) {
                    throw new IllegalArgumentException("unable to instantiate object: " + this.clazz.getName(), ee);
                }
                catch (InvocationTargetException ee) {
                    Throwable t = ee.getTargetException();
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new IllegalArgumentException("unable to instantiate object: " + this.clazz.getName(), t);
                }
            }
            if (this.persister != null) {
                String fname = this.declaringClass.getName() + "." + this.name;
                try {
                    val = this.definition.encode(val, this.persisted, this.persister, fname);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("failed to encode final field '" + fname + "' to " + this.persisted.as().CQL + "' with persister: " + this.persister.getClass().getName(), e);
                }
            }
            return val;
        }
        return null;
    }

    private Function<Object, Object> getGetter(Class<?> clazz) {
        while (clazz != null) {
            Function<Object, Object> getter = this.getters.get(clazz);
            if (getter != null) {
                return getter;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private BiConsumer<Object, Object> getSetter(Class<?> clazz) {
        while (clazz != null) {
            BiConsumer<Object, Object> setter = this.setters.get(clazz);
            if (setter != null) {
                return setter;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    void setLast() {
        this.isLast = true;
    }

    public Class<T> getObjectClass() {
        return this.clazz;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public ClassInfo<T> getClassInfo() {
        return this.cinfo;
    }

    public TableInfo<T> getTableInfo() {
        return this.tinfo;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isColumn() {
        return this.column != null;
    }

    public boolean isStatic() {
        return this.column != null && this.column.isStatic();
    }

    public String getColumnName() {
        return this.column != null ? this.column.name() : null;
    }

    public String getSuffixKeyName() {
        return this.suffix != null ? this.suffix.name() : null;
    }

    public DataTypeImpl.Definition getDataType() {
        return this.definition;
    }

    public boolean isSuffixKey() {
        return this.suffix != null;
    }

    public SuffixKey getSuffixKey() {
        return this.suffix;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isIndex() {
        return this.index != null;
    }

    public Index getIndex() {
        return this.index;
    }

    public boolean isCounter() {
        return this.definition != null ? this.definition.getMainType() == DataType.COUNTER : false;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public boolean isPartitionKey() {
        return this.partitionKey != null;
    }

    public PartitionKey getPartitionKey() {
        return this.partitionKey;
    }

    public boolean isClusteringKey() {
        return this.clusteringKey != null;
    }

    public ClusteringKey getClusteringKey() {
        return this.clusteringKey;
    }

    public boolean isTypeKey() {
        return this.typeKey != null;
    }

    public TypeKey getTypeKey() {
        return this.typeKey;
    }

    public boolean isMultiKey() {
        return this.multiKeyType != null;
    }

    public boolean isPersisted() {
        return this.persister != null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateValue(Object value) {
        if (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        if (value == null) {
            Validate.isTrue((!this.isMandatory() ? 1 : 0) != 0, (String)"invalid null value for mandatory column '%s'", (Object[])new Object[]{this.getColumnName()});
            if (this.isPartitionKey() || this.isClusteringKey()) {
                if (!this.isOptional()) throw new IllegalArgumentException("invalid null value for primary key column '" + this.getColumnName() + "'");
                throw new EmptyOptionalPrimaryKeyException("invalid null value for primary key column '" + this.getColumnName() + "'");
            }
            Validate.isTrue((!this.isTypeKey() ? 1 : 0) != 0, (String)"invalid null value for type key column '%s'", (Object[])new Object[]{this.getColumnName()});
        }
        if (this.isColumn()) {
            if (value == null || (this.definition.getMainType() == DataType.BLOB && !this.isPersisted() ? byte[].class : this.type).isInstance(value)) return;
            if (!this.isMultiKey()) throw new IllegalArgumentException("invalid value for column '" + this.getColumnName() + "'; expecting class '" + this.type.getName() + "' but found '" + value.getClass().getName() + "'");
            if (this.multiKeyType.isInstance(value)) return;
            throw new IllegalArgumentException("invalid value for column '" + this.getColumnName() + "'; expecting class '" + this.multiKeyType.getName() + "' or '" + this.type.getName() + "' but found '" + value.getClass().getName() + "'");
        }
        Validate.isTrue((boolean)this.type.isInstance(value), (String)"invalid value for suffix '%s'; expecting class '%s' but found '%s'", (Object[])new Object[]{this.getSuffixKey().name(), this.type.getName(), value != null ? value.getClass().getName() : "null"});
        if (!ArrayUtils.contains((Object[])this.suffix.exclude(), (Object)value)) return;
        throw new ExcludedSuffixKeyException("excluded suffix key '" + this.suffix.name() + "' value '" + value + "' for object class: " + this.clazz.getName());
    }

    private void validateCollectionValue(CQLDataType type, Object value) {
        if (this.persister != null) {
            return;
        }
        CQLDataType dtype = this.definition.getMainType();
        Validate.isTrue((boolean)dtype.isCollection(), (String)"column '%s' is not a collection", (Object[])new Object[]{this.getColumnName()});
        Validate.isTrue((boolean)type.equals(dtype), (String)"column '%s' is not a %s", (Object[])new Object[]{this.getColumnName(), type.name()});
        if (value == null) {
            Validate.isTrue((!this.isPartitionKey() && !this.isClusteringKey() ? 1 : 0) != 0, (String)"invalid null element value for primary key column '%s'", (Object[])new Object[]{this.getColumnName()});
            Validate.isTrue((!this.isTypeKey() ? 1 : 0) != 0, (String)"invalid null element value for type key column '%s'", (Object[])new Object[]{this.getColumnName()});
        }
        CQLDataType etype = this.definition.getElementType();
        Validate.isTrue((boolean)DataTypeImpl.isInstance(etype, value), (String)"invalid element value for column '%s'; expecting type '%s': %s", (Object[])new Object[]{this.getColumnName(), etype.name(), value});
    }

    public void validateListValue(Object value) {
        this.validateCollectionValue(this.definition.getMainType(), value);
    }

    public void validateSetValue(Object value) {
        this.validateCollectionValue(this.definition.getMainType(), value);
    }

    public void validateMapKeyValue(Object key, Object value) {
        this.validateCollectionValue(this.definition.getMainType(), value);
        this.validateMapKey(key);
    }

    public void validateMapKey(Object key) {
        CQLDataType ktype = this.definition.getArgumentTypes().get(0);
        Validate.isTrue((boolean)DataTypeImpl.isInstance(ktype, key), (String)"invalid element key for column '%s'; expecting type '%s': %s", (Object[])new Object[]{this.getColumnName(), ktype.name(), key});
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public Object getFinalValue() {
        return this.finalValue;
    }

    public Object getValue(T object) {
        return this.getValue(Object.class, object);
    }

    public Object getNonEncodedValue(T object) {
        return this.getNonEncodedValue(Object.class, object);
    }

    public Object getValue(Class<?> clazz, T object) {
        return this.encodeValue(this.getNonEncodedValue(clazz, object));
    }

    public Object getNonEncodedValue(Class<?> clazz, T object) {
        String type;
        Object val;
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        Function<Object, Object> getter = this.getGetter(object.getClass());
        Object object2 = val = getter != null ? getter.apply(object) : null;
        if (val instanceof Optional) {
            val = ((Optional)val).orElse(null);
        }
        val = clazz.cast(val);
        if (this.isTypeKey() && !(type = this.cinfo instanceof TypeClassInfoImpl ? ((TypeClassInfoImpl)this.cinfo).getType() : (this.cinfo instanceof RootClassInfoImpl ? ((RootClassInfoImpl)this.cinfo).getType(object.getClass()).getType() : (this.cinfo instanceof UDTTypeClassInfoImpl ? ((UDTTypeClassInfoImpl)this.cinfo).getType() : ((UDTRootClassInfoImpl)this.cinfo).getType(object.getClass()).getType()))).equals(val)) {
            this.setValue(object, type);
            val = clazz.cast(type);
        }
        return val;
    }

    public Object encodeValue(Object val) {
        UDTClassInfoImpl udtcinfo;
        if (val != null && this.definition != null && this.definition.isUserDefined() && (udtcinfo = (UDTClassInfoImpl)this.definition.getMainType()).getObjectClass().isInstance(val)) {
            val = new UDTValueWrapper(udtcinfo, val);
        }
        if (this.persister != null) {
            String fname = this.declaringClass.getName() + "." + this.name;
            try {
                val = this.definition.encode(val, this.persisted, this.persister, fname);
            }
            catch (IOException e) {
                throw new ColumnPersistenceException(this.declaringClass, this.name, "failed to encode field '" + fname + "' to " + this.persisted.as().CQL + " with persister: " + this.persister.getClass().getName(), (Throwable)e);
            }
        }
        return val;
    }

    public Object encodeElementValue(Object val) {
        UDTClassInfoImpl udtcinfo;
        if (val != null && this.definition != null && this.definition.getElementType().isUserDefined() && (udtcinfo = (UDTClassInfoImpl)this.definition.getElementType()).getObjectClass().isInstance(val)) {
            val = new UDTValueWrapper(udtcinfo, val);
        }
        if (this.persister != null) {
            String fname = this.declaringClass.getName() + "." + this.name;
            try {
                val = this.definition.encodeElement(val, this.persisted, this.persister, fname);
            }
            catch (IOException e) {
                throw new ColumnPersistenceException(this.declaringClass, this.name, "failed to encode field '" + fname + "' to " + this.persisted.as().CQL + " with persister: " + this.persister.getClass().getName(), (Throwable)e);
            }
        }
        return val;
    }

    public void setValue(T object, Object value) {
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        BiConsumer<Object, Object> setter = this.getSetter(object.getClass());
        if (setter == null) {
            return;
        }
        if (this.isOptional) {
            value = Optional.ofNullable(value);
        }
        if (value == null) {
            Validate.isTrue((!this.isMandatory() ? 1 : 0) != 0, (String)"invalid null value for mandatory column '%s'", (Object[])new Object[]{this.getColumnName()});
            Validate.isTrue((!this.isPartitionKey() && !this.isClusteringKey() ? 1 : 0) != 0, (String)"invalid null value for primary key column '%s'", (Object[])new Object[]{this.getColumnName()});
            Validate.isTrue((!this.isTypeKey() ? 1 : 0) != 0, (String)"invalid null value for type key column '%s'", (Object[])new Object[]{this.getColumnName()});
        }
        setter.accept(object, value);
    }

    public Object decodeValue(Row row) {
        Object val;
        Validate.notNull((Object)row, (String)"invalid null row", (Object[])new Object[0]);
        if (!row.getColumnDefinitions().contains(this.getColumnName())) {
            if (this.isPartitionKey()) {
                throw new ObjectConversionException(this.clazz, row, "missing partition key '" + this.getColumnName() + "' from result set for field '" + this.declaringClass.getName() + "." + this.name + "'");
            }
            if (this.isClusteringKey()) {
                throw new ObjectConversionException(this.clazz, row, "missing clustering key '" + this.getColumnName() + "' from result set for field '" + this.declaringClass.getName() + "." + this.name + "'");
            }
            if (this.isTypeKey()) {
                throw new ObjectConversionException(this.clazz, row, "missing type key '" + this.getColumnName() + "' from result set for field '" + this.declaringClass.getName() + "." + this.name + "'");
            }
            if (this.isMandatory()) {
                throw new ObjectConversionException(this.clazz, row, "missing mandatory column '" + this.getColumnName() + "' from result set for field '" + this.declaringClass.getName() + "." + this.name + "'");
            }
            throw new ObjectConversionException(this.clazz, row, "missing column '" + this.getColumnName() + "' from result set for field '" + this.declaringClass.getName() + "." + this.name + "'");
        }
        try {
            val = this.decoder.decode(row, this.getColumnName(), this.persister != null ? this.persisted.as().CLASS : this.type);
        }
        catch (InvalidTypeException | IllegalArgumentException e) {
            throw new ObjectConversionException(this.clazz, row, "unable to decode value for field '" + this.declaringClass.getName() + "." + this.name + "'", e);
        }
        if (this.persister != null) {
            String fname = this.declaringClass.getName() + "." + this.name;
            try {
                val = this.definition.decode(val, this.persisted, this.persister, fname);
            }
            catch (Exception e) {
                throw new ObjectConversionException(this.clazz, row, "unable to decode persisted " + this.persisted.as().CQL + " for field '" + fname + "' with persister: " + this.persister.getClass().getName(), (Throwable)e);
            }
        }
        return val;
    }

    public void decodeAndSetValue(T object, Row row) {
        Object val;
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        Validate.notNull((Object)row, (String)"invalid null row", (Object[])new Object[0]);
        if (!row.getColumnDefinitions().contains(this.getColumnName())) {
            if (this.isPartitionKey()) {
                throw new ObjectConversionException(this.clazz, row, "missing partition key '" + this.getColumnName() + "' from result set for field '" + this.declaringClass.getName() + "." + this.name + "'");
            }
            if (this.isClusteringKey()) {
                throw new ObjectConversionException(this.clazz, row, "missing clustering key '" + this.getColumnName() + "' from result set for field '" + this.declaringClass.getName() + "." + this.name + "'");
            }
            if (this.isTypeKey()) {
                throw new ObjectConversionException(this.clazz, row, "missing type key '" + this.getColumnName() + "' from result set for field '" + this.declaringClass.getName() + "." + this.name + "'");
            }
            if (this.isMandatory()) {
                throw new ObjectConversionException(this.clazz, row, "missing mandatory column '" + this.getColumnName() + "' from result set for field '" + this.declaringClass.getName() + "." + this.name + "'");
            }
            return;
        }
        try {
            val = this.decoder.decode(row, this.getColumnName(), this.persister != null ? this.persisted.as().CLASS : this.type);
        }
        catch (InvalidTypeException | IllegalArgumentException e) {
            throw new ObjectConversionException(this.clazz, row, "unable to decode value for field '" + this.declaringClass.getName() + "." + this.name + "'", e);
        }
        if (this.persister != null) {
            String fname = this.declaringClass.getName() + "." + this.name;
            try {
                val = this.definition.decode(val, this.persisted, this.persister, fname);
            }
            catch (Exception e) {
                throw new ObjectConversionException(this.clazz, row, "unable to decode persisted " + this.persisted.as().CQL + " for field '" + fname + "' with persister: " + this.persister.getClass().getName(), (Throwable)e);
            }
        }
        try {
            this.setValue(object, val);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new ObjectConversionException(this.clazz, row, "unable to set field '" + this.declaringClass.getName() + "." + this.name + "' with: " + val, (Throwable)e);
        }
    }

    public Object decodeValue(UDTValue uval) {
        Object val;
        Validate.notNull((Object)uval, (String)"invalid null UDT value", (Object[])new Object[0]);
        if (!uval.getType().contains(this.getColumnName())) {
            if (this.isMandatory()) {
                throw new ObjectConversionException(this.clazz, uval, "missing mandatory column '" + this.getColumnName() + "' from UDT value for field '" + this.declaringClass.getName() + "." + this.name + "'");
            }
            throw new ObjectConversionException(this.clazz, uval, "missing column '" + this.getColumnName() + "' from UDT value for field '" + this.declaringClass.getName() + "." + this.name + "'");
        }
        try {
            val = this.decoder.decode(uval, this.getColumnName(), this.persister != null ? this.persisted.as().CLASS : this.type);
        }
        catch (InvalidTypeException | IllegalArgumentException e) {
            throw new ObjectConversionException(this.clazz, uval, "unable to decode value for field '" + this.declaringClass.getName() + "." + this.name + "'", e);
        }
        if (this.persister != null) {
            String fname = this.declaringClass.getName() + "." + this.name;
            try {
                val = this.definition.decode(val, this.persisted, this.persister, fname);
            }
            catch (Exception e) {
                throw new ObjectConversionException(this.clazz, uval, "unable to decode persisted " + this.persisted.as().CQL + " for field '" + fname + "' with persister: " + this.persister.getClass().getName(), (Throwable)e);
            }
        }
        return val;
    }

    public void decodeAndSetValue(T object, UDTValue uval) {
        Object val;
        Validate.notNull(object, (String)"invalid null object", (Object[])new Object[0]);
        Validate.notNull((Object)uval, (String)"invalid null UDT value", (Object[])new Object[0]);
        if (!uval.getType().contains(this.getColumnName())) {
            if (this.isMandatory()) {
                throw new ObjectConversionException(this.clazz, uval, "missing mandatory column '" + this.getColumnName() + "' from UDT value for field '" + this.declaringClass.getName() + "." + this.name + "'");
            }
            return;
        }
        try {
            val = this.decoder.decode(uval, this.getColumnName(), this.persister != null ? this.persisted.as().CLASS : this.type);
        }
        catch (InvalidTypeException | IllegalArgumentException e) {
            throw new ObjectConversionException(this.clazz, uval, "unable to decode value for field '" + this.declaringClass.getName() + "." + this.name + "'", e);
        }
        if (this.persister != null) {
            String fname = this.declaringClass.getName() + "." + this.name;
            try {
                val = this.definition.decode(val, this.persisted, this.persister, fname);
            }
            catch (Exception e) {
                throw new ObjectConversionException(this.clazz, uval, "unable to decode persisted " + this.persisted.as().CQL + " for field '" + fname + "' with persister: " + this.persister.getClass().getName(), (Throwable)e);
            }
        }
        try {
            this.setValue(object, val);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new ObjectConversionException(this.clazz, uval, "unable to set field '" + this.declaringClass.getName() + "." + this.name + "' with: " + val, (Throwable)e);
        }
    }

    public Stream<UDTClassInfoImpl<?>> udts() {
        return this.definition != null ? this.definition.udts() : Stream.empty();
    }

    public String toString() {
        return "FieldInfoImpl(clazz=" + this.clazz + ", declaringClass=" + this.getDeclaringClass() + ", field=" + this.field + ", name=" + this.getName() + ", type=" + this.getType() + ", isOptional=" + this.isOptional() + ", column=" + this.column + ", persisted=" + this.persisted + ", persister=" + this.persister + ", suffix=" + this.suffix + ", mandatory=" + this.isMandatory() + ", index=" + this.getIndex() + ", partitionKey=" + this.getPartitionKey() + ", clusteringKey=" + this.getClusteringKey() + ", typeKey=" + this.getTypeKey() + ", multiKeyType=" + this.multiKeyType + ", definition=" + this.definition + ", decoder=" + this.decoder + ", isFinal=" + this.isFinal() + ", finalValue=" + this.getFinalValue() + ", setters=" + this.setters + ", getters=" + this.getters + ", isLast=" + this.isLast() + ")";
    }
}

