/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.Clause;
import org.helenus.driver.CreateTable;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.TableWith;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.GroupStatementImpl;
import org.helenus.driver.impl.SimpleStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.TableWithImpl;
import org.helenus.driver.impl.TypeClassInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.info.RootClassInfo;
import org.helenus.driver.persistence.Ordering;

public class CreateTableImpl<T>
extends GroupStatementImpl<Void, VoidFuture, T>
implements CreateTable<T> {
    protected final List<TableInfoImpl<T>> tables = new ArrayList<TableInfoImpl<T>>(8);
    private final OptionsImpl<T> with;
    private volatile boolean ifNotExists;
    private final WhereImpl<T> where;

    public CreateTableImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        this(context, null, mgr, bridge);
    }

    public CreateTableImpl(ClassInfoImpl.Context context, String[] tables, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
        RootClassInfo cinfo = context.getClassInfo();
        if (cinfo instanceof TypeClassInfoImpl) {
            cinfo = ((TypeClassInfoImpl)cinfo).getRoot();
        }
        if (tables != null) {
            for (String table : tables) {
                if (table == null) continue;
                this.tables.add((TableInfoImpl)cinfo.getTable(table));
            }
        } else {
            this.tables.addAll(cinfo.getTablesImpl());
        }
        this.with = new OptionsImpl(this);
        this.where = new WhereImpl(this);
    }

    protected StringBuilder[] buildQueryStrings(TableInfoImpl<T> table) {
        ArrayList<String> columns = new ArrayList<String>(table.getColumns().size());
        ArrayList<String> pkeys = new ArrayList<String>(table.getPartitionKeys().size());
        LinkedHashMap<String, Ordering> ckeys = new LinkedHashMap<String, Ordering>(table.getClusteringKeys().size() * 3 / 2);
        for (FieldInfoImpl<T> field : table.getColumnsImpl()) {
            String cql = field.getColumnName() + " " + field.getDataType().toCQL();
            if (field.isStatic()) {
                cql = cql + " STATIC";
            }
            columns.add(cql);
            if (!field.isMultiKey()) continue;
            columns.add("mk_" + field.getColumnName() + " " + field.getDataType().getFirstArgumentType().toCQL());
        }
        for (FieldInfoImpl<T> field : table.getPartitionKeys()) {
            if (field.isMultiKey()) {
                pkeys.add("mk_" + field.getColumnName());
                continue;
            }
            pkeys.add(field.getColumnName());
        }
        for (FieldInfoImpl<T> field : table.getClusteringKeys()) {
            if (field.isMultiKey()) {
                ckeys.put("mk_" + field.getColumnName(), field.getClusteringKey().order());
                continue;
            }
            ckeys.put(field.getColumnName(), field.getClusteringKey().order());
        }
        ArrayList<String> keys = new ArrayList<String>(ckeys.size() + 1);
        if (pkeys.size() > 1) {
            keys.add("(" + StringUtils.join(pkeys, (String)",") + ")");
        } else {
            keys.add((String)pkeys.get(0));
        }
        keys.addAll(ckeys.keySet());
        columns.add("PRIMARY KEY (" + StringUtils.join(keys, (String)",") + ")");
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        if (this.getKeyspace() != null) {
            Utils.appendName(this.getKeyspace(), builder).append('.');
        }
        Utils.appendName(table.getName(), builder);
        builder.append(" (").append(StringUtils.join(columns, (String)",")).append(')');
        boolean withAdded = false;
        if (!ckeys.isEmpty()) {
            ArrayList<String> order = new ArrayList<String>(ckeys.size());
            for (Map.Entry e : ckeys.entrySet()) {
                order.add((String)e.getKey() + " " + ((Ordering)e.getValue()).CQL);
            }
            builder.append(" WITH CLUSTERING ORDER BY (").append(StringUtils.join(order, (String)",")).append(")");
            withAdded = true;
        }
        if (!((OptionsImpl)this.with).options.isEmpty()) {
            builder.append(withAdded ? " AND " : " WITH ");
            Utils.joinAndAppend(table, builder, " AND ", ((OptionsImpl)this.with).options);
        }
        builder.append(';');
        return new StringBuilder[]{builder};
    }

    @Override
    protected final List<StatementImpl<?, ?, ?>> buildGroupedStatements() {
        return this.tables.stream().map(t -> this.buildQueryStrings((TableInfoImpl<T>)t)).filter(bs -> bs != null).flatMap(bs -> Arrays.stream(bs)).filter(b -> b != null && b.length() != 0).map(b -> this.init(new SimpleStatementImpl(b.toString(), this.mgr, this.bridge))).collect(Collectors.toList());
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        builder.append(" CREATE TABLE");
    }

    public CreateTable<T> ifNotExists() {
        this.ifNotExists = true;
        this.setDirty();
        return this;
    }

    public CreateTable.Options<T> with(TableWith option) {
        return this.with.and(option);
    }

    public CreateTable.Options<T> with() {
        return this.with;
    }

    public CreateTable.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public CreateTable.Where<T> where() {
        return this.where;
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, CreateTableImpl<T>>
    implements CreateTable.Where<T> {
        WhereImpl(CreateTableImpl<T> statement) {
            super(statement);
        }

        public CreateTable.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            Validate.isTrue((!(clause instanceof ClauseImpl.DelayedWithObject) ? 1 : 0) != 0, (String)"unsupported clause '%s' for a CREATE TABLE statement", (Object[])new Object[]{clause});
            if (clause instanceof ClauseImpl.Delayed) {
                for (Clause clause2 : ((ClauseImpl.Delayed)clause).processWith(((CreateTableImpl)this.statement).getContext().getClassInfo())) {
                    this.and(clause2);
                }
            } else {
                ClauseImpl c = (ClauseImpl)clause;
                Validate.isTrue((boolean)(clause instanceof Clause.Equality), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
                ((CreateTableImpl)this.statement).getContext().addSuffix(c.getColumnName().toString(), c.firstValue());
                this.setDirty();
            }
            return this;
        }
    }

    public static class OptionsImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, CreateTableImpl<T>>
    implements CreateTable.Options<T> {
        private final List<TableWithImpl> options = new ArrayList<TableWithImpl>(8);

        OptionsImpl(CreateTableImpl<T> statement) {
            super(statement);
        }

        public CreateTable.Options<T> and(TableWith option) {
            Validate.notNull((Object)option, (String)"invalid null with", (Object[])new Object[0]);
            Validate.isTrue((boolean)(option instanceof TableWithImpl), (String)"unsupported class of withs: %s", (Object[])new Object[]{option.getClass().getName()});
            this.options.add((TableWithImpl)option);
            this.setDirty();
            return this;
        }

        public CreateTable.Where<T> where(Clause clause) {
            return ((CreateTableImpl)this.statement).where.and(clause);
        }

        public CreateTable.Where<T> where() {
            return ((CreateTableImpl)this.statement).where;
        }
    }
}

