/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.driver.BatchableStatement;
import org.helenus.driver.Clause;
import org.helenus.driver.CreateSchema;
import org.helenus.driver.ExcludedSuffixKeyException;
import org.helenus.driver.GroupableStatement;
import org.helenus.driver.ParentStatement;
import org.helenus.driver.SequenceableStatement;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.CreateIndexImpl;
import org.helenus.driver.impl.CreateKeyspaceImpl;
import org.helenus.driver.impl.CreateTableImpl;
import org.helenus.driver.impl.CreateTypeImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.GroupImpl;
import org.helenus.driver.impl.InsertImpl;
import org.helenus.driver.impl.ParentStatementImpl;
import org.helenus.driver.impl.SequenceImpl;
import org.helenus.driver.impl.SequenceStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.persistence.Keyspace;
import org.helenus.driver.persistence.Table;

public class CreateSchemaImpl<T>
extends SequenceStatementImpl<Void, VoidFuture, T>
implements CreateSchema<T> {
    private volatile boolean ifNotExists;
    private final WhereImpl<T> where = new WhereImpl(this);

    public CreateSchemaImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        builder.append(" CREATE");
    }

    @Override
    protected void appendGroupType(StringBuilder builder) {
        builder.append("SCHEMA");
    }

    @Override
    protected List<StatementImpl<?, ?, ?>> buildSequencedStatements() {
        GroupImpl kgroup = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        GroupImpl tgroup = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        GroupImpl igroup = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        SequenceImpl yseq = this.init(new SequenceImpl(Optional.empty(), new SequenceableStatement[0], this.mgr, this.bridge));
        GroupImpl group = this.init(new GroupImpl(Optional.empty(), new GroupableStatement[0], this.mgr, this.bridge));
        this.buildSequencedStatements(null, null, kgroup, tgroup, igroup, yseq, group);
        return Stream.of(kgroup, yseq, tgroup, igroup, group).filter(g -> !((ParentStatement)g).isEmpty()).collect(Collectors.toList());
    }

    public void buildSequencedStatements(Set<Pair<String, Keyspace>> keyspaces, Map<Pair<String, Keyspace>, Set<Table>> tables, GroupImpl kgroup, GroupImpl tgroup, GroupImpl igroup, ParentStatementImpl yparent, GroupImpl group) {
        String ks;
        if (!this.isEnabled()) {
            return;
        }
        try {
            ks = this.getKeyspace();
        }
        catch (ExcludedSuffixKeyException e) {
            return;
        }
        Keyspace keyspace = this.getContext().getClassInfo().getKeyspace();
        Pair pk = Pair.of((Object)ks, (Object)keyspace);
        if (keyspaces == null || !keyspaces.contains(pk)) {
            CreateKeyspaceImpl ck = this.init(new CreateKeyspaceImpl(this.getContext(), this.mgr, this.bridge));
            if (this.ifNotExists) {
                ck.ifNotExists();
            }
            kgroup.add(ck);
            if (keyspaces != null) {
                keyspaces.add((Pair<String, Keyspace>)pk);
            }
        }
        if (this.getClassInfo().supportsTablesAndIndexes()) {
            boolean createTable = true;
            if (tables != null) {
                createTable = false;
                for (TableInfoImpl table : this.getContext().getClassInfo().getTablesImpl()) {
                    Set<Table> stables = tables.get(pk);
                    if (stables == null) {
                        stables = new HashSet<Table>(8);
                        tables.put((Pair<String, Keyspace>)pk, stables);
                    }
                    if (!stables.add(table.getTable())) continue;
                    createTable = true;
                }
            }
            if (createTable) {
                CreateTableImpl ct = this.init(new CreateTableImpl(this.getContext(), null, this.mgr, this.bridge));
                CreateIndexImpl ci = this.init(new CreateIndexImpl(this.getContext(), null, null, this.mgr, this.bridge));
                if (this.ifNotExists) {
                    ct.ifNotExists();
                    ci.ifNotExists();
                }
                ct.buildGroupedStatements().forEach(s -> tgroup.addInternal((StatementImpl<?, ?, ?>)s));
                ci.buildGroupedStatements().forEach(s -> igroup.addInternal((StatementImpl<?, ?, ?>)s));
            }
        } else {
            CreateTypeImpl ct = this.init(new CreateTypeImpl(this.getContext(), this.mgr, this.bridge));
            if (this.ifNotExists) {
                ct.ifNotExists();
            }
            if (yparent instanceof SequenceImpl) {
                ((SequenceImpl)yparent).add(ct);
            } else if (yparent instanceof GroupImpl) {
                ((GroupImpl)yparent).add(ct);
            } else {
                throw new IllegalStateException("invalid parent statement passed for types: " + yparent.getClass().getSimpleName());
            }
        }
        Collection objs = this.getContext().getInitialObjects();
        if (!objs.isEmpty()) {
            for (TableInfoImpl io : objs) {
                group.add((BatchableStatement)this.init(new InsertImpl(this.getContext().getClassInfo().newContext(io), (String[])null, this.mgr, this.bridge)));
            }
        }
    }

    public Set<Class<?>> getObjectClasses() {
        return this.getContext().getClassInfo().objectClasses().collect(Collectors.toSet());
    }

    public Set<ClassInfo<?>> getClassInfos() {
        return this.getContext().getClassInfo().classInfos().collect(Collectors.toSet());
    }

    public CreateSchema<T> ifNotExists() {
        this.ifNotExists = true;
        this.setDirty();
        return this;
    }

    public CreateSchema.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public CreateSchema.Where<T> where() {
        return this.where;
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, CreateSchemaImpl<T>>
    implements CreateSchema.Where<T> {
        WhereImpl(CreateSchemaImpl<T> statement) {
            super(statement);
        }

        public CreateSchema.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            Validate.isTrue((!(clause instanceof ClauseImpl.DelayedWithObject) ? 1 : 0) != 0, (String)"unsupported clause '%s' for a CREATE SCHEMA statement", (Object[])new Object[]{clause});
            if (clause instanceof ClauseImpl.Delayed) {
                for (Clause clause2 : ((ClauseImpl.Delayed)clause).processWith(((CreateSchemaImpl)this.statement).getContext().getClassInfo())) {
                    this.and(clause2);
                }
            } else {
                ClauseImpl c = (ClauseImpl)clause;
                Validate.isTrue((boolean)(clause instanceof Clause.Equality), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
                ((CreateSchemaImpl)this.statement).getContext().addSuffix(c.getColumnName().toString(), c.firstValue());
                this.setDirty();
            }
            return this;
        }
    }
}

