/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.driver.BindMarker;
import org.helenus.driver.Clause;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.persistence.CQLDataType;

public abstract class ClauseImpl
extends Utils.Appendeable
implements Clause {
    protected final CharSequence name;

    ClauseImpl(CharSequence name) {
        Validate.notNull((Object)name, (String)"invalid null column name", (Object[])new Object[0]);
        this.name = name;
    }

    CharSequence getColumnName() {
        return this.name;
    }

    Object firstValue() {
        return null;
    }

    Collection<?> values() {
        return null;
    }

    abstract String getOperation();

    abstract <T> void validate(TableInfoImpl<T> var1);

    static class IsSuffixedLikeObjectClauseImpl
    extends ClauseImpl
    implements DelayedWithObject {
        IsSuffixedLikeObjectClauseImpl() {
            super("");
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table, ClassInfoImpl.POJOContext context) {
            Map<String, Pair<Object, CQLDataType>> pkeys = context.getSuffixKeyValues();
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(pkeys.size());
            for (Map.Entry<String, Pair<Object, CQLDataType>> e : pkeys.entrySet()) {
                clauses.add(new EqClauseImpl((CharSequence)e.getKey(), e.getValue()));
            }
            return clauses;
        }

        @Override
        String getOperation() {
            return "IS SUFFIXED LIKE OBJECT";
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            throw new IllegalStateException("should not be called");
        }
    }

    static class IsPartitionedLikeObjectClauseImpl
    extends ClauseImpl
    implements DelayedWithObject {
        IsPartitionedLikeObjectClauseImpl() {
            super("");
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table, ClassInfoImpl.POJOContext context) {
            Map<String, Pair<Object, CQLDataType>> pkeys = context.getSuffixAndPartitionKeyColumnValues(table.getName());
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(pkeys.size());
            for (Map.Entry<String, Pair<Object, CQLDataType>> e : pkeys.entrySet()) {
                clauses.add(new EqClauseImpl((CharSequence)e.getKey(), e.getValue()));
            }
            return clauses;
        }

        @Override
        String getOperation() {
            return "IS PARTITIONED LIKE OBJECT";
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            throw new IllegalStateException("should not be called");
        }
    }

    static class IsObjectClauseImpl
    extends ClauseImpl
    implements DelayedWithObject {
        IsObjectClauseImpl() {
            super("");
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table, ClassInfoImpl.POJOContext context) {
            Map<String, Pair<Object, CQLDataType>> pkeys = context.getSuffixAndPrimaryKeyColumnValues(table.getName());
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(pkeys.size());
            for (Map.Entry<String, Pair<Object, CQLDataType>> e : pkeys.entrySet()) {
                clauses.add(new EqClauseImpl((CharSequence)e.getKey(), e.getValue()));
            }
            return clauses;
        }

        @Override
        String getOperation() {
            return "IS OBJECT";
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            throw new IllegalStateException("should not be called");
        }
    }

    static class IsSuffixedLikeClauseImpl
    extends IsClauseImpl {
        IsSuffixedLikeClauseImpl(Object object) {
            super(object);
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table) {
            Validate.isTrue((boolean)table.getObjectClass().isInstance(this.object), (String)("invalid POJO class '" + this.object.getClass().getName() + "'; expecting '" + table.getObjectClass().getName() + "'"), (Object[])new Object[0]);
            Map keys = ((ClassInfoImpl)table.getClassInfo()).getSuffixKeys();
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(keys.size());
            for (Map.Entry e : keys.entrySet()) {
                clauses.add(new EqClauseImpl((CharSequence)e.getKey(), e.getValue().getValue(this.object)));
            }
            return clauses;
        }

        @Override
        String getOperation() {
            return "IS SUFFIXED LIKE";
        }
    }

    static class IsPartitionedLikeClauseImpl
    extends IsClauseImpl {
        IsPartitionedLikeClauseImpl(Object object) {
            super(object);
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table) {
            Validate.isTrue((boolean)table.getObjectClass().isInstance(this.object), (String)("invalid POJO class '" + this.object.getClass().getName() + "'; expecting '" + table.getObjectClass().getName() + "'"), (Object[])new Object[0]);
            Collection<FieldInfoImpl<T>> keys = table.getSuffixAndPartitionKeys();
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(keys.size());
            for (FieldInfoImpl<Object> fieldInfoImpl : keys) {
                String name = fieldInfoImpl.isColumn() ? fieldInfoImpl.getColumnName() : fieldInfoImpl.getSuffixKeyName();
                clauses.add(new EqClauseImpl((CharSequence)name, fieldInfoImpl.getValue(this.object)));
            }
            return clauses;
        }

        @Override
        String getOperation() {
            return "IS PARTITIONED LIKE";
        }
    }

    static class IsClauseImpl
    extends ClauseImpl
    implements Delayed {
        protected final Object object;

        IsClauseImpl(Object object) {
            super("");
            Validate.notNull((Object)object, (String)"invalid null object", (Object[])new Object[0]);
            this.object = object;
        }

        @Override
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> table) {
            Validate.isTrue((boolean)table.getObjectClass().isInstance(this.object), (String)("invalid POJO class '" + this.object.getClass().getName() + "'; expecting '" + table.getObjectClass().getName() + "'"), (Object[])new Object[0]);
            Collection<FieldInfoImpl<T>> keys = table.getSuffixAndPrimaryKeys();
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(keys.size());
            for (FieldInfoImpl<Object> fieldInfoImpl : keys) {
                String name = fieldInfoImpl.isColumn() ? fieldInfoImpl.getColumnName() : fieldInfoImpl.getSuffixKeyName();
                clauses.add(new EqClauseImpl((CharSequence)name, fieldInfoImpl.getValue(this.object)));
            }
            return clauses;
        }

        @Override
        public <T> List<ClauseImpl> processWith(ClassInfoImpl<T> cinfo) {
            Validate.isTrue((boolean)cinfo.getObjectClass().isInstance(this.object), (String)("invalid POJO class '" + this.object.getClass().getName() + "'; expecting '" + cinfo.getObjectClass().getName() + "'"), (Object[])new Object[0]);
            Collection<FieldInfoImpl<T>> keys = cinfo.getSuffixKeys().values();
            ArrayList<ClauseImpl> clauses = new ArrayList<ClauseImpl>(keys.size());
            for (FieldInfoImpl<Object> fieldInfoImpl : keys) {
                clauses.add(new EqClauseImpl((CharSequence)fieldInfoImpl.getSuffixKeyName(), fieldInfoImpl.getValue(this.object)));
            }
            return clauses;
        }

        @Override
        String getOperation() {
            return "IS";
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            throw new IllegalStateException("should not be called");
        }
    }

    static class InClauseImpl
    extends ClauseImpl
    implements Clause.In {
        private final Collection<?> values;

        InClauseImpl(CharSequence name, Collection<?> values) {
            super(name);
            this.values = values;
            Validate.isTrue((!CollectionUtils.isEmpty(values) ? 1 : 0) != 0, (String)"missing values for IN clause", (Object[])new Object[0]);
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
            Object fv = this.firstValue();
            if (this.values.size() == 1 && (fv instanceof BindMarker || fv instanceof com.datastax.driver.core.querybuilder.BindMarker)) {
                Utils.appendName(this.name, sb).append("IN ").append(fv);
                return;
            }
            Utils.appendName(this.name, sb).append(" IN (");
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            if (finfo == null) {
                String sname = this.name.toString();
                if (sname.startsWith("mk_") && (finfo = tinfo.getColumnImpl(sname = sname.substring("mk_".length()))) != null && finfo.isMultiKey()) {
                    if (finfo.isPersisted()) {
                        ArrayList<Object> pvals = new ArrayList<Object>(this.values.size());
                        for (Object val : this.values) {
                            pvals.add(finfo.encodeElementValue(val));
                        }
                        Utils.joinAndAppendValues(sb, ",", pvals, finfo.getDataType().getElementType()).append(")");
                    } else {
                        Utils.joinAndAppendValues(sb, ",", this.values, finfo.getDataType().getElementType()).append(")");
                    }
                    return;
                }
                throw new IllegalStateException("unknown column '" + this.name + "'");
            }
            if (finfo.isPersisted()) {
                ArrayList<Object> pvals = new ArrayList<Object>(this.values.size());
                for (Object val : this.values) {
                    pvals.add(finfo.encodeValue(val));
                }
                Utils.joinAndAppendValues(sb, ",", pvals, finfo.getDataType().getElementType()).append(")");
            } else {
                Utils.joinAndAppendValues(sb, ",", this.values, finfo.getDataType().getElementType()).append(")");
            }
        }

        @Override
        Object firstValue() {
            return this.values.iterator().next();
        }

        @Override
        Collection<?> values() {
            return this.values;
        }

        @Override
        String getOperation() {
            return "IN";
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            table.validateColumnAndValues(this.name, this.values);
        }
    }

    static class EqClauseImpl
    extends SimpleClauseImpl
    implements Clause.Equality {
        EqClauseImpl(CharSequence name, Object value) {
            super(name, "=", value);
        }

        EqClauseImpl(CharSequence name, Pair<Object, CQLDataType> pvalue) {
            super(name, "=", pvalue);
        }

        EqClauseImpl(CharSequence name, Object value, CQLDataType definition) {
            super(name, "=", value, definition);
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            table.validateSuffixOrColumnAndValue(this.name, this.value);
        }
    }

    static class SimpleClauseImpl
    extends ClauseImpl {
        private final String op;
        protected final Object value;
        protected final CQLDataType definition;

        SimpleClauseImpl(CharSequence name, String op, Object value) {
            this(name, op, value, null);
        }

        SimpleClauseImpl(CharSequence name, String op, Pair<Object, CQLDataType> pvalue) {
            super(name);
            Validate.notNull((Object)op, (String)"invalid null operation", (Object[])new Object[0]);
            this.op = op;
            if (pvalue != null) {
                this.value = pvalue.getLeft();
                this.definition = (CQLDataType)pvalue.getRight();
            } else {
                this.value = null;
                this.definition = null;
            }
        }

        SimpleClauseImpl(CharSequence name, String op, Object value, CQLDataType definition) {
            super(name);
            Validate.notNull((Object)op, (String)"invalid null operation", (Object[])new Object[0]);
            this.op = op;
            this.value = value;
            this.definition = definition;
        }

        @Override
        void appendTo(TableInfoImpl<?> tinfo, StringBuilder sb) {
            Utils.appendName(this.name, sb).append(this.op);
            FieldInfoImpl<?> finfo = tinfo.getColumnImpl(this.name);
            if (finfo == null) {
                String sname = this.name.toString();
                if (sname.startsWith("mk_") && (finfo = tinfo.getColumnImpl(sname = sname.substring("mk_".length()))) != null && finfo.isMultiKey()) {
                    Utils.appendValue(finfo.encodeElementValue(this.value), this.definition != null ? this.definition : finfo.getDataType().getElementType(), sb);
                    return;
                }
                throw new IllegalStateException("unknown column '" + this.name + "'");
            }
            Utils.appendValue(finfo.encodeValue(this.value), (CQLDataType)(this.definition != null ? this.definition : finfo.getDataType()), sb);
        }

        @Override
        Object firstValue() {
            return this.value;
        }

        @Override
        Collection<?> values() {
            return Collections.singleton(this.value);
        }

        @Override
        String getOperation() {
            return this.op;
        }

        @Override
        <T> void validate(TableInfoImpl<T> table) {
            table.validateColumnAndValue(this.name, this.value);
        }
    }

    static interface DelayedWithObject {
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> var1, ClassInfoImpl.POJOContext var2);
    }

    static interface Delayed {
        public <T> List<ClauseImpl> processWith(TableInfoImpl<T> var1);

        public <T> List<ClauseImpl> processWith(ClassInfoImpl<T> var1);
    }
}

