/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.DataTypeParser;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.CreateTableImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.Utils;
import org.helenus.driver.persistence.CQLDataType;
import org.helenus.driver.persistence.Ordering;

public class AlterCreateTableImpl<T>
extends CreateTableImpl<T> {
    private final Map<String, List<Row>> tinfos;

    public AlterCreateTableImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        super(context, null, mgr, bridge);
        this.ifNotExists();
        this.tinfos = this.tables.stream().collect(Collectors.toMap(t -> t.getName(), t -> mgr.getSession().executeAsync((Statement)new SimpleStatement("SELECT column_name,component_index,type,validator,index_name FROM system.schema_columns WHERE keyspace_name='" + this.getKeyspace() + "' and columnfamily_name='" + t.getName() + "'")).getUninterruptibly().all()));
    }

    @Override
    protected StringBuilder[] buildQueryStrings(TableInfoImpl<T> table) {
        List<Row> rows = this.tinfos.get(table.getName());
        if (CollectionUtils.isEmpty(rows)) {
            return super.buildQueryStrings(table);
        }
        HashMap<String, CQLDataType> columns = new HashMap<String, CQLDataType>(table.getColumns().size() * 3 / 2);
        ArrayList<String> pkeys = new ArrayList<String>(table.getPartitionKeys().size());
        LinkedHashMap<String, Ordering> ckeys = new LinkedHashMap<String, Ordering>(table.getClusteringKeys().size() * 3 / 2);
        for (FieldInfoImpl<T> field : table.getColumnsImpl()) {
            columns.put(field.getColumnName(), field.getDataType());
            if (!field.isMultiKey()) continue;
            columns.put("mk_" + field.getColumnName(), field.getDataType().getFirstArgumentType());
        }
        for (FieldInfoImpl<T> field : table.getPartitionKeys()) {
            if (field.isMultiKey()) {
                pkeys.add("mk_" + field.getColumnName());
                continue;
            }
            pkeys.add(field.getColumnName());
        }
        for (FieldInfoImpl<T> field : table.getClusteringKeys()) {
            if (field.isMultiKey()) {
                ckeys.put("mk_" + field.getColumnName(), field.getClusteringKey().order());
                continue;
            }
            ckeys.put(field.getColumnName(), field.getClusteringKey().order());
        }
        ArrayList<String> columns0 = new ArrayList<String>(table.getColumns().size());
        ArrayList<String> pkeys0 = new ArrayList<String>(table.getPartitionKeys().size());
        ArrayList<Pair> ckeys0 = new ArrayList<Pair>(table.getClusteringKeys().size());
        for (Row row : rows) {
            String string = row.getString(0);
            String val0 = row.getString(3);
            CQLDataType type = (CQLDataType)columns.remove(string);
            if (type == null) {
                columns0.add("DROP " + string);
            } else {
                CQLDataType type0 = DataTypeParser.validatorToCQL(val0);
                String type0_cql = type0.toCQL();
                String type_cql = type.toCQL();
                if (!type_cql.equals(type0_cql)) {
                    Validate.isTrue((boolean)type0.isAlterableTo(type), (String)"column '%s' for entity '%s' cannot be altered from %s to %s", (Object[])new Object[]{string, this.getObjectClass().getName(), type0_cql, type_cql});
                    columns0.add("ALTER " + string + " TYPE " + type_cql);
                }
            }
            int index = row.isNull(1) ? 0 : row.getInt(1);
            switch (row.getString(2)) {
                case "regular": {
                    break;
                }
                case "clustering_key": {
                    while (ckeys0.size() <= index) {
                        ckeys0.add(null);
                    }
                    ckeys0.set(index, Pair.of((Object)string, (Object)DataTypeParser.getOrderingFrom(val0)));
                    break;
                }
                case "partition_key": {
                    while (pkeys0.size() <= index) {
                        pkeys0.add(null);
                    }
                    pkeys0.set(index, string);
                }
            }
        }
        Validate.isTrue((boolean)pkeys0.equals(pkeys), (String)"partition key definition has changed; expecting '%s'", (Object[])new Object[]{pkeys0});
        int i = 0;
        for (Map.Entry entry : ckeys.entrySet()) {
            Pair p;
            Validate.isTrue((((String)(p = (Pair)ckeys0.get(i++)).getLeft()).equals(entry.getKey()) && ((Ordering)p.getRight()).equals(entry.getValue()) ? 1 : 0) != 0, (String)"clustering key definition has changed; expecting '%s'", (Object[])new Object[]{ckeys0.stream().map(pp -> (String)pp.getLeft() + '=' + pp.getRight()).collect(Collectors.joining(" ,", "{", "}"))});
        }
        columns.forEach((n, t) -> columns0.add("ADD " + n + " " + t.toCQL()));
        if (columns.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ALTER TABLE ");
        if (this.getKeyspace() != null) {
            Utils.appendName(this.getKeyspace(), stringBuilder).append('.');
        }
        Utils.appendName(table.getName(), stringBuilder);
        stringBuilder.append(' ');
        return (StringBuilder[])columns0.stream().map(inst -> new StringBuilder(builder).append((String)inst)).toArray(StringBuilder[]::new);
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        builder.append(" ALTER TABLE");
    }

    public Map<String, List<Row>> getTableInfos() {
        return this.tinfos;
    }
}

