/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ArrayBackedResultSet;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSet;
import com.google.common.util.concurrent.ExecutionList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.StatementManager;

public class EmptyResultSetFuture
extends DefaultResultSetFuture {
    private static final ExecutionList execution = new ExecutionList();
    private final ResultSet empty;

    public EmptyResultSetFuture(StatementManager mgr) {
        super(null, mgr.getCluster().getConfiguration().getProtocolOptions().getProtocolVersionEnum(), null);
        Validate.notNull((Object)mgr, (String)"invalid null mgr", (Object[])new Object[0]);
        this.empty = ArrayBackedResultSet.fromMessage((Responses.Result)new Responses.Result(Responses.Result.Kind.VOID){}, null, (ProtocolVersion)mgr.getCluster().getConfiguration().getProtocolOptions().getProtocolVersionEnum(), null, null);
    }

    public ResultSet getUninterruptibly() {
        return this.empty;
    }

    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        return this.empty;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public ResultSet get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        return this.empty;
    }

    public ResultSet get() throws InterruptedException, ExecutionException {
        return this.empty;
    }

    public boolean isDone() {
        return true;
    }

    public boolean isCancelled() {
        return false;
    }

    public void addListener(Runnable listener, Executor exec) {
        execution.add(listener, exec);
    }

    static {
        execution.execute();
    }
}

