/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hector.testutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import me.prettyprint.hector.testutils.EmbeddedSchemaLoader;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.thrift.CassandraDaemon;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedServerHelper {
    private static Logger log = LoggerFactory.getLogger(EmbeddedServerHelper.class);
    private static final String TMP = "tmp";
    private final String yamlFile;
    static CassandraDaemon cassandraDaemon;
    static ExecutorService executor;

    public EmbeddedServerHelper() {
        this("/cassandra.yaml");
    }

    public EmbeddedServerHelper(String yamlFile) {
        this.yamlFile = yamlFile;
    }

    public void setup() throws TTransportException, IOException, InterruptedException, ConfigurationException {
        EmbeddedServerHelper.rmdir(TMP);
        EmbeddedServerHelper.copy("/log4j.properties", TMP);
        EmbeddedServerHelper.copy(this.yamlFile, TMP);
        System.setProperty("cassandra.config", "file:tmp/" + this.yamlFile.substring(this.yamlFile.lastIndexOf("/") + 1));
        System.setProperty("log4j.configuration", "file:tmp/log4j.properties");
        System.setProperty("cassandra-foreground", "true");
        EmbeddedServerHelper.cleanupAndLeaveDirs();
        EmbeddedServerHelper.loadSchemaFromYaml();
        log.info("Starting executor");
        executor.execute(new CassandraRunner());
        log.info("Started executor");
        try {
            TimeUnit.SECONDS.sleep(3L);
            log.info("Done sleeping");
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void teardown() {
        executor.shutdown();
        executor.shutdownNow();
        log.info("Teardown complete");
    }

    private static void rmdir(String dir) throws IOException {
        File dirFile = new File(dir);
        if (dirFile.exists()) {
            FileUtils.deleteRecursive((File)new File(dir));
        }
    }

    private static void copy(String resource, String directory) throws IOException {
        int len;
        EmbeddedServerHelper.mkdir(directory);
        InputStream is = EmbeddedServerHelper.class.getResourceAsStream(resource);
        String fileName = resource.substring(resource.lastIndexOf("/") + 1);
        File file = new File(directory + System.getProperty("file.separator") + fileName);
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        is.close();
    }

    private static void mkdir(String dir) throws IOException {
        FileUtils.createDirectory((String)dir);
    }

    public static void cleanupAndLeaveDirs() throws IOException {
        EmbeddedServerHelper.mkdirs();
        EmbeddedServerHelper.cleanup();
        EmbeddedServerHelper.mkdirs();
        CommitLog.instance.resetUnsafe();
    }

    public static void cleanup() throws IOException {
        File dir;
        String[] directoryNames;
        for (String dirName : directoryNames = new String[]{DatabaseDescriptor.getCommitLogLocation()}) {
            dir = new File(dirName);
            if (!dir.exists()) {
                throw new RuntimeException("No such directory: " + dir.getAbsolutePath());
            }
            FileUtils.deleteRecursive((File)dir);
        }
        for (String dirName : DatabaseDescriptor.getAllDataFileLocations()) {
            dir = new File(dirName);
            if (!dir.exists()) {
                throw new RuntimeException("No such directory: " + dir.getAbsolutePath());
            }
            FileUtils.deleteRecursive((File)dir);
        }
    }

    public static void mkdirs() {
        try {
            DatabaseDescriptor.createAllDirectories();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadSchemaFromYaml() {
        EmbeddedSchemaLoader.loadSchema();
    }

    static {
        executor = Executors.newSingleThreadExecutor();
    }

    class CassandraRunner
    implements Runnable {
        CassandraRunner() {
        }

        @Override
        public void run() {
            cassandraDaemon = new CassandraDaemon();
            cassandraDaemon.activate();
        }
    }
}

