/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.cache;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.ClassCacheMgr;
import me.prettyprint.hom.annotations.AnonymousPropertyHandling;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import me.prettyprint.hom.cache.ParserValidator;

public class AnonymousParserValidator
implements ParserValidator {
    @Override
    public <T> void parse(ClassCacheMgr cacheMgr, Annotation anno, CFMappingDef<T> cfMapDef) {
        if (!(anno instanceof AnonymousPropertyHandling)) {
            throw new HectorObjectMapperException("This class cannot parse annotation, " + anno.getClass().getSimpleName());
        }
        this.parseInheritanceAnnotation((AnonymousPropertyHandling)anno, cfMapDef);
    }

    private <T> void parseInheritanceAnnotation(AnonymousPropertyHandling anno, CFMappingDef<T> cfMapDef) {
        Method getMeth;
        Method addMeth;
        cfMapDef.setAnonymousValueType(anno.type());
        try {
            cfMapDef.setAnonymousValueSerializer(this.instantiateSerializer(anno.serializer()));
        }
        catch (Throwable e) {
            throw new HectorObjectMapperException("exception while instantiating anonymous converter for class, " + cfMapDef.getRealClass() + ", with converter type, " + anno.serializer(), e);
        }
        try {
            addMeth = cfMapDef.getRealClass().getMethod(anno.adder(), String.class, anno.type());
        }
        catch (NoSuchMethodException e) {
            throw new HectorObjectMapperException("Could not find anonymous add handler for class, " + cfMapDef.getRealClass() + ", with anonymous value type, " + anno.type());
        }
        catch (Throwable e) {
            throw new HectorObjectMapperException("exception while finding anonymous add handler for class, " + cfMapDef.getRealClass() + ", with anonymous value type, " + anno.type(), e);
        }
        try {
            getMeth = cfMapDef.getRealClass().getMethod(anno.getter(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HectorObjectMapperException("Could not find anonymous get handler for class, " + cfMapDef.getRealClass());
        }
        catch (Throwable e) {
            throw new HectorObjectMapperException("exception while finding anonymous get handler for class, " + cfMapDef.getRealClass());
        }
        cfMapDef.setAnonymousPropertyAddHandler(addMeth);
        cfMapDef.setAnonymousPropertyGetHandler(getMeth);
    }

    @Override
    public <T> void validateAndSetDefaults(ClassCacheMgr cacheMgr, CFMappingDef<T> cfMapDef) {
    }

    private Serializer instantiateSerializer(Class ser) {
        try {
            return (Serializer)ser.getMethod("get", new Class[0]).invoke(null, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            try {
                return (Serializer)ser.newInstance();
            }
            catch (Throwable e1) {
                throw new HectorObjectMapperException("exception while instantiating Hector serializer, " + ser.getName());
            }
        }
        catch (Throwable e) {
            throw new HectorObjectMapperException("exception while instantiating Hector serializer, " + ser.getName());
        }
    }
}

