/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.persistence.DiscriminatorType;
import javax.persistence.Id;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.SerializerTypeInferer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.SliceQuery;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.ClassCacheMgr;
import me.prettyprint.hom.CollectionMapperHelper;
import me.prettyprint.hom.KeyConcatenationDelimiterStrategyImpl;
import me.prettyprint.hom.KeyConcatenationStrategy;
import me.prettyprint.hom.KeyDefinition;
import me.prettyprint.hom.PropertyMappingDefinition;
import me.prettyprint.hom.ReflectionHelper;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import me.prettyprint.hom.converters.Converter;
import me.prettyprint.hom.converters.DefaultConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HectorObjectMapper {
    private static Logger logger = LoggerFactory.getLogger(HectorObjectMapper.class);
    private static final int MAX_NUM_COLUMNS = 100;
    private int maxNumColumns = 100;
    private ClassCacheMgr cacheMgr;
    private KeyConcatenationStrategy keyConcatStrategy = new KeyConcatenationDelimiterStrategyImpl();
    private CollectionMapperHelper collMapperHelper = new CollectionMapperHelper();
    private ReflectionHelper reflectionHelper = new ReflectionHelper();

    public HectorObjectMapper(ClassCacheMgr cacheMgr) {
        this.cacheMgr = cacheMgr;
    }

    public <T, I> T getObject(Keyspace keyspace, String colFamName, I pkObj) {
        if (null == pkObj) {
            throw new IllegalArgumentException("object ID cannot be null or empty");
        }
        CFMappingDef cfMapDef = this.cacheMgr.getCfMapDef(colFamName, true);
        byte[] colFamKey = this.generateColumnFamilyKeyFromPkObj(cfMapDef, pkObj);
        SliceQuery q = HFactory.createSliceQuery((Keyspace)keyspace, (Serializer)BytesArraySerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
        q.setColumnFamily(colFamName);
        q.setKey((Object)colFamKey);
        if (cfMapDef.isColumnSliceRequired()) {
            q.setColumnNames((Object[])cfMapDef.getSliceColumnNameArr());
        } else {
            q.setRange((Object)"", (Object)"", false, this.maxNumColumns);
        }
        QueryResult result = q.execute();
        if (null == result || null == result.get()) {
            return null;
        }
        Object obj = this.createObject(cfMapDef, pkObj, (ColumnSlice<String, byte[]>)((ColumnSlice)result.get()));
        return obj;
    }

    public <T> T saveObj(Keyspace keyspace, T obj) {
        if (null == obj) {
            throw new IllegalArgumentException("object cannot be null");
        }
        Mutator m = HFactory.createMutator((Keyspace)keyspace, (Serializer)BytesArraySerializer.get());
        this.saveObj(keyspace, (Mutator<byte[]>)m, obj);
        m.execute();
        return obj;
    }

    public Collection<?> saveObjCollection(Keyspace keyspace, Collection<?> objColl) {
        Mutator m = HFactory.createMutator((Keyspace)keyspace, (Serializer)BytesArraySerializer.get());
        Collection<?> retColl = this.saveObjCollection(keyspace, objColl, (Mutator<byte[]>)m);
        m.execute();
        return retColl;
    }

    public Collection<?> saveObjCollection(Keyspace keyspace, Collection<?> objColl, Mutator<byte[]> m) {
        if (null == objColl) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (objColl.isEmpty()) {
            return objColl;
        }
        for (Object obj : objColl) {
            this.saveObj(keyspace, m, obj);
        }
        return objColl;
    }

    private void saveObj(Keyspace keyspace, Mutator<byte[]> m, Object obj) {
        if (null == obj) {
            throw new IllegalArgumentException("object cannot be null");
        }
        CFMappingDef<?> cfMapDef = this.cacheMgr.getCfMapDef(obj.getClass(), true);
        byte[] colFamKey = this.generateColumnFamilyKeyFromPojo(obj, cfMapDef);
        String colFamName = cfMapDef.getEffectiveColFamName();
        if (cfMapDef.isAnyCollections()) {
            m.addDeletion((Object)colFamKey, colFamName);
        }
        Collection<HColumn<String, byte[]>> colColl = this.createColumnSet(obj);
        for (HColumn<String, byte[]> col : colColl) {
            if (null == col.getName() || ((String)col.getName()).isEmpty()) {
                throw new HectorObjectMapperException("Column name cannot be null or empty - trying to persist to ColumnFamily, " + colFamName);
            }
            m.addInsertion((Object)colFamKey, colFamName, col);
        }
    }

    private byte[] generateColumnFamilyKeyFromPkObj(CFMappingDef<?> cfMapDef, Object pkObj) {
        ArrayList<byte[]> segmentList = new ArrayList<byte[]>(cfMapDef.getKeyDef().getIdPropertyMap().size());
        if (cfMapDef.getKeyDef().isComplexKey()) {
            Map<String, PropertyDescriptor> propertyDescriptorMap = cfMapDef.getKeyDef().getPropertyDescriptorMap();
            for (String key : cfMapDef.getKeyDef().getIdPropertyMap().keySet()) {
                PropertyDescriptor pd = propertyDescriptorMap.get(key);
                segmentList.add(this.callMethodAndConvertToCassandraType(pkObj, pd.getReadMethod(), new DefaultConverter()));
            }
        } else {
            PropertyMappingDefinition md = cfMapDef.getKeyDef().getIdPropertyMap().values().iterator().next();
            segmentList.add(md.getConverter().convertObjTypeToCassType(pkObj));
        }
        return this.keyConcatStrategy.concat(segmentList);
    }

    private byte[] generateColumnFamilyKeyFromPojo(Object obj, CFMappingDef<?> cfMapDef) {
        ArrayList<byte[]> segmentList = new ArrayList<byte[]>(cfMapDef.getKeyDef().getIdPropertyMap().size());
        for (PropertyMappingDefinition md : cfMapDef.getKeyDef().getIdPropertyMap().values()) {
            Method meth = md.getPropDesc().getReadMethod();
            segmentList.add(this.callMethodAndConvertToCassandraType(obj, meth, md.getConverter()));
        }
        return this.keyConcatStrategy.concat(segmentList);
    }

    private byte[] callMethodAndConvertToCassandraType(Object obj, Method meth, Converter converter) {
        try {
            Object retVal = meth.invoke(obj, (Object[])null);
            return converter.convertObjTypeToCassType(retVal);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    <T> T createObject(CFMappingDef<T> cfMapDef, Object pkObj, ColumnSlice<String, byte[]> slice) {
        if (slice.getColumns().isEmpty()) {
            return null;
        }
        CFMappingDef<T> cfMapDefInstance = this.determineClassType(cfMapDef, slice);
        try {
            T obj;
            try {
                obj = cfMapDefInstance.getEffectiveClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new HectorObjectMapperException(cfMapDefInstance.getEffectiveClass().getName() + ", must have default constructor", e);
            }
            this.setIdIfCan(cfMapDef, obj, pkObj);
            for (HColumn col : slice.getColumns()) {
                String colName = (String)col.getName();
                PropertyMappingDefinition md = cfMapDefInstance.getPropMapByColumnName(colName);
                if (null != md && null != md.getPropDesc()) {
                    if (!md.isCollectionType()) {
                        this.setPropertyUsingColumn(obj, (HColumn<String, byte[]>)col, md);
                        continue;
                    }
                    this.collMapperHelper.instantiateCollection(obj, (HColumn<String, byte[]>)col, md);
                    continue;
                }
                if (this.collMapperHelper.addColumnToCollection(cfMapDefInstance, obj, colName, (byte[])col.getValue()) || null != cfMapDef.getDiscColumn() && colName.equals(cfMapDef.getDiscColumn())) continue;
                this.addToExtraIfCan(obj, cfMapDef, (HColumn<String, byte[]>)col);
            }
            return obj;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<HColumn<String, byte[]>> createColumnSet(Object obj) {
        Map<String, HColumn<String, byte[]>> map = this.createColumnMap(obj);
        if (null != map) {
            return map.values();
        }
        return null;
    }

    <T> Map<String, HColumn<String, byte[]>> createColumnMap(T obj) {
        if (null == obj) {
            throw new IllegalArgumentException("Class type cannot be null");
        }
        CFMappingDef<?> cfMapDef = this.cacheMgr.getCfMapDef(obj.getClass(), true);
        try {
            HashMap<String, HColumn<String, byte[]>> colSet = new HashMap<String, HColumn<String, byte[]>>();
            Collection<PropertyMappingDefinition> coll = cfMapDef.getAllProperties();
            for (PropertyMappingDefinition md : coll) {
                Collection<HColumn<String, byte[]>> colColl = this.createColumnsFromProperty(obj, md);
                if (null == colColl) continue;
                for (HColumn<String, byte[]> col : colColl) {
                    colSet.put((String)col.getName(), col);
                }
            }
            if (null != cfMapDef.getCfBaseMapDef()) {
                CFMappingDef<?> cfSuperMapDef = cfMapDef.getCfBaseMapDef();
                String discColName = cfSuperMapDef.getDiscColumn();
                DiscriminatorType discType = cfSuperMapDef.getDiscType();
                colSet.put(discColName, this.createHColumn(discColName, this.convertDiscTypeToColValue(discType, cfMapDef.getDiscValue())));
            }
            this.addAnonymousProperties(obj, cfMapDef, colSet);
            return colSet;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void addAnonymousProperties(T obj, CFMappingDef<T> cfMapDef, Map<String, HColumn<String, byte[]>> colSet) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method meth = cfMapDef.getAnonymousPropertyGetHandler();
        if (null == meth) {
            return;
        }
        Collection propColl = (Collection)meth.invoke(obj, (Object[])null);
        if (null == propColl || propColl.isEmpty()) {
            return;
        }
        for (Map.Entry entry : propColl) {
            if (entry.getKey() instanceof String && entry.getValue().getClass().equals(cfMapDef.getAnonymousValueType())) continue;
            throw new HectorObjectMapperException("Class, " + cfMapDef.getRealClass() + ",  anonymous properties must have entry.key of type, " + String.class.getName() + ", and entry.value of type, " + cfMapDef.getAnonymousValueType().getName() + ", to properly map to Cassandra column name/value");
        }
        for (Map.Entry entry : propColl) {
            colSet.put((String)entry.getKey(), (HColumn<String, byte[]>)HFactory.createColumn(entry.getKey(), (Object)cfMapDef.getAnonymousValueSerializer().toBytes(entry.getValue()), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get()));
        }
    }

    private <T> Collection<HColumn<String, byte[]>> createColumnsFromProperty(T obj, PropertyMappingDefinition md) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!md.isCollectionType()) {
            byte[] colValue = this.createBytesFromPropertyValue(obj, md);
            if (null == colValue) {
                return null;
            }
            return Arrays.asList(this.createHColumn(md.getColName(), colValue));
        }
        return this.createColumnsFromCollectionProperty(obj, md);
    }

    private <T> Collection<HColumn<String, byte[]>> createColumnsFromCollectionProperty(T obj, PropertyMappingDefinition md) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object tmpColl = this.reflectionHelper.invokeGetter(obj, md);
        if (!(tmpColl instanceof Collection)) {
            throw new HectorObjectMapperException("property, " + md.getColName() + ", is marked as a collection type, but not actually a Collection.  Property is type, " + md.getPropDesc().getPropertyType());
        }
        LinkedList<HColumn<String, byte[]>> colList = new LinkedList<HColumn<String, byte[]>>();
        Collection coll = (Collection)tmpColl;
        colList.add(this.createHColumn(md.getColName(), this.collMapperHelper.createCollectionInfoColValue(coll)));
        int count = 0;
        for (Object elem : coll) {
            byte[] bytes = this.collMapperHelper.serializeCollectionValue(elem);
            if (null == bytes) {
                return null;
            }
            colList.add(this.createHColumn(this.collMapperHelper.createCollectionItemColName(md.getColName(), count), bytes));
            ++count;
        }
        return colList;
    }

    private byte[] createBytesFromPropertyValue(Object obj, PropertyMappingDefinition md) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object retVal = this.reflectionHelper.invokeGetter(obj, md);
        if (null == retVal) {
            return null;
        }
        byte[] bytes = md.getConverter().convertObjTypeToCassType(retVal);
        return bytes;
    }

    private HColumn<String, byte[]> createHColumn(String name, byte[] value) {
        return HFactory.createColumn((Object)name, (Object)value, (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
    }

    private <T> CFMappingDef<? extends T> determineClassType(CFMappingDef<T> cfMapDef, ColumnSlice<String, byte[]> slice) {
        if (null == cfMapDef.getInheritanceType()) {
            return cfMapDef;
        }
        if (null == slice || null == slice.getColumns() || slice.getColumns().isEmpty()) {
            return cfMapDef;
        }
        String discColName = cfMapDef.getDiscColumn();
        DiscriminatorType discType = cfMapDef.getDiscType();
        Map<Object, CFMappingDef<T>> derivedClasses = cfMapDef.getDerivedClassMap();
        HColumn discCol = null;
        for (HColumn col : slice.getColumns()) {
            if (!((String)col.getName()).equals(discColName)) continue;
            discCol = col;
            break;
        }
        if (null == discCol || 0 == ((byte[])discCol.getValue()).length) {
            return cfMapDef;
        }
        Object discValue = this.convertColValueToDiscType(discType, (byte[])discCol.getValue());
        CFMappingDef<T> derivedCfMapDef = derivedClasses.get(discValue);
        if (null == derivedCfMapDef) {
            throw new RuntimeException("Cannot find derived class of " + cfMapDef.getEffectiveClass().getName() + " with discriminator value of " + discValue);
        }
        return derivedCfMapDef;
    }

    private Object convertColValueToDiscType(DiscriminatorType discType, byte[] value) {
        switch (discType) {
            case STRING: {
                return new String(value);
            }
            case CHAR: {
                return Character.valueOf(ByteBuffer.wrap(value).asCharBuffer().get());
            }
            case INTEGER: {
                return IntegerSerializer.get().fromBytes(value);
            }
        }
        throw new RuntimeException("must have added a new discriminator type, " + discType + ", because don't know how to convert db value - cannot continue");
    }

    private byte[] convertDiscTypeToColValue(DiscriminatorType discType, Object value) {
        switch (discType) {
            case STRING: {
                return StringSerializer.get().toBytes((Object)((String)value));
            }
            case CHAR: {
                return String.valueOf((Character)value).getBytes();
            }
            case INTEGER: {
                return IntegerSerializer.get().toBytes((Object)((Integer)value));
            }
        }
        throw new RuntimeException("must have added a new discriminator type, " + discType + ", because don't know how to convert db value - cannot continue");
    }

    private <T> void setIdIfCan(CFMappingDef<T> cfMapDef, T obj, Object pkObj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (cfMapDef.getKeyDef().isComplexKey()) {
            this.setComplexId(cfMapDef, obj, pkObj);
        } else {
            this.setSimpleId(cfMapDef, obj, pkObj);
        }
    }

    private <T> void setSimpleId(CFMappingDef<T> cfMapDef, T obj, Object pkObj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyMappingDefinition md = cfMapDef.getKeyDef().getIdPropertyMap().values().iterator().next();
        if (null == md) {
            throw new HectorObjectMapperException("Trying to build new object but haven't annotated a field with @" + Id.class.getSimpleName());
        }
        Method meth = md.getPropDesc().getWriteMethod();
        if (null == meth) {
            logger.debug("@Id annotation found - but can't find setter for property, " + md.getPropDesc().getName());
            throw new HectorObjectMapperException("Trying to build new object but can't find setter for property, " + md.getPropDesc().getName());
        }
        meth.invoke(obj, pkObj);
    }

    private <T> void setComplexId(CFMappingDef<T> cfMapDef, T obj, Object pkObj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        KeyDefinition keyDef = cfMapDef.getKeyDef();
        if (!pkObj.getClass().equals(keyDef.getPkClazz())) {
            throw new HectorObjectMapperException("primary key object, " + pkObj.getClass().getName() + ", must be of type " + keyDef.getPkClazz().getName());
        }
        for (PropertyDescriptor pd : keyDef.getPropertyDescriptorMap().values()) {
            PropertyMappingDefinition md = keyDef.getIdPropertyMap().get(pd.getName());
            if (null == md) {
                throw new HectorObjectMapperException("Trying to set complex key type, but field, " + pd.getName() + ", is not annotated with @" + Id.class.getSimpleName() + " in POJO, " + cfMapDef.getRealClass().getName());
            }
            Method meth = md.getPropDesc().getWriteMethod();
            if (null == meth) {
                logger.debug("@Id annotation found - but can't find setter for property, " + md.getPropDesc().getName());
            }
            meth.invoke(obj, pd.getReadMethod().invoke(pkObj, (Object[])null));
        }
    }

    private <T> void setPropertyUsingColumn(T obj, HColumn<String, byte[]> col, PropertyMappingDefinition md) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor pd = md.getPropDesc();
        if (null == pd.getWriteMethod()) {
            throw new RuntimeException("property, " + pd.getName() + ", on class, " + obj.getClass().getName() + ", does not have a setter and therefore cannot be set");
        }
        Object value = md.getConverter().convertCassTypeToObjType(md, (byte[])col.getValue());
        pd.getWriteMethod().invoke(obj, value);
    }

    public static Serializer<?> determineSerializer(Class<?> theType) {
        Serializer s = SerializerTypeInferer.getSerializer(theType);
        if (null == s) {
            throw new RuntimeException("unsupported property type, " + theType.getName() + ".  Create custom converter or petition Hector Core team to add another converter to SerializerTypeInferer");
        }
        return s;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return HectorObjectMapper.isImplementedBy(clazz, Serializable.class);
    }

    public static boolean isImplementedBy(Class<?> clazz, Class<?> target) {
        if (null == clazz || null == target) {
            return false;
        }
        Class<?>[] interArr = clazz.getInterfaces();
        if (null == interArr) {
            return false;
        }
        for (Class<?> interfa : interArr) {
            if (!interfa.equals(target)) continue;
            return true;
        }
        return false;
    }

    private <T> void addToExtraIfCan(Object obj, CFMappingDef<T> cfMapDef, HColumn<String, byte[]> col) throws SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method meth = cfMapDef.getAnonymousPropertyAddHandler();
        if (null == meth) {
            throw new IllegalArgumentException("Object type, " + obj.getClass() + ", does not have a property named, " + (String)col.getName() + ".  either add a setter for this property or use @AnonymousPropertyHandler to annotate a method for handling anonymous properties");
        }
        meth.invoke(obj, col.getName(), cfMapDef.getAnonymousValueSerializer().fromBytes((byte[])col.getValue()));
    }

    public void setKeyConcatStrategy(KeyConcatenationStrategy keyConcatStrategy) {
        this.keyConcatStrategy = keyConcatStrategy;
    }
}

