/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.annotations;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class AnnotationScanner {
    private static Logger logger = LoggerFactory.getLogger(AnnotationScanner.class);

    public Set<Class<?>> scan(String packageRoot, Class<? extends Annotation> anno) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        AnnotationTypeFilter filter = new AnnotationTypeFilter(anno);
        scanner.addIncludeFilter((TypeFilter)filter);
        Set beanSet = scanner.findCandidateComponents(packageRoot);
        HashSet classSet = new HashSet();
        for (BeanDefinition beanDef : beanSet) {
            logger.debug("found candidate bean = " + beanDef.getBeanClassName());
            try {
                Class<?> clazz = Class.forName(beanDef.getBeanClassName(), true, Thread.currentThread().getContextClassLoader());
                if (!clazz.isAnnotationPresent(anno)) continue;
                logger.debug("found annotated class, " + clazz.getName());
                classSet.add(clazz);
            }
            catch (ClassNotFoundException e) {
                logger.error("exception while scanning classpath for annotated classes", (Throwable)e);
            }
        }
        return classSet;
    }
}

