/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.util.Iterator;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.AbstractHistogramIterator;
import org.HdrHistogram.HistogramIterationValue;

public class LogarithmicIterator
extends AbstractHistogramIterator
implements Iterator<HistogramIterationValue> {
    int valueUnitsInFirstBucket;
    double logBase;
    long nextValueReportingLevel;
    long nextValueReportingLevelLowestEquivalent;

    public void reset(int valueUnitsInFirstBucket, double logBase) {
        this.reset(this.histogram, valueUnitsInFirstBucket, logBase);
    }

    private void reset(AbstractHistogram histogram, int valueUnitsInFirstBucket, double logBase) {
        super.resetIterator(histogram);
        this.logBase = logBase;
        this.valueUnitsInFirstBucket = valueUnitsInFirstBucket;
        this.nextValueReportingLevel = valueUnitsInFirstBucket;
        this.nextValueReportingLevelLowestEquivalent = histogram.lowestEquivalentValue(this.nextValueReportingLevel);
    }

    public LogarithmicIterator(AbstractHistogram histogram, int valueUnitsInFirstBucket, double logBase) {
        this.reset(histogram, valueUnitsInFirstBucket, logBase);
    }

    @Override
    public boolean hasNext() {
        if (super.hasNext()) {
            return true;
        }
        return this.nextValueReportingLevelLowestEquivalent < this.nextValueAtIndex;
    }

    @Override
    void incrementIterationLevel() {
        this.nextValueReportingLevel = (long)((double)this.nextValueReportingLevel * this.logBase);
        this.nextValueReportingLevelLowestEquivalent = this.histogram.lowestEquivalentValue(this.nextValueReportingLevel);
    }

    @Override
    long getValueIteratedTo() {
        return this.nextValueReportingLevel;
    }

    @Override
    boolean reachedIterationLevel() {
        return this.currentValueAtIndex >= this.nextValueReportingLevelLowestEquivalent;
    }
}

