/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;

public class AtomicHistogram
extends AbstractHistogram {
    static final AtomicLongFieldUpdater<AtomicHistogram> totalCountUpdater = AtomicLongFieldUpdater.newUpdater(AtomicHistogram.class, "totalCount");
    volatile long totalCount;
    final AtomicLongArray counts = new AtomicLongArray(this.countsArrayLength);
    private LongBuffer cachedDstLongBuffer = null;
    private ByteBuffer cachedDstByteBuffer = null;
    private int cachedDstByteBufferPosition = 0;

    @Override
    long getCountAtIndex(int index) {
        return this.counts.get(index);
    }

    @Override
    void incrementCountAtIndex(int index) {
        this.counts.incrementAndGet(index);
    }

    @Override
    void addToCountAtIndex(int index, long value) {
        this.counts.addAndGet(index, value);
    }

    @Override
    void clearCounts() {
        for (int i = 0; i < this.counts.length(); ++i) {
            this.counts.lazySet(i, 0L);
        }
        totalCountUpdater.set(this, 0L);
    }

    @Override
    public AtomicHistogram copy() {
        AtomicHistogram copy = new AtomicHistogram(this);
        copy.add(this);
        return copy;
    }

    @Override
    public AtomicHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        AtomicHistogram toHistogram = new AtomicHistogram(this);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    long getTotalCount() {
        return totalCountUpdater.get(this);
    }

    @Override
    void setTotalCount(long totalCount) {
        totalCountUpdater.set(this, totalCount);
    }

    @Override
    void incrementTotalCount() {
        totalCountUpdater.incrementAndGet(this);
    }

    @Override
    void addToTotalCount(long value) {
        totalCountUpdater.addAndGet(this, value);
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 8 * this.counts.length();
    }

    public AtomicHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public AtomicHistogram(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.wordSizeInBytes = 8;
    }

    private AtomicHistogram(AbstractHistogram source) {
        super(source);
        this.wordSizeInBytes = 8;
    }

    public static AtomicHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) {
        return (AtomicHistogram)AtomicHistogram.decodeFromByteBuffer(buffer, AtomicHistogram.class, minBarForHighestTrackableValue);
    }

    public static AtomicHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) throws DataFormatException {
        return (AtomicHistogram)AtomicHistogram.decodeFromCompressedByteBuffer(buffer, AtomicHistogram.class, minBarForHighestTrackableValue);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }

    @Override
    synchronized void fillCountsArrayFromBuffer(ByteBuffer buffer, int length) {
        LongBuffer logbuffer = buffer.asLongBuffer();
        for (int i = 0; i < length; ++i) {
            this.counts.lazySet(i, logbuffer.get());
        }
    }

    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer buffer, int length) {
        if (this.cachedDstLongBuffer == null || buffer != this.cachedDstByteBuffer || buffer.position() != this.cachedDstByteBufferPosition) {
            this.cachedDstByteBuffer = buffer;
            this.cachedDstByteBufferPosition = buffer.position();
            this.cachedDstLongBuffer = buffer.asLongBuffer();
        }
        this.cachedDstLongBuffer.rewind();
        for (int i = 0; i < length; ++i) {
            this.cachedDstLongBuffer.put(this.counts.get(i));
        }
    }
}

