/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;

public class ShortHistogram
extends AbstractHistogram {
    long totalCount;
    final short[] counts = new short[this.countsArrayLength];
    private ShortBuffer cachedDstShortBuffer = null;
    private ByteBuffer cachedDstByteBuffer = null;
    private int cachedDstByteBufferPosition = 0;

    @Override
    long getCountAtIndex(int index) {
        return this.counts[index];
    }

    @Override
    void incrementCountAtIndex(int index) {
        int n = index;
        this.counts[n] = (short)(this.counts[n] + 1);
    }

    @Override
    void addToCountAtIndex(int index, long value) {
        int n = index;
        this.counts[n] = (short)((long)this.counts[n] + value);
    }

    @Override
    void clearCounts() {
        Arrays.fill(this.counts, (short)0);
        this.totalCount = 0L;
    }

    @Override
    public ShortHistogram copy() {
        ShortHistogram copy = new ShortHistogram(this);
        copy.add(this);
        return copy;
    }

    @Override
    public ShortHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        ShortHistogram toHistogram = new ShortHistogram(this);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    long getTotalCount() {
        return this.totalCount;
    }

    @Override
    void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    void addToTotalCount(long value) {
        this.totalCount += value;
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 2 * this.counts.length;
    }

    public ShortHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public ShortHistogram(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.wordSizeInBytes = 2;
    }

    private ShortHistogram(AbstractHistogram source) {
        super(source);
        this.wordSizeInBytes = 2;
    }

    public static ShortHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) {
        return (ShortHistogram)ShortHistogram.decodeFromByteBuffer(buffer, ShortHistogram.class, minBarForHighestTrackableValue);
    }

    public static ShortHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) throws DataFormatException {
        return (ShortHistogram)ShortHistogram.decodeFromCompressedByteBuffer(buffer, ShortHistogram.class, minBarForHighestTrackableValue);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }

    @Override
    synchronized void fillCountsArrayFromBuffer(ByteBuffer buffer, int length) {
        buffer.asShortBuffer().get(this.counts, 0, length);
    }

    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer buffer, int length) {
        if (this.cachedDstShortBuffer == null || buffer != this.cachedDstByteBuffer || buffer.position() != this.cachedDstByteBufferPosition) {
            this.cachedDstByteBuffer = buffer;
            this.cachedDstByteBufferPosition = buffer.position();
            this.cachedDstShortBuffer = buffer.asShortBuffer();
        }
        this.cachedDstShortBuffer.rewind();
        this.cachedDstShortBuffer.put(this.counts, 0, length);
    }
}

