/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.util.Iterator;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.AbstractHistogramIterator;
import org.HdrHistogram.HistogramIterationValue;

public class LinearIterator
extends AbstractHistogramIterator
implements Iterator<HistogramIterationValue> {
    long valueUnitsPerBucket;
    long nextValueReportingLevel;
    long nextValueReportingLevelLowestEquivalent;

    public void reset(int valueUnitsPerBucket) {
        this.reset(this.histogram, valueUnitsPerBucket);
    }

    private void reset(AbstractHistogram histogram, long valueUnitsPerBucket) {
        super.resetIterator(histogram);
        this.valueUnitsPerBucket = valueUnitsPerBucket;
        this.nextValueReportingLevel = valueUnitsPerBucket;
        this.nextValueReportingLevelLowestEquivalent = histogram.lowestEquivalentValue(this.nextValueReportingLevel);
    }

    public LinearIterator(AbstractHistogram histogram, int valueUnitsPerBucket) {
        this.reset(histogram, valueUnitsPerBucket);
    }

    @Override
    public boolean hasNext() {
        if (super.hasNext()) {
            return true;
        }
        return this.nextValueReportingLevelLowestEquivalent < this.nextValueAtIndex;
    }

    @Override
    void incrementIterationLevel() {
        this.nextValueReportingLevel += this.valueUnitsPerBucket;
        this.nextValueReportingLevelLowestEquivalent = this.histogram.lowestEquivalentValue(this.nextValueReportingLevel);
    }

    @Override
    long getValueIteratedTo() {
        return this.nextValueReportingLevel;
    }

    @Override
    boolean reachedIterationLevel() {
        return this.currentValueAtIndex >= this.nextValueReportingLevelLowestEquivalent;
    }
}

