/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.web.validator;

import java.util.Map;
import org.springframework.validation.Errors;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class AbstractEditableParameterValidator {
    protected void validateEditableParameters(Errors errors) {
        RequestAttributes attr = RequestContextHolder.getRequestAttributes();
        if (attr == null) {
            return;
        }
        Map parameters = (Map)attr.getAttribute("org.hdiv.action.EDITABLE_PARAMETER_ERROR", 0);
        if (parameters != null && parameters.size() > 0) {
            for (String param : parameters.keySet()) {
                String[] unauthorizedValues = (String[])parameters.get(param);
                this.rejectParamValues(param, unauthorizedValues, errors);
            }
        }
    }

    protected void validateEditableParameter(String param, Errors errors) {
        String[] unauthorizedValues;
        RequestAttributes attr = RequestContextHolder.getRequestAttributes();
        if (attr == null) {
            return;
        }
        Map parameters = (Map)attr.getAttribute("org.hdiv.action.EDITABLE_PARAMETER_ERROR", 0);
        if (parameters != null && parameters.size() > 0 && (unauthorizedValues = (String[])parameters.get(param)) != null && unauthorizedValues.length > 0) {
            this.rejectParamValues(param, unauthorizedValues, errors);
        }
    }

    protected void rejectParamValues(String param, String[] paramValues, Errors errors) {
        if (paramValues.length == 1 && paramValues[0].equals("hdiv.editable.password.error")) {
            errors.rejectValue(param, "hdiv.editable.password.error");
        } else {
            String printedValue = this.createMessageError(paramValues);
            errors.rejectValue(param, "hdiv.editable.error", (Object[])new String[]{printedValue}, printedValue + " has not allowed characters");
        }
    }

    protected String createMessageError(String[] values) {
        StringBuffer printedValue = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                printedValue.append(", ");
            }
            if (values[i].length() > 20) {
                printedValue.append(values[i].substring(0, 20) + "...");
            } else {
                printedValue.append(values[i]);
            }
            if (printedValue.length() > 20) break;
        }
        return printedValue.toString();
    }
}

