/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.web.servlet.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HdivRequestDataValueProcessor
implements RequestDataValueProcessor {
    protected LinkUrlProcessor linkUrlProcessor;
    protected FormUrlProcessor formUrlProcessor;
    protected RequestDataValueProcessor innerRequestDataValueProcessor;
    protected List<String> noEditableTypes = new ArrayList<String>();

    public HdivRequestDataValueProcessor() {
        this.initNoEditableTypes();
    }

    protected void initNoEditableTypes() {
        this.noEditableTypes.add("checkbox");
        this.noEditableTypes.add("hidden");
        this.noEditableTypes.add("option");
        this.noEditableTypes.add("radio");
        this.noEditableTypes.add("select");
    }

    public String processAction(HttpServletRequest request, String action) {
        return this.processAction(request, action, "POST");
    }

    public String processAction(HttpServletRequest request, String action, String method) {
        String processedAction;
        if (this.innerRequestDataValueProcessor != null && (processedAction = this.innerRequestDataValueProcessor.processAction(request, action, method)) != action) {
            action = processedAction;
        }
        String result = this.formUrlProcessor.processUrl(request, action, method);
        return result;
    }

    public String processFormFieldValue(HttpServletRequest request, String name, String value, String type) {
        String processedValue;
        if (this.innerRequestDataValueProcessor != null && (processedValue = this.innerRequestDataValueProcessor.processFormFieldValue(request, name, value, type)) != value) {
            value = processedValue;
        }
        if (name == null) {
            return value;
        }
        IDataComposer dataComposer = (IDataComposer)request.getAttribute("DATACOMPOSER_REQUEST_KEY");
        if (dataComposer == null || !dataComposer.isRequestStarted()) {
            return value;
        }
        if (this.isEditable(type)) {
            dataComposer.composeFormField(name, value, true, type);
            return value;
        }
        String result = dataComposer.composeFormField(name, value, false, type);
        return result;
    }

    public Map<String, String> getExtraHiddenFields(HttpServletRequest request) {
        Map innerExtras;
        IDataComposer dataComposer = (IDataComposer)request.getAttribute("DATACOMPOSER_REQUEST_KEY");
        HashMap<String, String> extraFields = new HashMap<String, String>();
        if (this.innerRequestDataValueProcessor != null && (innerExtras = this.innerRequestDataValueProcessor.getExtraHiddenFields(request)) != null) {
            extraFields.putAll(innerExtras);
        }
        if (dataComposer == null || !dataComposer.isRequestStarted()) {
            return extraFields;
        }
        String requestId = dataComposer.endRequest();
        if (requestId != null && requestId.length() > 0) {
            String hdivStateParam = (String)request.getSession().getAttribute("HDIVParameter");
            extraFields.put(hdivStateParam, requestId);
            request.setAttribute("hdivFormStateId", (Object)requestId);
        }
        return extraFields;
    }

    public String processUrl(HttpServletRequest request, String url) {
        String processedUrl;
        if (this.innerRequestDataValueProcessor != null && (processedUrl = this.innerRequestDataValueProcessor.processUrl(request, url)) != null) {
            url = processedUrl;
        }
        String result = this.linkUrlProcessor.processUrl(request, url);
        return result;
    }

    protected boolean isEditable(String type) {
        return !this.noEditableTypes.contains(type);
    }

    public void setLinkUrlProcessor(LinkUrlProcessor linkUrlProcessor) {
        this.linkUrlProcessor = linkUrlProcessor;
    }

    public void setFormUrlProcessor(FormUrlProcessor formUrlProcessor) {
        this.formUrlProcessor = formUrlProcessor;
    }

    public void setInnerRequestDataValueProcessor(RequestDataValueProcessor innerRequestDataValueProcessor) {
        this.innerRequestDataValueProcessor = innerRequestDataValueProcessor;
    }

    public RequestDataValueProcessor getInnerRequestDataValueProcessor() {
        return this.innerRequestDataValueProcessor;
    }
}

