/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.validator;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hdiv.validator.IValidation;

public class Validation
implements IValidation,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Pattern acceptedPattern;
    protected Pattern rejectedPattern;
    protected String componentType;

    public boolean existComponentType() {
        return this.componentType != null;
    }

    public boolean isTheSameComponentType(String parameterType) {
        if (parameterType.equals("password")) {
            return this.componentType.equalsIgnoreCase("text");
        }
        return this.componentType.equalsIgnoreCase(parameterType);
    }

    public boolean validate(String parameter, String[] values, String dataType) {
        Matcher m = null;
        if (this.existComponentType() && !this.isTheSameComponentType(dataType)) {
            return true;
        }
        for (int j = 0; j < values.length; ++j) {
            if (this.acceptedPattern != null && !(m = this.acceptedPattern.matcher(values[j])).matches()) {
                return false;
            }
            if (this.rejectedPattern == null || !(m = this.rejectedPattern.matcher(values[j])).matches()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public void setAcceptedPattern(String acceptedPattern) {
        this.acceptedPattern = Pattern.compile(acceptedPattern);
    }

    public void setRejectedPattern(String rejectedPattern) {
        this.rejectedPattern = Pattern.compile(rejectedPattern);
    }

    public String toString() {
        StringBuffer result = new StringBuffer().append("");
        result = result.append(" name=").append(this.getName());
        result = result.append(" componentType=").append(this.getComponentType());
        result = result.append(" acceptedPattern=").append(this.acceptedPattern == null ? "" : this.acceptedPattern.toString());
        result = result.append(" rejectedPattern=").append(this.rejectedPattern == null ? "" : this.rejectedPattern.toString());
        return result.toString();
    }
}

