/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.cipher.ICipherHTTP;
import org.hdiv.cipher.Key;
import org.hdiv.exception.HDIVException;
import org.hdiv.session.ISession;
import org.hdiv.util.HDIVUtil;

public class EncodingUtil {
    private static final Log log = LogFactory.getLog(EncodingUtil.class);
    public static final String ZIP_CHARSET = "ISO-8859-1";
    private ISession session;
    private MessageDigest messageDigest;
    private String algorithmName = "MD5";

    public void init() {
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithmName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("MessageDigest created: " + this.messageDigest));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new HDIVException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode64Cipher(Object obj) {
        try {
            byte[] cipherData;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zos = new GZIPOutputStream(baos);
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(obj);
            oos.close();
            ((OutputStream)zos).close();
            baos.close();
            ICipherHTTP cipher = this.session.getEncryptCipher();
            Key key = this.session.getCipherKey();
            ICipherHTTP iCipherHTTP = cipher;
            synchronized (iCipherHTTP) {
                cipher.initEncryptMode(key);
                cipherData = cipher.encrypt(baos.toByteArray());
            }
            byte[] encodedData = URLCodec.encodeUrl(null, (byte[])cipherData);
            Base64 base64Codec = new Base64();
            return new String(base64Codec.encode(encodedData), ZIP_CHARSET);
        }
        catch (Exception e) {
            String errorMessage = HDIVUtil.getMessage("encode.message");
            throw new HDIVException(errorMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode64Cipher(String s) {
        try {
            byte[] data;
            Base64 base64Codec = new Base64();
            byte[] encryptedData = base64Codec.decode(s.getBytes(ZIP_CHARSET));
            byte[] encodedData = URLCodec.decodeUrl((byte[])encryptedData);
            ICipherHTTP cipher = this.session.getDecryptCipher();
            Key key = this.session.getCipherKey();
            ICipherHTTP iCipherHTTP = cipher;
            synchronized (iCipherHTTP) {
                cipher.initDecryptMode(key);
                data = cipher.decrypt(encodedData);
            }
            ByteArrayInputStream decodedStream = new ByteArrayInputStream(data);
            GZIPInputStream unzippedStream = new GZIPInputStream(decodedStream);
            ObjectInputStream ois = new ObjectInputStream(unzippedStream);
            Object obj = ois.readObject();
            ois.close();
            ((InputStream)unzippedStream).close();
            decodedStream.close();
            return obj;
        }
        catch (Exception e) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE", e);
        }
    }

    public String encode64(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zos = new GZIPOutputStream(baos);
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(obj);
            oos.close();
            ((OutputStream)zos).close();
            baos.close();
            byte[] encodedData = URLCodec.encodeUrl(null, (byte[])baos.toByteArray());
            Base64 base64Codec = new Base64();
            return new String(base64Codec.encode(encodedData), ZIP_CHARSET);
        }
        catch (Exception e) {
            String errorMessage = HDIVUtil.getMessage("encode.message");
            throw new HDIVException(errorMessage, e);
        }
    }

    public Object decode64(String s) {
        try {
            Base64 base64Codec = new Base64();
            byte[] encryptedData = base64Codec.decode(s.getBytes(ZIP_CHARSET));
            byte[] encodedData = URLCodec.decodeUrl((byte[])encryptedData);
            ByteArrayInputStream decodedStream = new ByteArrayInputStream(encodedData);
            GZIPInputStream unzippedStream = new GZIPInputStream(decodedStream);
            ObjectInputStream ois = new ObjectInputStream(unzippedStream);
            Object obj = ois.readObject();
            ois.close();
            ((InputStream)unzippedStream).close();
            decodedStream.close();
            return obj;
        }
        catch (Exception e) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE", e);
        }
    }

    public String calculateStateHash(String data) {
        try {
            this.messageDigest.update(data.getBytes());
            byte[] raw = this.messageDigest.digest();
            return new String(raw);
        }
        catch (Exception e) {
            String errorMessage = HDIVUtil.getMessage("hash.digest");
            throw new HDIVException(errorMessage, e);
        }
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public void setMessageDigest(MessageDigest md) {
        this.messageDigest = md;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }
}

