/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.state;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.Strategy;
import org.hdiv.exception.HDIVException;
import org.hdiv.session.ISession;
import org.hdiv.state.IState;
import org.hdiv.state.scope.StateScope;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.util.EncodingUtil;

public class StateUtil {
    private Log log = LogFactory.getLog(StateUtil.class);
    protected static final String MEMORY_PATTERN = "([0-9]+-){2}[A-Za-z0-9]+";
    protected Pattern memoryPattern = Pattern.compile("([0-9]+-){2}[A-Za-z0-9]+");
    protected EncodingUtil encodingUtil;
    protected HDIVConfig config;
    protected ISession session;
    protected StateScopeManager stateScopeManager;

    public void init() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"StateUtil instance created.");
        }
    }

    public IState restoreState(String requestState) {
        IState restoredState = null;
        if (this.isMemoryStrategy(requestState)) {
            restoredState = this.restoreMemoryState(requestState);
        } else if (this.isCipherStrategy()) {
            restoredState = (IState)this.encodingUtil.decode64Cipher(requestState);
        } else if (this.isHashStrategy()) {
            restoredState = this.restoreHashState(requestState);
        }
        if (restoredState == null) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
        return restoredState;
    }

    public boolean isMemoryStrategy(String value) {
        Matcher m = this.memoryPattern.matcher(value);
        return m.matches() ? true : this.config.getStrategy().equals((Object)Strategy.MEMORY);
    }

    protected boolean isCipherStrategy() {
        return this.config.getStrategy().equals((Object)Strategy.CIPHER);
    }

    protected boolean isHashStrategy() {
        return this.config.getStrategy().equals((Object)Strategy.HASH);
    }

    protected IState restoreMemoryState(String requestState) {
        int stateId;
        IState restoredState = null;
        int firstSeparator = requestState.indexOf("-");
        int lastSeparator = requestState.lastIndexOf("-");
        if (firstSeparator == -1 || lastSeparator == -1) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
        String pageId = requestState.substring(0, firstSeparator);
        String sId = requestState.substring(firstSeparator + 1, lastSeparator);
        try {
            stateId = Integer.parseInt(sId);
        }
        catch (NumberFormatException e) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
        StateScope stateScope = this.stateScopeManager.getStateScope(requestState);
        restoredState = stateScope != null ? stateScope.restoreState(stateId) : this.getStateFromSession(pageId, stateId);
        return restoredState;
    }

    protected IState getStateFromSession(String pageId, int stateId) {
        IState sessionState = this.session.getState(pageId, stateId);
        if (sessionState == null) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
        return sessionState;
    }

    protected IState restoreHashState(String value) {
        IState decodedState;
        String sessionStateHash;
        String restoredStateHash = this.encodingUtil.calculateStateHash(value);
        if (restoredStateHash.equals(sessionStateHash = this.session.getStateHash((decodedState = (IState)this.encodingUtil.decode64(value)).getPageId() + "", decodedState.getId()))) {
            return decodedState;
        }
        return null;
    }

    public void setEncodingUtil(EncodingUtil encodingUtil) {
        this.encodingUtil = encodingUtil;
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public void setStateScopeManager(StateScopeManager stateScopeManager) {
        this.stateScopeManager = stateScopeManager;
    }
}

