/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hdiv.state.IParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter
implements IParameter,
Serializable {
    private static final long serialVersionUID = 1390866699507616631L;
    private static final int VALUES_LIST_SIZE = 3;
    private String name;
    private String value;
    private List<String> values;
    private boolean editable;
    private String editableDataType;
    private boolean actionParam;

    public Parameter(String name, String[] values, boolean editable, String editableDataType, boolean actionParam) {
        this(name, values[0], editable, editableDataType, actionParam);
        if (values.length > 1) {
            for (int i = 1; i < values.length; ++i) {
                this.addValue(values[i]);
            }
        }
    }

    public Parameter(String name, String value, boolean editable, String editableDataType, boolean actionParam) {
        this.name = name;
        this.value = value;
        this.editable = editable;
        this.editableDataType = editableDataType;
        this.actionParam = actionParam;
    }

    @Override
    public void addValue(String value) {
        if (this.editable) {
            return;
        }
        if (this.values == null) {
            this.values = new ArrayList<String>(3);
            this.values.add(this.value);
        }
        this.values.add(value);
    }

    @Override
    public boolean existValue(String value) {
        if (this.editable) {
            return false;
        }
        if (this.values == null) {
            return this.value.equalsIgnoreCase(value);
        }
        for (int i = 0; i < this.values.size(); ++i) {
            String tempValue = this.values.get(i);
            if (!tempValue.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean existPosition(int position) {
        return position == 0 || this.values != null && position < this.values.size();
    }

    @Override
    public String getValuePosition(int position) {
        return position == 0 ? this.value : this.values.get(position);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getValues() {
        if (this.editable) {
            return Collections.emptyList();
        }
        if (this.values == null) {
            return Collections.singletonList(this.value);
        }
        return this.values;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public String getConfidentialValue() {
        if (this.values == null) {
            return "0";
        }
        return Integer.toString(this.values.size() - 1);
    }

    @Override
    public boolean isActionParam() {
        return this.actionParam;
    }

    public void setActionParam(boolean actionParam) {
        this.actionParam = actionParam;
    }

    @Override
    public String getEditableDataType() {
        return this.editableDataType;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" Parameter:" + this.getName() + " Values:");
        if (this.values == null) {
            result.append(this.value);
        } else {
            for (int i = 0; i < this.values.size(); ++i) {
                String value = this.values.get(i);
                result.append(value);
                if (i + 1 == this.values.size()) continue;
                result.append(",");
            }
        }
        return result.toString();
    }
}

