/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.session;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.session.IStateCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateCache
implements IStateCache {
    private static final int DEFAULT_MAX_SIZE = 5;
    private static final Log log = LogFactory.getLog(StateCache.class);
    private static final long serialVersionUID = -386843742684433849L;
    private int maxSize = 5;
    private List<String> pageIds = new ArrayList<String>();

    @Override
    public synchronized String addPage(String key) {
        if (this.pageIds.contains(key)) {
            return null;
        }
        String removedKey = this.cleanBuffer();
        this.pageIds.add(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Page with [" + key + "] added to the cache."));
        }
        return removedKey;
    }

    public String cleanBuffer() {
        if (this.pageIds.size() >= this.maxSize) {
            String key = this.pageIds.remove(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Full Cache, deleted page with id [" + key + "]."));
            }
            return key;
        }
        return null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (String pageId : this.pageIds) {
            result.append(" " + pageId);
        }
        result.append("]");
        return result.toString();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public List<String> getPageIds() {
        return this.pageIds;
    }
}

