/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.session;

import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.cipher.ICipherHTTP;
import org.hdiv.cipher.Key;
import org.hdiv.exception.HDIVException;
import org.hdiv.idGenerator.PageIdGenerator;
import org.hdiv.session.ISession;
import org.hdiv.session.IStateCache;
import org.hdiv.state.IPage;
import org.hdiv.state.IState;
import org.hdiv.util.HDIVUtil;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class SessionHDIV
implements ISession,
BeanFactoryAware {
    private static final Log log = LogFactory.getLog(SessionHDIV.class);
    private BeanFactory beanFactory;
    private String cacheName = "org.hdiv.StateCache";
    private String pageIdGeneratorName = "org.hdiv.PageIdGenerator";
    private String keyName = "org.hdiv.Key";

    public int getPageId() {
        HttpSession session = this.getHttpSession();
        PageIdGenerator pageIdGenerator = (PageIdGenerator)session.getAttribute(this.pageIdGeneratorName);
        if (pageIdGenerator == null) {
            throw new HDIVException("session.nopageidgenerator");
        }
        int id = pageIdGenerator.getNextPageId();
        if (id <= 0) {
            throw new HDIVException("Incorrect PageId generated [" + id + "]. PageId must be greater than 0.");
        }
        session.setAttribute(this.pageIdGeneratorName, (Object)pageIdGenerator);
        return id;
    }

    public IPage getPage(String pageId) {
        try {
            HttpSession session = this.getHttpSession();
            return this.getPageFromSession(session, pageId);
        }
        catch (IllegalStateException e) {
            throw new HDIVException("INVALID_PAGE_ID", e);
        }
    }

    public void addPage(String pageId, IPage page) {
        HttpSession session = this.getHttpSession();
        IStateCache cache = this.getStateCache(session);
        String removedPageId = cache.addPage(pageId);
        if (removedPageId != null) {
            this.removePageFromSession(session, removedPageId);
        }
        this.saveStateCache(session, cache);
        this.addPageToSession(session, page);
    }

    public void removeEndedPages(String conversationId) {
        HttpSession session = this.getHttpSession();
        IStateCache cache = this.getStateCache(session);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache pages before finished pages are deleted:" + cache.toString()));
        }
        List<String> pageIds = cache.getPageIds();
        for (int i = 0; i < pageIds.size(); ++i) {
            String pageFlowId;
            String pageId = pageIds.get(i);
            IPage currentPage = this.getPageFromSession(session, pageId);
            if (currentPage == null || currentPage.getFlowId() == null || !conversationId.equalsIgnoreCase(pageFlowId = currentPage.getFlowId())) continue;
            this.removePageFromSession(session, pageId);
            pageIds.remove(i);
            --i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache pages after finished pages are deleted:" + cache.toString()));
        }
    }

    public IState getState(String pageId, int stateId) {
        try {
            IPage currentPage = this.getPage(pageId);
            return currentPage.getState(stateId);
        }
        catch (Exception e) {
            throw new HDIVException("INVALID_PAGE_ID", e);
        }
    }

    public String getStateHash(String pageId, int stateId) {
        try {
            IPage currentPage = this.getPage(pageId);
            return currentPage.getStateHash(stateId);
        }
        catch (Exception e) {
            throw new HDIVException("INVALID_PAGE_ID", e);
        }
    }

    protected IPage getPageFromSession(HttpSession session, String pageId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting page with id:" + pageId));
        }
        return (IPage)session.getAttribute(pageId);
    }

    protected void addPageToSession(HttpSession session, IPage page) {
        session.setAttribute(page.getName(), (Object)page);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added new page with id:" + page.getId()));
        }
    }

    protected void removePageFromSession(HttpSession session, String pageId) {
        session.removeAttribute(pageId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleted page with id:" + pageId));
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected IStateCache getStateCache(HttpSession session) {
        IStateCache cache = (IStateCache)session.getAttribute(this.cacheName);
        if (cache == null) {
            cache = this.createStateCacheInstance();
            session.setAttribute(this.cacheName, (Object)cache);
        }
        return cache;
    }

    protected void saveStateCache(HttpSession session, IStateCache stateCache) {
        session.setAttribute(this.cacheName, (Object)stateCache);
    }

    protected IStateCache createStateCacheInstance() {
        IStateCache cache = (IStateCache)this.beanFactory.getBean(IStateCache.class);
        return cache;
    }

    public ICipherHTTP getEncryptCipher() {
        ICipherHTTP cipher = (ICipherHTTP)this.beanFactory.getBean(ICipherHTTP.class);
        if (cipher == null) {
            String errorMessage = HDIVUtil.getMessage("encrypt.message");
            throw new HDIVException(errorMessage);
        }
        return cipher;
    }

    public ICipherHTTP getDecryptCipher() {
        ICipherHTTP cipher = (ICipherHTTP)this.beanFactory.getBean(ICipherHTTP.class);
        if (cipher == null) {
            String errorMessage = HDIVUtil.getMessage("decrypt.message");
            throw new HDIVException(errorMessage);
        }
        return cipher;
    }

    public Key getCipherKey() {
        Key key = (Key)this.getHttpSession().getAttribute(this.keyName);
        if (key == null) {
            throw new HDIVException("Key not initialized on session");
        }
        return key;
    }

    protected HttpSession getHttpSession() {
        return HDIVUtil.getHttpSession();
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setPageIdGeneratorName(String pageIdGeneratorName) {
        this.pageIdGeneratorName = pageIdGeneratorName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }
}

