/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.logs;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.logs.IUserData;
import org.hdiv.util.HDIVUtil;

public class Logger {
    private static Log log = LogFactory.getLog(Logger.class);
    protected IUserData userData;

    public void init() {
    }

    public void log(String type, String target, String parameterName, String parameterValue) {
        this.log(type, target, parameterName, parameterValue, null);
    }

    public void log(String type, String target, String parameterName, String parameterValue, String originalParameterValue) {
        HttpServletRequest request = this.getHttpServletRequest();
        String localIp = this.getUserLocalIP(request);
        String remoteIp = request.getRemoteAddr();
        String userName = this.userData.getUsername(request);
        String contextPath = request.getContextPath();
        if (!target.startsWith(contextPath)) {
            target = request.getContextPath() + target;
        }
        this.log(type, target, parameterName, parameterValue, originalParameterValue, localIp, remoteIp, userName);
    }

    protected void log(String type, String target, String parameterName, String parameterValue, String originalParameterValue, String localIp, String remoteIp, String userName) {
        String formatedData = this.format(type, target, parameterName, parameterValue, originalParameterValue, localIp, remoteIp, userName);
        log.info((Object)formatedData);
    }

    protected String format(String type, String target, String parameterName, String parameterValue, String originalParameterValue, String localIp, String remoteIp, String userName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(type);
        buffer.append(";");
        buffer.append(target);
        buffer.append(";");
        buffer.append(parameterName);
        buffer.append(";");
        buffer.append(parameterValue);
        buffer.append(";");
        if (originalParameterValue != null) {
            buffer.append(originalParameterValue);
            buffer.append(";");
        }
        buffer.append(localIp);
        buffer.append(";");
        buffer.append(remoteIp);
        buffer.append(";");
        buffer.append(userName);
        return buffer.toString();
    }

    protected String getUserLocalIP(HttpServletRequest request) {
        String ipAddress = null;
        ipAddress = request.getHeader("X-Forwarded-For") == null ? request.getRemoteAddr() : request.getHeader("X-Forwarded-For");
        return ipAddress;
    }

    protected HttpServletRequest getHttpServletRequest() {
        return HDIVUtil.getHttpServletRequest();
    }

    public void setUserData(IUserData userData) {
        this.userData = userData;
    }
}

