/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.listener;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.application.IApplication;
import org.hdiv.cipher.IKeyFactory;
import org.hdiv.cipher.Key;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.Strategy;
import org.hdiv.idGenerator.PageIdGenerator;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.util.HDIVUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class InitListener
implements ServletContextListener,
HttpSessionListener {
    private static Log log = LogFactory.getLog(InitListener.class);
    private HDIVConfig config;
    private boolean servletContextInitialized = false;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (wac != null) {
            this.initServletContext(servletContext);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Hdiv's InitListener is registered before Spring's ContextLoaderListener.");
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (log.isInfoEnabled()) {
            log.info((Object)("HDIV's session destroyed:" + event.getSession().getId()));
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        ServletContext servletContext = httpSessionEvent.getSession().getServletContext();
        if (!this.servletContextInitialized) {
            this.initServletContext(servletContext);
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        this.initStrategies((ApplicationContext)wac, httpSessionEvent.getSession());
        this.initPageIdGenerator((ApplicationContext)wac, httpSessionEvent.getSession());
        this.initStateParameterNames((ApplicationContext)wac, httpSessionEvent.getSession());
        if (log.isInfoEnabled()) {
            log.info((Object)("HDIV's session created:" + httpSessionEvent.getSession().getId()));
        }
    }

    protected void initServletContext(ServletContext servletContext) {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        this.config = (HDIVConfig)wac.getBean(HDIVConfig.class);
        HDIVUtil.setHDIVConfig(this.config, servletContext);
        IApplication application = (IApplication)wac.getBean(IApplication.class);
        HDIVUtil.setApplication(application, servletContext);
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBeanClassLoader(wac.getClassLoader());
        messageSource.setBasename("org.hdiv.msg.MessageResources");
        HDIVUtil.setMessageSource((MessageSource)messageSource, servletContext);
        LinkUrlProcessor linkUrlProcessor = (LinkUrlProcessor)wac.getBean(LinkUrlProcessor.class);
        HDIVUtil.setLinkUrlProcessor(linkUrlProcessor, servletContext);
        FormUrlProcessor formUrlProcessor = (FormUrlProcessor)wac.getBean(FormUrlProcessor.class);
        HDIVUtil.setFormUrlProcessor(formUrlProcessor, servletContext);
        this.servletContextInitialized = true;
    }

    protected void initStrategies(ApplicationContext context, HttpSession httpSession) {
        if (this.config.getStrategy().equals((Object)Strategy.CIPHER)) {
            IKeyFactory keyFactory = (IKeyFactory)context.getBean(IKeyFactory.class);
            Key key = keyFactory.generateKey();
            httpSession.setAttribute("org.hdiv.Key", (Object)key);
        }
    }

    protected void initPageIdGenerator(ApplicationContext context, HttpSession httpSession) {
        PageIdGenerator pageIdGenerator = (PageIdGenerator)context.getBean(PageIdGenerator.class);
        httpSession.setAttribute("org.hdiv.PageIdGenerator", (Object)pageIdGenerator);
    }

    protected void initStateParameterNames(ApplicationContext context, HttpSession httpSession) {
        String hdivParameterName = null;
        String modifyHdivStateParameterName = null;
        if (this.config.isRandomName()) {
            hdivParameterName = HDIVUtil.createRandomToken(Integer.MAX_VALUE);
            modifyHdivStateParameterName = HDIVUtil.createRandomToken(Integer.MAX_VALUE);
        } else {
            hdivParameterName = this.config.getStateParameterName();
            modifyHdivStateParameterName = this.config.getModifyStateParameterName();
        }
        httpSession.setAttribute("HDIVParameter", (Object)hdivParameterName);
        httpSession.setAttribute("modifyHDIVStateParameter", (Object)modifyHdivStateParameterName);
    }
}

