/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.Strategy;
import org.hdiv.dataComposer.DataComposerFactory;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.dataValidator.IDataValidator;
import org.hdiv.dataValidator.IValidationResult;
import org.hdiv.exception.HDIVException;
import org.hdiv.filter.IValidationHelper;
import org.hdiv.filter.RequestWrapper;
import org.hdiv.filter.SavedCookie;
import org.hdiv.filter.ValidatorHelperResult;
import org.hdiv.logs.Logger;
import org.hdiv.session.ISession;
import org.hdiv.state.IPage;
import org.hdiv.state.IParameter;
import org.hdiv.state.IState;
import org.hdiv.state.StateUtil;
import org.hdiv.state.scope.StateScope;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.urlProcessor.BasicUrlData;
import org.hdiv.urlProcessor.BasicUrlProcessor;
import org.hdiv.util.HDIVUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorHelperRequest
implements IValidationHelper {
    private static Log log = LogFactory.getLog(ValidatorHelperRequest.class);
    protected HDIVConfig hdivConfig;
    protected Logger logger;
    protected StateUtil stateUtil;
    protected ISession session;
    protected IDataValidator dataValidator;
    protected DataComposerFactory dataComposerFactory;
    protected Pattern numberPattern = Pattern.compile("[0-9]+");
    protected BasicUrlProcessor urlProcessor;
    protected StateScopeManager stateScopeManager;

    @Override
    public void init() {
    }

    @Override
    public ValidatorHelperResult validate(HttpServletRequest request) {
        String target = this.getTarget(request);
        target = this.getTargetWithoutContextPath(request, target);
        ValidatorHelperResult result = this.preValidate(request, target = this.decodeUrl(target));
        if (result != null) {
            return result;
        }
        if (this.hdivConfig.hasExtensionToExclude(target)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The target [" + target + "] has an extension to exclude from validation"));
            }
            return ValidatorHelperResult.VALIDATION_NOT_REQUIRED;
        }
        if (!this.hdivConfig.isValidationInUrlsWithoutParamsActivated()) {
            boolean requestHasParameters;
            boolean bl = requestHasParameters = request.getParameterNames() != null && request.getParameterNames().hasMoreElements();
            if (!requestHasParameters) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The url [" + request.getRequestURI() + "] is not be validated because it has not got parameters"));
                }
                return ValidatorHelperResult.VALIDATION_NOT_REQUIRED;
            }
        }
        if (this.hdivConfig.isStartPage(target, request.getMethod())) {
            result = this.validateStartPageParameters(request, target);
            if (result.isValid()) {
                return ValidatorHelperResult.VALIDATION_NOT_REQUIRED;
            }
            return result;
        }
        if (this.hdivConfig.isCookiesIntegrityActivated() && !(result = this.validateRequestCookies(request, target)).isValid()) {
            return result;
        }
        result = this.restoreState(request, target);
        if (!result.isValid()) {
            return result;
        }
        IState state = (IState)result.getValue();
        if (!(result = this.isTheSameAction(request, target, state)).isValid()) {
            return result;
        }
        result = this.allRequiredParametersReceived(request, state, target);
        if (!result.isValid()) {
            return result;
        }
        String hdivParameter = this.getHdivParameter(request);
        BasicUrlData urlData = this.urlProcessor.processUrl(request, "?" + state.getParams());
        Map<String, String[]> stateParams = urlData.getUrlParams();
        HashMap<String, String[]> unauthorizedEditableParameters = new HashMap<String, String[]>();
        Enumeration parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            result = this.validateParameter(request, state.getParameter(parameter), stateParams.get(parameter), unauthorizedEditableParameters, hdivParameter, target, parameter);
            if (result.isValid()) continue;
            return result;
        }
        if (unauthorizedEditableParameters.size() > 0) {
            return this.processValidateParameterErrors(request, unauthorizedEditableParameters);
        }
        return ValidatorHelperResult.VALID;
    }

    protected String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HDIVException("Error decoding url", e);
        }
    }

    protected ValidatorHelperResult isTheSameAction(HttpServletRequest request, String target, IState state) {
        String action;
        String actionSlash;
        if (state.getAction().equalsIgnoreCase(target)) {
            return ValidatorHelperResult.VALID;
        }
        if (target.endsWith("/") && (actionSlash = state.getAction() + "/").equalsIgnoreCase(target)) {
            return ValidatorHelperResult.VALID;
        }
        if (state.getAction().contains(" ") && (action = state.getAction().replace(" ", "%20")).equalsIgnoreCase(target)) {
            return ValidatorHelperResult.VALID;
        }
        this.logger.log("INVALID_ACTION", target, null, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Detected validation error in the action: action in state:" + state.getAction() + ", action in the request:" + target));
        }
        return new ValidatorHelperResult("INVALID_ACTION");
    }

    protected ValidatorHelperResult validateStartPageParameters(HttpServletRequest request, String target) {
        if (this.hdivConfig.existValidations()) {
            HashMap<String, String[]> unauthorizedEditableParameters = new HashMap<String, String[]>();
            Enumeration parameters = request.getParameterNames();
            while (parameters.hasMoreElements()) {
                String parameter = (String)parameters.nextElement();
                String[] values = request.getParameterValues(parameter);
                this.validateEditableParameter(request, target, parameter, values, "text", unauthorizedEditableParameters);
            }
            if (unauthorizedEditableParameters.size() > 0) {
                return this.processValidateParameterErrors(request, unauthorizedEditableParameters);
            }
        }
        return ValidatorHelperResult.VALID;
    }

    protected ValidatorHelperResult processValidateParameterErrors(HttpServletRequest request, Map<String, String[]> unauthorizedEditableParameters) {
        if (!this.hdivConfig.isDebugMode()) {
            request.setAttribute("org.hdiv.action.EDITABLE_PARAMETER_ERROR", unauthorizedEditableParameters);
            if (this.hdivConfig.isShowErrorPageOnEditableValidation()) {
                request.getSession().setAttribute("org.hdiv.action.EDITABLE_PARAMETER_ERROR", unauthorizedEditableParameters);
                return new ValidatorHelperResult("INVALID_EDITABLE_VALUE");
            }
        }
        return ValidatorHelperResult.VALID;
    }

    protected ValidatorHelperResult validateRequestCookies(HttpServletRequest request, String target) {
        Cookie[] requestCookies = request.getCookies();
        if (requestCookies == null || requestCookies.length == 0) {
            return ValidatorHelperResult.VALID;
        }
        Map sessionCookies = (Map)request.getSession().getAttribute("org.hdiv.HdivCookies");
        if (sessionCookies == null) {
            return ValidatorHelperResult.VALID;
        }
        boolean cookiesConfidentiality = this.hdivConfig.getConfidentiality() && this.hdivConfig.isCookiesConfidentialityActivated();
        for (int i = 0; i < requestCookies.length; ++i) {
            SavedCookie savedCookie;
            boolean found = false;
            if (requestCookies[i].getName().equals("JSESSIONID")) continue;
            if (sessionCookies.containsKey(requestCookies[i].getName()) && (savedCookie = (SavedCookie)sessionCookies.get(requestCookies[i].getName())).isEqual(requestCookies[i], cookiesConfidentiality)) {
                found = true;
                if (cookiesConfidentiality && savedCookie.getValue() != null) {
                    requestCookies[i].setValue(savedCookie.getValue());
                }
            }
            if (found) continue;
            this.logger.log("INVALID_COOKIE", target, "cookie:" + requestCookies[i].getName(), requestCookies[i].getValue());
            return new ValidatorHelperResult("INVALID_COOKIE");
        }
        return ValidatorHelperResult.VALID;
    }

    protected void validateEditableParameter(HttpServletRequest request, String target, String parameter, String[] values, String dataType, Map<String, String[]> unauthorizedParameters) {
        boolean isValid = this.hdivConfig.areEditableParameterValuesValid(target, parameter, values, dataType);
        if (!isValid) {
            StringBuffer unauthorizedValues = new StringBuffer(values[0]);
            for (int i = 1; i < values.length; ++i) {
                unauthorizedValues.append("," + values[i]);
            }
            if (dataType.equals("password")) {
                String[] passwordError = new String[]{"hdiv.editable.password.error"};
                unauthorizedParameters.put(parameter, passwordError);
            } else {
                unauthorizedParameters.put(parameter, values);
            }
            this.logger.log("INVALID_EDITABLE_VALUE", target, parameter, unauthorizedValues.toString());
        }
    }

    private ValidatorHelperResult allRequiredParametersReceived(HttpServletRequest request, IState state, String target) {
        List<String> receivedParameters = state.getRequiredParams();
        Enumeration requestParameters = request.getParameterNames();
        while (requestParameters.hasMoreElements()) {
            String currentParameter = (String)requestParameters.nextElement();
            if (receivedParameters.contains(currentParameter)) {
                receivedParameters.remove(currentParameter);
            }
            if (receivedParameters.size() != 0) continue;
            return ValidatorHelperResult.VALID;
        }
        if (receivedParameters.size() > 0) {
            this.logger.log("NOT_RECEIVED_ALL_REQUIRED_PARAMETERS", target, receivedParameters.toString(), null);
            return new ValidatorHelperResult("NOT_RECEIVED_ALL_REQUIRED_PARAMETERS");
        }
        return ValidatorHelperResult.VALID;
    }

    protected ValidatorHelperResult validateParameter(HttpServletRequest request, IParameter stateParameter, String[] actionParamValues, Map<String, String[]> unauthorizedEditableParameters, String hdivParameter, String target, String parameter) {
        if (!this.hdivConfig.needValidation(parameter, hdivParameter)) {
            if (log.isDebugEnabled() && !parameter.equals(hdivParameter)) {
                log.debug((Object)("parameter " + parameter + " doesn't need validation"));
            }
            return ValidatorHelperResult.VALIDATION_NOT_REQUIRED;
        }
        if (this.isUserDefinedNonValidationParameter(target, parameter)) {
            return ValidatorHelperResult.VALIDATION_NOT_REQUIRED;
        }
        if (stateParameter == null && actionParamValues == null) {
            this.logger.log("INVALID_PARAMETER_NAME", target, parameter, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validation Error Detected: Parameter [" + parameter + "] does not exist in the state for action [" + target + "]"));
            }
            return new ValidatorHelperResult("INVALID_PARAMETER_NAME");
        }
        String[] values = request.getParameterValues(parameter);
        if (stateParameter != null && stateParameter.isEditable()) {
            this.addEditableParameter(request, parameter);
            if (this.hdivConfig.existValidations() && stateParameter.getEditableDataType() != null) {
                this.validateEditableParameter(request, target, parameter, values, stateParameter.getEditableDataType(), unauthorizedEditableParameters);
            }
            return ValidatorHelperResult.VALID;
        }
        try {
            ValidatorHelperResult result = this.validateParameterValues(request, target, stateParameter, actionParamValues, parameter, values);
            return result;
        }
        catch (HDIVException e) {
            String errorMessage = HDIVUtil.getMessage("validation.error", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
    }

    private boolean isUserDefinedNonValidationParameter(String target, String parameter) {
        if (this.hdivConfig.isParameterWithoutValidation(target, parameter)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("parameter " + parameter + " doesn't need validation. It is user defined parameter."));
            }
            return true;
        }
        return false;
    }

    private ValidatorHelperResult restoreState(HttpServletRequest request, String target) {
        String hdivParameter = this.getHdivParameter(request);
        String requestState = request.getParameter(hdivParameter);
        if (requestState == null) {
            this.logger.log("HDIV_PARAMETER_NOT_EXISTS", target, hdivParameter, null);
            return new ValidatorHelperResult("HDIV_PARAMETER_NOT_EXISTS");
        }
        try {
            IState state = this.stateUtil.restoreState(requestState);
            if (this.stateUtil.isMemoryStrategy(requestState) && !this.validateHDIVSuffix(requestState, state)) {
                this.logger.log("INVALID_HDIV_PARAMETER_VALUE", target, hdivParameter, requestState);
                return new ValidatorHelperResult("INVALID_HDIV_PARAMETER_VALUE");
            }
            return new ValidatorHelperResult(true, state);
        }
        catch (HDIVException e) {
            if (!this.hdivConfig.getStrategy().equals((Object)Strategy.MEMORY)) {
                requestState = null;
            }
            this.logger.log(e.getMessage(), target, hdivParameter, requestState);
            return new ValidatorHelperResult(e.getMessage());
        }
    }

    protected boolean validateHDIVSuffix(String value, IState restoredState) {
        int firstSeparator = value.indexOf("-");
        int lastSeparator = value.lastIndexOf("-");
        if (firstSeparator == -1) {
            return false;
        }
        if (firstSeparator >= lastSeparator) {
            return false;
        }
        try {
            String requestSuffix = value.substring(lastSeparator + 1);
            String pageId = value.substring(0, firstSeparator);
            String sId = value.substring(firstSeparator + 1, lastSeparator);
            int stateId = 0;
            try {
                stateId = Integer.parseInt(sId);
            }
            catch (NumberFormatException e) {
                throw new HDIVException("INVALID_PAGE_ID");
            }
            StateScope stateScope = this.stateScopeManager.getStateScope(value);
            if (stateScope != null) {
                String token = stateScope.getStateToken(stateId);
                return requestSuffix.equals(token);
            }
            IPage currentPage = this.session.getPage(pageId);
            if (currentPage == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Page with id [" + pageId + "] not found in session."));
                }
                throw new HDIVException("INVALID_PAGE_ID");
            }
            return currentPage.getRandomToken(restoredState.getMethod()).equals(requestSuffix);
        }
        catch (IndexOutOfBoundsException e) {
            String errorMessage = HDIVUtil.getMessage("validation.error", e.getMessage());
            if (log.isErrorEnabled()) {
                log.error((Object)errorMessage);
            }
            throw new HDIVException(errorMessage, e);
        }
    }

    private ValidatorHelperResult validateParameterValues(HttpServletRequest request, String target, IParameter stateParameter, String[] actionParamValues, String parameter, String[] values) {
        try {
            if (actionParamValues != null && values.length != actionParamValues.length) {
                String valueMessage = values.length > actionParamValues.length ? "extra value" : "more values expected";
                this.logger.log("NOT_RECEIVED_ALL_PARAMETER_VALUES", target, parameter, valueMessage);
                return new ValidatorHelperResult("NOT_RECEIVED_ALL_PARAMETER_VALUES");
            }
            List<String> stateParamValues = null;
            stateParamValues = stateParameter != null ? stateParameter.getValues() : Arrays.asList(actionParamValues);
            ValidatorHelperResult result = this.hasRepeatedOrInvalidValues(target, parameter, values, stateParamValues);
            if (!result.isValid()) {
                return result;
            }
            return this.validateReceivedValuesInState(request, target, stateParameter, actionParamValues, parameter, values);
        }
        catch (HDIVException e) {
            String errorMessage = HDIVUtil.getMessage("validation.error", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
    }

    private ValidatorHelperResult hasRepeatedOrInvalidValues(String target, String parameter, String[] values, List<String> stateValues) {
        ArrayList<String> tempStateValues = new ArrayList<String>();
        tempStateValues.addAll(stateValues);
        if (this.hdivConfig.getConfidentiality()) {
            return this.hasConfidentialIncorrectValues(target, parameter, values, tempStateValues);
        }
        return this.hasNonConfidentialIncorrectValues(target, parameter, values, tempStateValues);
    }

    private ValidatorHelperResult hasConfidentialIncorrectValues(String target, String parameter, String[] values, List<String> stateValues) {
        HashSet<String> receivedValues = new HashSet<String>();
        for (int i = 0; i < values.length; ++i) {
            if (this.hdivConfig.isParameterWithoutConfidentiality(parameter)) {
                return ValidatorHelperResult.VALID;
            }
            if (!this.isInRange(target, parameter, values[i], stateValues)) {
                return new ValidatorHelperResult("INVALID_CONFIDENTIAL_VALUE");
            }
            if (receivedValues.contains(values[i])) {
                String originalValue = stateValues.size() > 1 ? stateValues.toString() : stateValues.get(0);
                this.logger.log("REPEATED_VALUES_FOR_PARAMETER", target, parameter, values[i], originalValue);
                return new ValidatorHelperResult("REPEATED_VALUES_FOR_PARAMETER");
            }
            receivedValues.add(values[i]);
        }
        return ValidatorHelperResult.VALID;
    }

    private ValidatorHelperResult hasNonConfidentialIncorrectValues(String target, String parameter, String[] values, List<String> tempStateValues) {
        HashSet<String> receivedValues = new HashSet<String>();
        for (int i = 0; i < values.length; ++i) {
            boolean exists = false;
            for (int j = 0; j < tempStateValues.size() && !exists; ++j) {
                String tempValue = tempStateValues.get(j);
                if (!tempValue.equalsIgnoreCase(values[i])) continue;
                tempStateValues.remove(j);
                exists = true;
            }
            if (!exists) {
                if (receivedValues.contains(values[i])) {
                    String originalValue = tempStateValues.size() > 1 ? tempStateValues.toString() : tempStateValues.get(0);
                    this.logger.log("REPEATED_VALUES_FOR_PARAMETER", target, parameter, values[i], originalValue);
                    return new ValidatorHelperResult("REPEATED_VALUES_FOR_PARAMETER");
                }
                String originalValue = tempStateValues.size() > 1 ? tempStateValues.toString() : tempStateValues.get(0);
                this.logger.log("INVALID_PARAMETER_VALUE", target, parameter, values[i], originalValue);
                return new ValidatorHelperResult("INVALID_PARAMETER_VALUE");
            }
            receivedValues.add(values[i]);
        }
        return ValidatorHelperResult.VALID;
    }

    private boolean isInRange(String target, String parameter, String value, List<String> stateValues) {
        Matcher m = this.numberPattern.matcher(value);
        try {
            if (!m.matches() || Integer.valueOf(value) >= stateValues.size()) {
                String originalValue = stateValues.size() > 1 ? stateValues.toString() : stateValues.get(0);
                this.logger.log("INVALID_CONFIDENTIAL_VALUE", target, parameter, value, originalValue);
                return false;
            }
        }
        catch (NumberFormatException e) {
            String originalValue = stateValues.size() > 1 ? stateValues.toString() : stateValues.get(0);
            this.logger.log("INVALID_CONFIDENTIAL_VALUE", target, parameter, value, originalValue);
            return false;
        }
        return true;
    }

    private ValidatorHelperResult validateReceivedValuesInState(HttpServletRequest request, String target, IParameter stateParameter, String[] actionParamValues, String parameter, String[] values) {
        int size = values.length;
        String[] originalValues = new String[size];
        for (int i = 0; i < size; ++i) {
            IValidationResult result = this.dataValidator.validate(values[i], target, parameter, stateParameter, actionParamValues);
            if (!result.getLegal()) {
                this.logger.log("INVALID_PARAMETER_VALUE", target, parameter, values[i]);
                return new ValidatorHelperResult("INVALID_PARAMETER_VALUE");
            }
            originalValues[i] = (String)result.getResult();
        }
        if (this.hdivConfig.getConfidentiality()) {
            this.addParameterToRequest(request, parameter, originalValues);
        }
        return ValidatorHelperResult.VALID;
    }

    protected void addParameterToRequest(HttpServletRequest request, String name, Object value) {
        RequestWrapper wrapper = null;
        wrapper = request instanceof RequestWrapper ? (RequestWrapper)request : (RequestWrapper)this.getNativeRequest((ServletRequest)request, RequestWrapper.class);
        if (wrapper == null) {
            String errorMessage = HDIVUtil.getMessage("helper.notwrapper");
            throw new HDIVException(errorMessage);
        }
        wrapper.addParameter(name, value);
    }

    protected void addEditableParameter(HttpServletRequest request, String name) {
        if (request instanceof RequestWrapper) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Editable parameter [" + name + "] added."));
            }
            RequestWrapper wrapper = (RequestWrapper)request;
            wrapper.addEditableParameter(name);
        }
    }

    protected ServletRequest getNativeRequest(ServletRequest request, Class<?> requiredType) {
        if (requiredType != null) {
            if (requiredType.isInstance(request)) {
                return request;
            }
            if (request instanceof ServletRequestWrapper) {
                return this.getNativeRequest(((ServletRequestWrapper)request).getRequest(), requiredType);
            }
        }
        return null;
    }

    protected String getTarget(HttpServletRequest request) {
        try {
            String requestUri = request.getRequestURI();
            requestUri = HDIVUtil.stripSession(requestUri);
            return requestUri;
        }
        catch (Exception e) {
            String errorMessage = HDIVUtil.getMessage("helper.actionName");
            throw new HDIVException(errorMessage, e);
        }
    }

    protected String getTargetWithoutContextPath(HttpServletRequest request, String target) {
        String targetWithoutContextPath = target.substring(request.getContextPath().length());
        return targetWithoutContextPath;
    }

    protected String getHdivParameter(HttpServletRequest request) {
        return (String)request.getSession().getAttribute("HDIVParameter");
    }

    protected ValidatorHelperResult preValidate(HttpServletRequest request, String target) {
        return null;
    }

    @Override
    public void startPage(HttpServletRequest request) {
        boolean exclude = this.hdivConfig.hasExtensionToExclude(request.getRequestURI());
        if (!exclude) {
            IDataComposer dataComposer = this.dataComposerFactory.newInstance(request);
            HDIVUtil.setDataComposer(dataComposer, request);
        }
    }

    @Override
    public void endPage(HttpServletRequest request) {
        boolean exist = HDIVUtil.isDataComposer(request);
        if (exist) {
            IDataComposer dataComposer = HDIVUtil.getDataComposer(request);
            dataComposer.endPage();
            HDIVUtil.removeDataComposer(request);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setStateUtil(StateUtil stateUtil) {
        this.stateUtil = stateUtil;
    }

    public void setHdivConfig(HDIVConfig hdivConfig) {
        this.hdivConfig = hdivConfig;
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public void setDataValidator(IDataValidator dataValidator) {
        this.dataValidator = dataValidator;
    }

    public void setNumberPattern(Pattern numberPattern) {
        this.numberPattern = numberPattern;
    }

    public void setDataComposerFactory(DataComposerFactory dataComposerFactory) {
        this.dataComposerFactory = dataComposerFactory;
    }

    public void setUrlProcessor(BasicUrlProcessor urlProcessor) {
        this.urlProcessor = urlProcessor;
    }

    public void setStateScopeManager(StateScopeManager stateScopeManager) {
        this.stateScopeManager = stateScopeManager;
    }
}

