/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.filter.SavedCookie;
import org.hdiv.util.HDIVUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseWrapper
extends HttpServletResponseWrapper {
    private static Log log = LogFactory.getLog(ResponseWrapper.class);
    private static final String SET_COOKIE = "Set-Cookie";
    private Map<String, SavedCookie> cookies = new HashMap<String, SavedCookie>();
    private boolean confidentiality;
    private boolean avoidCookiesConfidentiality;

    public ResponseWrapper(HttpServletResponse originalResponse) {
        super(originalResponse);
        if (log.isDebugEnabled()) {
            log.debug((Object)"New ResponseWrapper instance.");
        }
    }

    public void setHeader(String name, String value) {
        String confidentialValue = value;
        if (name.equalsIgnoreCase(SET_COOKIE)) {
            this.cookies.clear();
            this.removeCookiesFromSession();
            List<String> parseValues = this.parseCookieString(value);
            if (this.confidentiality && !this.avoidCookiesConfidentiality) {
                confidentialValue = this.replaceOriginalValues(parseValues, value);
            }
        }
        super.setHeader(name, confidentialValue);
    }

    public void addHeader(String name, String value) {
        String confidentialValue = value;
        if (name.equalsIgnoreCase(SET_COOKIE)) {
            List<String> parseValues = this.parseCookieString(value);
            if (this.confidentiality && !this.avoidCookiesConfidentiality) {
                confidentialValue = this.replaceOriginalValues(parseValues, value);
            }
        }
        super.addHeader(name, confidentialValue);
    }

    protected String replaceOriginalValues(List<String> values, String value) {
        for (String currentValue : values) {
            value = value.replaceFirst("=" + currentValue, "=0");
        }
        return value;
    }

    public void reset() {
        super.reset();
        this.cookies.clear();
        this.removeCookiesFromSession();
    }

    private List<String> parseCookieString(String cookieString) {
        ArrayList<String> values = new ArrayList<String>();
        cookieString = cookieString.trim();
        StringTokenizer tokens = new StringTokenizer(cookieString, ";");
        while (tokens.hasMoreTokens()) {
            StringTokenizer t = new StringTokenizer(tokens.nextToken(), "=");
            String name = t.nextToken().trim();
            if (!t.hasMoreTokens()) continue;
            String value = t.nextToken().trim();
            this.cookies.put(name, new SavedCookie(name, value));
            values.add(value);
        }
        this.updateSessionCookies();
        return values;
    }

    public void addCookie(Cookie cookie) {
        SavedCookie savedCookie = new SavedCookie(cookie);
        this.cookies.put(savedCookie.getName(), savedCookie);
        this.updateSessionCookies();
        if (this.confidentiality && !this.avoidCookiesConfidentiality) {
            cookie.setValue("0");
        }
        super.addCookie(cookie);
    }

    private void updateSessionCookies() {
        if (HDIVUtil.getHttpSession() != null) {
            Map sessionOriginalCookies = (Map)HDIVUtil.getHttpSession().getAttribute("org.hdiv.HdivCookies");
            if (sessionOriginalCookies != null && sessionOriginalCookies.size() > 0) {
                sessionOriginalCookies.putAll(this.cookies);
                HDIVUtil.getHttpSession().setAttribute("org.hdiv.HdivCookies", (Object)sessionOriginalCookies);
            } else {
                HDIVUtil.getHttpSession().setAttribute("org.hdiv.HdivCookies", this.cookies);
            }
        }
    }

    protected void removeCookiesFromSession() {
        if (HDIVUtil.getHttpSession() != null) {
            HDIVUtil.getHttpSession().removeAttribute("org.hdiv.HdivCookies");
        }
    }

    public Map<String, SavedCookie> getCookies() {
        return this.cookies;
    }

    public void setConfidentiality(boolean confidentiality) {
        this.confidentiality = confidentiality;
    }

    public void setAvoidCookiesConfidentiality(boolean avoidCookiesConfidentiality) {
        this.avoidCookiesConfidentiality = avoidCookiesConfidentiality;
    }
}

