/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.hdiv.config.HDIVConfig;
import org.hdiv.filter.DefaultErrorPageWritter;
import org.hdiv.filter.ValidatorErrorHandler;
import org.hdiv.logs.IUserData;

public class DefaultValidatorErrorHandler
implements ValidatorErrorHandler {
    protected HDIVConfig config;
    protected IUserData userData;
    protected DefaultErrorPageWritter errorPageWritter = new DefaultErrorPageWritter();

    public void handleValidatorError(HttpServletRequest request, HttpServletResponse response, String errorCode) {
        HttpSession session = request.getSession(false);
        if ("INVALID_PAGE_ID".equals(errorCode)) {
            if (session == null || session.isNew()) {
                this.redirectToLoginPage(request, response);
            } else {
                String username = this.userData.getUsername(request);
                if (username == null || username == "anonymous") {
                    this.redirectToLoginPage(request, response);
                } else {
                    this.redirectToHomePage(request, response);
                }
            }
        } else {
            this.redirectToErrorPage(request, response);
        }
    }

    protected void redirectToErrorPage(HttpServletRequest request, HttpServletResponse response) {
        if (this.config.getErrorPage() != null) {
            this.redirect(response, request.getContextPath() + this.config.getErrorPage());
        } else {
            this.redirectToDefaultErrorPage(request, response);
        }
    }

    protected void redirectToLoginPage(HttpServletRequest request, HttpServletResponse response) {
        if (this.config.getSessionExpiredLoginPage() != null) {
            this.redirect(response, request.getContextPath() + this.config.getSessionExpiredLoginPage());
        } else {
            this.redirectToErrorPage(request, response);
        }
    }

    protected void redirectToHomePage(HttpServletRequest request, HttpServletResponse response) {
        if (this.config.getSessionExpiredHomePage() != null) {
            this.redirect(response, request.getContextPath() + this.config.getSessionExpiredHomePage());
        } else {
            this.redirectToErrorPage(request, response);
        }
    }

    protected void redirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(response.encodeRedirectURL(url));
        }
        catch (IOException e) {
            throw new RuntimeException("Cant redirect to: " + url, e);
        }
    }

    protected void redirectToDefaultErrorPage(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            Map editableErrors = (Map)request.getSession().getAttribute("org.hdiv.action.EDITABLE_PARAMETER_ERROR");
            request.getSession().removeAttribute("org.hdiv.action.EDITABLE_PARAMETER_ERROR");
            this.errorPageWritter.writetErrorPage(out, editableErrors);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Cant redirect to the default error page", e);
        }
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }

    public void setUserData(IUserData userData) {
        this.userData = userData;
    }
}

