/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hdiv.config.HDIVConfig;
import org.hdiv.filter.RequestInitializer;
import org.hdiv.filter.RequestWrapper;
import org.hdiv.filter.ResponseWrapper;
import org.hdiv.util.HDIVUtil;

public class DefaultRequestInitializer
implements RequestInitializer {
    protected HDIVConfig config;

    public void initRequest(HttpServletRequest request) {
        HDIVUtil.setHttpServletRequest(request);
        HDIVUtil.setRequestURI(request.getRequestURI(), request);
    }

    public void endRequest(HttpServletRequest request) {
        HDIVUtil.resetLocalData();
    }

    public RequestWrapper createRequestWrapper(HttpServletRequest request) {
        RequestWrapper requestWrapper = new RequestWrapper(request);
        requestWrapper.setConfidentiality(this.config.getConfidentiality());
        requestWrapper.setCookiesConfidentiality(this.config.isCookiesConfidentialityActivated());
        return requestWrapper;
    }

    public ResponseWrapper createResponseWrapper(HttpServletResponse response) {
        ResponseWrapper responseWrapper = new ResponseWrapper(response);
        responseWrapper.setConfidentiality(this.config.getConfidentiality());
        responseWrapper.setAvoidCookiesConfidentiality(!this.config.isCookiesConfidentialityActivated());
        return responseWrapper;
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }
}

