/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.dataComposer;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.dataComposer.AbstractDataComposer;
import org.hdiv.exception.HDIVException;
import org.hdiv.state.IPage;
import org.hdiv.state.IState;
import org.hdiv.state.State;
import org.hdiv.state.scope.StateScope;
import org.hdiv.state.scope.StateScopeManager;

public class DataComposerMemory
extends AbstractDataComposer {
    private static Log log = LogFactory.getLog(DataComposerMemory.class);
    protected int requestCounter = 0;
    protected StateScopeManager stateScopeManager;
    protected Stack<String> scopeStack;

    public void init() {
        super.init();
        this.scopeStack = new Stack();
        this.scopeStack.push("page");
    }

    public void startScope(String scope) {
        this.scopeStack.push(scope);
    }

    public void endScope() {
        this.scopeStack.pop();
    }

    protected String getCurrentScope() {
        return this.scopeStack.peek();
    }

    public String beginRequest() {
        return this.beginRequest(null, "");
    }

    public String beginRequest(String method, String action) {
        try {
            action = URLDecoder.decode(action, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HDIVException("UTF-8 enconding not supported.", e);
        }
        State state = new State(this.requestCounter);
        state.setAction(action);
        state.setMethod(method);
        return this.beginRequest(state);
    }

    public String beginRequest(IState state) {
        this.getStatesStack().push(state);
        String currentScope = this.getCurrentScope();
        StateScope stateScope = this.stateScopeManager.getStateScopeByName(currentScope);
        if (stateScope != null) {
            return null;
        }
        this.requestCounter = state.getId() + 1;
        String id = this.getPage().getName() + "-" + state.getId() + "-" + this.getStateSuffix(state.getMethod());
        return id;
    }

    public String endRequest() {
        boolean firstState;
        IState state = this.getStatesStack().pop();
        String currentScope = this.getCurrentScope();
        StateScope stateScope = this.stateScopeManager.getStateScopeByName(currentScope);
        if (stateScope != null) {
            String stateId = stateScope.addState(state, this.getStateSuffix(state.getMethod()));
            return stateId;
        }
        IPage page = this.getPage();
        state.setPageId(page.getId());
        page.addState(state);
        boolean bl = firstState = page.getStatesCount() == 1;
        if (firstState) {
            this.session.addPage(page.getName(), page);
        }
        String id = this.getPage().getId() + "-" + state.getId() + "-" + this.getStateSuffix(state.getMethod());
        return id;
    }

    public void startPage() {
        this.initPage();
    }

    public void startPage(IPage existingPage) {
        this.requestCounter = existingPage.getStatesCount();
        this.setPage(existingPage);
    }

    public void endPage() {
        IPage page;
        if (this.isRequestStarted()) {
            this.endRequest();
        }
        if ((page = this.getPage()).getStatesCount() > 0) {
            this.session.addPage(page.getName(), page);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("The page [" + page.getName() + "] has no states, is not stored in session"));
        }
    }

    public void setStateScopeManager(StateScopeManager stateScopeManager) {
        this.stateScopeManager = stateScopeManager;
    }
}

