/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.dataComposer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.dataComposer.DataComposerMemory;
import org.hdiv.state.IState;
import org.hdiv.util.EncodingUtil;

public class DataComposerHash
extends DataComposerMemory {
    private static Log log = LogFactory.getLog(DataComposerHash.class);
    private EncodingUtil encodingUtil;
    private int allowedLength;

    public String endRequest() {
        boolean firstState;
        IState state = super.getStatesStack().pop();
        state.setPageId(this.getPage().getId());
        String id = null;
        String stateWithSuffix = null;
        String stateData = this.encodingUtil.encode64(state);
        if (stateData.length() > this.allowedLength) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Move from Hash strategy to Memory because state data [" + stateData.length() + "] is greater than allowedLength [" + this.allowedLength));
            }
            this.getPage().addState(state);
            state.setPageId(this.getPage().getId());
            id = this.getPage().getId() + "-" + state.getId() + "-" + this.getStateSuffix(state.getMethod());
        } else {
            stateWithSuffix = stateData + "-" + this.getStateSuffix(state.getMethod());
            String stateHash = this.encodingUtil.calculateStateHash(stateWithSuffix);
            this.getPage().addState(state.getId(), stateHash);
        }
        boolean bl = firstState = this.page.getStatesCount() == 1;
        if (firstState) {
            this.session.addPage(this.page.getName(), this.page);
        }
        return id != null ? id : stateWithSuffix;
    }

    public void setEncodingUtil(EncodingUtil encodingUtil) {
        this.encodingUtil = encodingUtil;
    }

    public void setAllowedLength(int allowedLength) {
        this.allowedLength = allowedLength;
    }
}

