/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.dataComposer;

import javax.servlet.http.HttpServletRequest;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.Strategy;
import org.hdiv.dataComposer.DataComposerCipher;
import org.hdiv.dataComposer.DataComposerHash;
import org.hdiv.dataComposer.DataComposerMemory;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.exception.HDIVException;
import org.hdiv.idGenerator.UidGenerator;
import org.hdiv.session.ISession;
import org.hdiv.state.IPage;
import org.hdiv.state.IState;
import org.hdiv.state.StateUtil;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.util.EncodingUtil;
import org.hdiv.util.HDIVUtil;

public class DataComposerFactory {
    private static final int DEFAULT_ALLOWED_LENGTH = 4000;
    protected HDIVConfig config;
    protected ISession session;
    protected UidGenerator uidGenerator;
    protected int allowedLength = 4000;
    protected EncodingUtil encodingUtil;
    protected StateUtil stateUtil;
    protected StateScopeManager stateScopeManager;

    public IDataComposer newInstance(HttpServletRequest request) {
        DataComposerMemory dataComposer = null;
        if (this.config.getStrategy().equals((Object)Strategy.MEMORY)) {
            DataComposerMemory composer = new DataComposerMemory();
            composer.setHdivConfig(this.config);
            composer.setSession(this.session);
            composer.setUidGenerator(this.uidGenerator);
            composer.setStateScopeManager(this.stateScopeManager);
            composer.init();
            dataComposer = composer;
        } else if (this.config.getStrategy().equals((Object)Strategy.CIPHER)) {
            DataComposerCipher composer = new DataComposerCipher();
            composer.setHdivConfig(this.config);
            composer.setSession(this.session);
            composer.setUidGenerator(this.uidGenerator);
            composer.setStateScopeManager(this.stateScopeManager);
            composer.setAllowedLength(this.allowedLength);
            composer.setEncodingUtil(this.encodingUtil);
            composer.init();
            dataComposer = composer;
        } else if (this.config.getStrategy().equals((Object)Strategy.HASH)) {
            DataComposerHash composer = new DataComposerHash();
            composer.setHdivConfig(this.config);
            composer.setSession(this.session);
            composer.setUidGenerator(this.uidGenerator);
            composer.setStateScopeManager(this.stateScopeManager);
            composer.setAllowedLength(this.allowedLength);
            composer.setEncodingUtil(this.encodingUtil);
            composer.init();
            dataComposer = composer;
        } else {
            String errorMessage = HDIVUtil.getMessage("strategy.error", this.config.getStrategy().toString());
            throw new HDIVException(errorMessage);
        }
        this.initDataComposer(dataComposer, request);
        return dataComposer;
    }

    protected void initDataComposer(IDataComposer dataComposer, HttpServletRequest request) {
        String preState;
        String paramName = (String)request.getSession().getAttribute("modifyHDIVStateParameter");
        String string = preState = paramName != null ? request.getParameter(paramName) : null;
        if (preState != null && preState.length() > 0) {
            IPage page;
            IState state = this.stateUtil.restoreState(preState);
            if (state.getPageId() > 0 && (page = this.session.getPage(state.getPageId() + "")) != null) {
                dataComposer.startPage(page);
            }
            if (state != null) {
                dataComposer.beginRequest(state);
            }
        } else if (this.config.isReuseExistingPageInAjaxRequest() && this.isAjaxRequest(request)) {
            String hdivStateParamName = (String)request.getSession().getAttribute("HDIVParameter");
            String hdivState = request.getParameter(hdivStateParamName);
            IState state = this.stateUtil.restoreState(hdivState);
            IPage page = this.session.getPage(Integer.toString(state.getPageId()));
            dataComposer.startPage(page);
        } else {
            dataComposer.startPage();
        }
        String url = request.getRequestURI().substring(request.getContextPath().length());
        String scope = this.config.isLongLivingPages(url);
        if (scope != null) {
            dataComposer.startScope(scope);
        }
    }

    protected boolean isAjaxRequest(HttpServletRequest request) {
        String xRequestedWithValue = request.getHeader("x-requested-with");
        return xRequestedWithValue != null ? "XMLHttpRequest".equalsIgnoreCase(xRequestedWithValue) : false;
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public void setUidGenerator(UidGenerator uidGenerator) {
        this.uidGenerator = uidGenerator;
    }

    public void setAllowedLength(int allowedLength) {
        this.allowedLength = allowedLength;
    }

    public void setEncodingUtil(EncodingUtil encodingUtil) {
        this.encodingUtil = encodingUtil;
    }

    public void setStateUtil(StateUtil stateUtil) {
        this.stateUtil = stateUtil;
    }

    public void setStateScopeManager(StateScopeManager stateScopeManager) {
        this.stateScopeManager = stateScopeManager;
    }
}

