/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.dataComposer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.dataComposer.DataComposerMemory;
import org.hdiv.state.IState;
import org.hdiv.util.EncodingUtil;

public class DataComposerCipher
extends DataComposerMemory {
    private static Log log = LogFactory.getLog(DataComposerCipher.class);
    private EncodingUtil encodingUtil;
    private int allowedLength;
    private boolean savePage = false;

    public String endRequest() {
        IState state = super.getStatesStack().pop();
        state.setPageId(this.getPage().getId());
        String stateData = this.encodingUtil.encode64Cipher(state);
        String id = null;
        if (stateData.length() > this.allowedLength) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Move from Cipher strategy to Memory because state data [" + stateData.length() + "] is greater than allowedLength [" + this.allowedLength));
            }
            this.savePage = true;
            super.startPage();
            this.getPage().addState(state);
            state.setPageId(this.getPage().getId());
            id = this.getPage().getId() + "-" + state.getId() + "-" + this.getStateSuffix(state.getMethod());
        }
        return id != null ? id : stateData;
    }

    public void endPage() {
        if (this.savePage) {
            super.endPage();
        }
    }

    public void startPage() {
    }

    public void setEncodingUtil(EncodingUtil encodingUtil) {
        this.encodingUtil = encodingUtil;
    }

    public void setAllowedLength(int allowedLength) {
        this.allowedLength = allowedLength;
    }
}

