/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.cipher;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.hdiv.cipher.IKeyFactory;
import org.hdiv.cipher.Key;
import org.hdiv.exception.HDIVException;
import org.hdiv.util.HDIVUtil;

public class KeyFactory
implements IKeyFactory {
    public static final String DEFAULT_PRNG_ALGORITHM = "SHA1PRNG";
    public static final String DEFAULT_ALGORITHM = "AES";
    private String prngAlgorithm = "SHA1PRNG";
    private String algorithm = "AES";
    private int keySize;
    private String provider;

    public Key generateKey() {
        try {
            SecureRandom random = this.provider == null ? SecureRandom.getInstance(this.prngAlgorithm) : SecureRandom.getInstance(this.prngAlgorithm, this.provider);
            byte[] iv = new byte[16];
            random.nextBytes(iv);
            KeyGenerator kgen = KeyGenerator.getInstance(this.algorithm);
            if (this.keySize == 0) {
                kgen.init(random);
            } else {
                kgen.init(this.keySize, random);
            }
            SecretKey skey = kgen.generateKey();
            byte[] raw = skey.getEncoded();
            SecretKeySpec skeySpec = new SecretKeySpec(raw, this.algorithm);
            Key key = new Key();
            key.setKey(skeySpec);
            key.setInitVector(iv);
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            String errorMessage = HDIVUtil.getMessage("key.factory.generate", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
        catch (NoSuchProviderException e) {
            String errorMessage = HDIVUtil.getMessage("key.factory.generate", e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getPrngAlgorithm() {
        return this.prngAlgorithm;
    }

    public void setPrngAlgorithm(String prngAlgorithm) {
        this.prngAlgorithm = prngAlgorithm;
    }
}

