/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.application.ApplicationHDIV;
import org.hdiv.cipher.CipherHTTP;
import org.hdiv.cipher.KeyFactory;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.HDIVValidations;
import org.hdiv.config.StartPage;
import org.hdiv.config.Strategy;
import org.hdiv.config.multipart.JsfMultipartConfig;
import org.hdiv.config.multipart.SpringMVCMultipartConfig;
import org.hdiv.context.RedirectHelper;
import org.hdiv.dataComposer.DataComposerFactory;
import org.hdiv.dataValidator.DataValidator;
import org.hdiv.dataValidator.ValidationResult;
import org.hdiv.events.HDIVFacesEventListener;
import org.hdiv.filter.DefaultRequestInitializer;
import org.hdiv.filter.DefaultValidatorErrorHandler;
import org.hdiv.filter.IValidationHelper;
import org.hdiv.filter.JsfValidatorHelper;
import org.hdiv.filter.RequestInitializer;
import org.hdiv.filter.ValidatorErrorHandler;
import org.hdiv.filter.ValidatorHelperRequest;
import org.hdiv.idGenerator.RandomGuidUidGenerator;
import org.hdiv.idGenerator.SequentialPageIdGenerator;
import org.hdiv.idGenerator.UidGenerator;
import org.hdiv.logs.IUserData;
import org.hdiv.logs.Logger;
import org.hdiv.logs.UserData;
import org.hdiv.regex.PatternMatcherFactory;
import org.hdiv.session.ISession;
import org.hdiv.session.SessionHDIV;
import org.hdiv.session.StateCache;
import org.hdiv.state.StateUtil;
import org.hdiv.state.scope.AppStateScope;
import org.hdiv.state.scope.DefaultStateScopeManager;
import org.hdiv.state.scope.UserSessionStateScope;
import org.hdiv.urlProcessor.BasicUrlProcessor;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.util.EncodingUtil;
import org.hdiv.validators.EditableValidator;
import org.hdiv.validators.HtmlInputHiddenValidator;
import org.hdiv.validators.RequestParameterValidator;
import org.hdiv.validators.UICommandValidator;
import org.hdiv.web.servlet.support.GrailsHdivRequestDataValueProcessor;
import org.hdiv.web.servlet.support.HdivRequestDataValueProcessor;
import org.hdiv.web.servlet.support.ThymeleafHdivRequestDataValueProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.SpringVersion;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String CONFIG_BEAN_NAME = HDIVConfig.class.getName();
    public static final String UID_GENERATOR_BEAN_NAME = UidGenerator.class.getName();
    public static final String SESSION_BEAN_NAME = ISession.class.getName();
    public static final String VALIDATOR_ERROR_HANDLER_BEAN_NAME = ValidatorErrorHandler.class.getName();
    public static final String LOGGER_BEAN_NAME = Logger.class.getName();
    public static final String VALIDATOR_HELPER_NAME = IValidationHelper.class.getName();
    public static final String REQUEST_INITIALIZER_NAME = RequestInitializer.class.getName();
    public static final String PATTERN_MATCHER_FACTORY_NAME = PatternMatcherFactory.class.getName();
    public static final String LINK_URL_PROCESSOR_NAME = LinkUrlProcessor.class.getName();
    public static final String FORM_URL_PROCESSOR_NAME = FormUrlProcessor.class.getName();
    public static final String USER_DATA_NAME = IUserData.class.getName();
    public static final String REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME = "requestDataValueProcessor";
    protected static final String MIN_SPRING_VERSION = "4.0.0.RELEASE";
    protected static final boolean springVersionGrEqThan4 = SpringVersion.getVersion().compareTo("4.0.0.RELEASE") >= 0;
    protected final boolean springMvcPresent = ClassUtils.isPresent((String)"org.springframework.web.servlet.DispatcherServlet", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean grailsPresent = ClassUtils.isPresent((String)"org.codehaus.groovy.grails.web.servlet.GrailsDispatcherServlet", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean jsfPresent = ClassUtils.isPresent((String)"javax.faces.webapp.FacesServlet", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean jsfModulePresent = ClassUtils.isPresent((String)"org.hdiv.filter.JsfValidatorHelper", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean thymeleafPresent = ClassUtils.isPresent((String)"org.thymeleaf.spring3.SpringTemplateEngine", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader()) || ClassUtils.isPresent((String)"org.thymeleaf.spring4.SpringTemplateEngine", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected List<StartPage> startPages = new ArrayList<StartPage>();
    protected Map<String, String> longLivingPages = new HashMap<String, String>();
    protected RuntimeBeanReference patternMatcherFactoryRef;
    protected RuntimeBeanReference configRef;
    protected RuntimeBeanReference sessionRef;
    protected RuntimeBeanReference encodingUtilRef;
    protected RuntimeBeanReference uidGeneratorRef;
    protected RuntimeBeanReference stateUtilRef;
    protected RuntimeBeanReference dataValidatorRef;
    protected RuntimeBeanReference dataComposerFactoryRef;
    protected RuntimeBeanReference linkUrlProcessorRef;
    protected RuntimeBeanReference formUrlProcessorRef;
    protected RuntimeBeanReference basicUrlProcessorRef;
    protected RuntimeBeanReference loggerRef;
    protected RuntimeBeanReference userDataRef;
    protected RuntimeBeanReference stateScopeManagerRef;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        this.patternMatcherFactoryRef = this.createPatternMatcherFactory(element, source, parserContext);
        this.configRef = this.createConfigBean(element, source, parserContext);
        this.uidGeneratorRef = this.createSimpleBean(element, source, parserContext, RandomGuidUidGenerator.class, UID_GENERATOR_BEAN_NAME);
        this.createPageIdGenerator(element, source, parserContext);
        this.createKeyFactory(element, source, parserContext);
        this.userDataRef = this.createUserData(element, source, parserContext);
        this.stateScopeManagerRef = this.createStateScopeManager(element, source, parserContext);
        this.createValidatorErrorHandler(element, source, parserContext);
        this.loggerRef = this.createLogger(element, source, parserContext);
        this.createStateCache(element, source, parserContext);
        this.sessionRef = this.createSession(element, source, parserContext);
        this.encodingUtilRef = this.createEncodingUtil(element, source, parserContext);
        this.createSimpleBean(element, source, parserContext, ApplicationHDIV.class);
        this.createCipher(element, source, parserContext);
        this.createSimpleBean(element, source, parserContext, ValidationResult.class);
        this.stateUtilRef = this.createStateUtil(element, source, parserContext);
        this.dataValidatorRef = this.createDataValidator(element, source, parserContext);
        this.dataComposerFactoryRef = this.createDataComposerFactory(element, source, parserContext);
        this.linkUrlProcessorRef = this.createLinkUrlProcessor(element, source, parserContext);
        this.formUrlProcessorRef = this.createFormUrlProcessor(element, source, parserContext);
        this.basicUrlProcessorRef = this.createBasicUrlProcessor(element, source, parserContext);
        this.createRequestInitializer(element, source, parserContext);
        if (this.springMvcPresent) {
            if (this.grailsPresent) {
                this.createGrailsRequestDataValueProcessor(element, source, parserContext);
            } else if (this.thymeleafPresent) {
                this.createThymeleafRequestDataValueProcessor(element, source, parserContext);
            } else {
                this.createRequestDataValueProcessor(element, source, parserContext);
            }
            this.createSimpleBean(element, source, parserContext, SpringMVCMultipartConfig.class);
        }
        if (this.jsfPresent && this.jsfModulePresent) {
            this.createJsfValidatorHelper(element, source, parserContext);
            this.createSimpleBean(element, source, parserContext, JsfMultipartConfig.class);
            this.createFacesEventListener(element, source, parserContext);
            this.createRedirectHelper(element, source, parserContext);
        } else {
            this.createValidatorHelper(element, source, parserContext);
        }
        return null;
    }

    protected RuntimeBeanReference createPatternMatcherFactory(Element element, Object source, ParserContext parserContext) {
        return this.createSimpleBean(element, source, parserContext, PatternMatcherFactory.class, PATTERN_MATCHER_FACTORY_NAME);
    }

    protected RuntimeBeanReference createPageIdGenerator(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(SequentialPageIdGenerator.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setScope("prototype");
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createKeyFactory(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(KeyFactory.class);
        bean.setSource(source);
        bean.setRole(2);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createUserData(Element element, Object source, ParserContext parserContext) {
        String userData = element.getAttribute("userData");
        if (userData == null || userData.length() < 1) {
            return this.createSimpleBean(element, source, parserContext, UserData.class, USER_DATA_NAME);
        }
        parserContext.getRegistry().registerAlias(userData, USER_DATA_NAME);
        return new RuntimeBeanReference(USER_DATA_NAME);
    }

    protected RuntimeBeanReference createLogger(Element element, Object source, ParserContext parserContext) {
        boolean existBean = parserContext.getRegistry().containsBeanDefinition(LOGGER_BEAN_NAME);
        if (!existBean) {
            RootBeanDefinition bean = new RootBeanDefinition(Logger.class);
            bean.setSource(source);
            bean.setRole(2);
            bean.getPropertyValues().addPropertyValue("userData", (Object)this.userDataRef);
            parserContext.getRegistry().registerBeanDefinition(LOGGER_BEAN_NAME, (BeanDefinition)bean);
            return new RuntimeBeanReference(LOGGER_BEAN_NAME);
        }
        return new RuntimeBeanReference(LOGGER_BEAN_NAME);
    }

    protected RuntimeBeanReference createValidatorErrorHandler(Element element, Object source, ParserContext parserContext) {
        boolean existBean = parserContext.getRegistry().containsBeanDefinition(VALIDATOR_ERROR_HANDLER_BEAN_NAME);
        if (!existBean) {
            RootBeanDefinition bean = new RootBeanDefinition(DefaultValidatorErrorHandler.class);
            bean.setSource(source);
            bean.setRole(2);
            bean.getPropertyValues().addPropertyValue("userData", (Object)this.userDataRef);
            bean.getPropertyValues().addPropertyValue("config", (Object)this.configRef);
            parserContext.getRegistry().registerBeanDefinition(VALIDATOR_ERROR_HANDLER_BEAN_NAME, (BeanDefinition)bean);
            return new RuntimeBeanReference(VALIDATOR_ERROR_HANDLER_BEAN_NAME);
        }
        return new RuntimeBeanReference(VALIDATOR_ERROR_HANDLER_BEAN_NAME);
    }

    protected RuntimeBeanReference createStateCache(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(StateCache.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setScope("prototype");
        String maxSize = element.getAttribute("maxPagesPerSession");
        if (StringUtils.hasText((String)maxSize)) {
            bean.getPropertyValues().addPropertyValue("maxSize", (Object)maxSize);
        }
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createEncodingUtil(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(EncodingUtil.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setInitMethodName("init");
        bean.getPropertyValues().addPropertyValue("session", (Object)this.sessionRef);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createSession(Element element, Object source, ParserContext parserContext) {
        boolean existSession = parserContext.getRegistry().containsBeanDefinition(SESSION_BEAN_NAME);
        if (!existSession) {
            return this.createSimpleBean(element, source, parserContext, SessionHDIV.class, SESSION_BEAN_NAME);
        }
        return new RuntimeBeanReference(SESSION_BEAN_NAME);
    }

    protected RuntimeBeanReference createCipher(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(CipherHTTP.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setScope("prototype");
        bean.setInitMethodName("init");
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createStateUtil(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(StateUtil.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setInitMethodName("init");
        bean.getPropertyValues().addPropertyValue("encodingUtil", (Object)this.encodingUtilRef);
        bean.getPropertyValues().addPropertyValue("config", (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue("session", (Object)this.sessionRef);
        bean.getPropertyValues().addPropertyValue("stateScopeManager", (Object)this.stateScopeManagerRef);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createDataValidator(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DataValidator.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("config", (Object)this.configRef);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createStateScopeManager(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DefaultStateScopeManager.class);
        bean.setSource(source);
        bean.setRole(2);
        ManagedList defs = new ManagedList();
        defs.add((Object)this.createSimpleBean(element, source, parserContext, UserSessionStateScope.class));
        defs.add((Object)this.createSimpleBean(element, source, parserContext, AppStateScope.class));
        RootBeanDefinition listBean = new RootBeanDefinition(ListFactoryBean.class);
        listBean.setSource(source);
        listBean.setRole(2);
        listBean.getPropertyValues().addPropertyValue("sourceList", (Object)defs);
        bean.getConstructorArgumentValues().addGenericArgumentValue((Object)listBean);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createDataComposerFactory(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DataComposerFactory.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("config", (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue("session", (Object)this.sessionRef);
        bean.getPropertyValues().addPropertyValue("encodingUtil", (Object)this.encodingUtilRef);
        bean.getPropertyValues().addPropertyValue("stateUtil", (Object)this.stateUtilRef);
        bean.getPropertyValues().addPropertyValue("uidGenerator", (Object)this.uidGeneratorRef);
        bean.getPropertyValues().addPropertyValue("stateScopeManager", (Object)this.stateScopeManagerRef);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createValidatorHelper(Element element, Object source, ParserContext parserContext) {
        boolean exist = parserContext.getRegistry().containsBeanDefinition(VALIDATOR_HELPER_NAME);
        if (!exist) {
            RootBeanDefinition bean = new RootBeanDefinition(ValidatorHelperRequest.class);
            bean.setSource(source);
            bean.setRole(2);
            bean.setInitMethodName("init");
            bean.getPropertyValues().addPropertyValue("logger", (Object)this.loggerRef);
            bean.getPropertyValues().addPropertyValue("stateUtil", (Object)this.stateUtilRef);
            bean.getPropertyValues().addPropertyValue("hdivConfig", (Object)this.configRef);
            bean.getPropertyValues().addPropertyValue("session", (Object)this.sessionRef);
            bean.getPropertyValues().addPropertyValue("dataValidator", (Object)this.dataValidatorRef);
            bean.getPropertyValues().addPropertyValue("urlProcessor", (Object)this.basicUrlProcessorRef);
            bean.getPropertyValues().addPropertyValue("dataComposerFactory", (Object)this.dataComposerFactoryRef);
            bean.getPropertyValues().addPropertyValue("stateScopeManager", (Object)this.stateScopeManagerRef);
            parserContext.getRegistry().registerBeanDefinition(VALIDATOR_HELPER_NAME, (BeanDefinition)bean);
            return new RuntimeBeanReference(VALIDATOR_HELPER_NAME);
        }
        return new RuntimeBeanReference(VALIDATOR_HELPER_NAME);
    }

    protected RuntimeBeanReference createRequestInitializer(Element element, Object source, ParserContext parserContext) {
        boolean exist = parserContext.getRegistry().containsBeanDefinition(REQUEST_INITIALIZER_NAME);
        if (!exist) {
            RootBeanDefinition bean = new RootBeanDefinition(DefaultRequestInitializer.class);
            bean.setSource(source);
            bean.setRole(2);
            bean.getPropertyValues().addPropertyValue("config", (Object)this.configRef);
            parserContext.getRegistry().registerBeanDefinition(REQUEST_INITIALIZER_NAME, (BeanDefinition)bean);
            return new RuntimeBeanReference(REQUEST_INITIALIZER_NAME);
        }
        return new RuntimeBeanReference(REQUEST_INITIALIZER_NAME);
    }

    protected RuntimeBeanReference createLinkUrlProcessor(Element element, Object source, ParserContext parserContext) {
        boolean exist = parserContext.getRegistry().containsBeanDefinition(LINK_URL_PROCESSOR_NAME);
        if (!exist) {
            RootBeanDefinition bean = new RootBeanDefinition(LinkUrlProcessor.class);
            bean.setSource(source);
            bean.setRole(2);
            bean.getPropertyValues().addPropertyValue("config", (Object)this.configRef);
            parserContext.getRegistry().registerBeanDefinition(LINK_URL_PROCESSOR_NAME, (BeanDefinition)bean);
            return new RuntimeBeanReference(LINK_URL_PROCESSOR_NAME);
        }
        return new RuntimeBeanReference(LINK_URL_PROCESSOR_NAME);
    }

    protected RuntimeBeanReference createFormUrlProcessor(Element element, Object source, ParserContext parserContext) {
        boolean exist = parserContext.getRegistry().containsBeanDefinition(FORM_URL_PROCESSOR_NAME);
        if (!exist) {
            RootBeanDefinition bean = new RootBeanDefinition(FormUrlProcessor.class);
            bean.setSource(source);
            bean.setRole(2);
            bean.getPropertyValues().addPropertyValue("config", (Object)this.configRef);
            parserContext.getRegistry().registerBeanDefinition(FORM_URL_PROCESSOR_NAME, (BeanDefinition)bean);
            return new RuntimeBeanReference(FORM_URL_PROCESSOR_NAME);
        }
        return new RuntimeBeanReference(FORM_URL_PROCESSOR_NAME);
    }

    protected RuntimeBeanReference createBasicUrlProcessor(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(BasicUrlProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("config", (Object)this.configRef);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createRequestDataValueProcessor(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(HdivRequestDataValueProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("linkUrlProcessor", (Object)this.linkUrlProcessorRef);
        bean.getPropertyValues().addPropertyValue("formUrlProcessor", (Object)this.formUrlProcessorRef);
        if (springSecurityPresent && springVersionGrEqThan4) {
            bean.getPropertyValues().addPropertyValue("innerRequestDataValueProcessor", (Object)new CsrfRequestDataValueProcessor());
        }
        parserContext.getRegistry().registerBeanDefinition(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME, (BeanDefinition)bean);
        return new RuntimeBeanReference(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME);
    }

    protected RuntimeBeanReference createGrailsRequestDataValueProcessor(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(GrailsHdivRequestDataValueProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("linkUrlProcessor", (Object)this.linkUrlProcessorRef);
        bean.getPropertyValues().addPropertyValue("formUrlProcessor", (Object)this.formUrlProcessorRef);
        parserContext.getRegistry().registerBeanDefinition(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME, (BeanDefinition)bean);
        return new RuntimeBeanReference(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME);
    }

    protected RuntimeBeanReference createThymeleafRequestDataValueProcessor(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(ThymeleafHdivRequestDataValueProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("linkUrlProcessor", (Object)this.linkUrlProcessorRef);
        bean.getPropertyValues().addPropertyValue("formUrlProcessor", (Object)this.formUrlProcessorRef);
        parserContext.getRegistry().registerBeanDefinition(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME, (BeanDefinition)bean);
        return new RuntimeBeanReference(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME);
    }

    protected RuntimeBeanReference createConfigBean(Element element, Object source, ParserContext parserContext) {
        BeanDefinition bean = this.createConfigBean(element, source, parserContext, HDIVConfig.class);
        parserContext.getRegistry().registerBeanDefinition(CONFIG_BEAN_NAME, bean);
        return new RuntimeBeanReference(CONFIG_BEAN_NAME);
    }

    protected BeanDefinition createConfigBean(Element element, Object source, ParserContext parserContext, Class<?> configClass) {
        RootBeanDefinition bean = new RootBeanDefinition(configClass);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("patternMatcherFactory", (Object)this.patternMatcherFactoryRef);
        String confidentiality = element.getAttribute("confidentiality");
        String avoidCookiesIntegrity = element.getAttribute("avoidCookiesIntegrity");
        String avoidCookiesConfidentiality = element.getAttribute("avoidCookiesConfidentiality");
        String avoidValidationInUrlsWithoutParams = element.getAttribute("avoidValidationInUrlsWithoutParams");
        String strategy = element.getAttribute("strategy");
        String randomName = element.getAttribute("randomName");
        String errorPage = element.getAttribute("errorPage");
        String protectedExtensions = element.getAttribute("protectedExtensions");
        String excludedExtensions = element.getAttribute("excludedExtensions");
        String debugMode = element.getAttribute("debugMode");
        String showErrorPageOnEditableValidation = element.getAttribute("showErrorPageOnEditableValidation");
        String reuseExistingPageInAjaxRequest = element.getAttribute("reuseExistingPageInAjaxRequest");
        if (StringUtils.hasText((String)confidentiality)) {
            bean.getPropertyValues().addPropertyValue("confidentiality", (Object)confidentiality);
        }
        if (StringUtils.hasText((String)avoidCookiesIntegrity)) {
            bean.getPropertyValues().addPropertyValue("avoidCookiesIntegrity", (Object)avoidCookiesIntegrity);
        }
        if (StringUtils.hasText((String)avoidCookiesConfidentiality)) {
            bean.getPropertyValues().addPropertyValue("avoidCookiesConfidentiality", (Object)avoidCookiesConfidentiality);
        }
        if (StringUtils.hasText((String)avoidValidationInUrlsWithoutParams)) {
            bean.getPropertyValues().addPropertyValue("avoidValidationInUrlsWithoutParams", (Object)avoidValidationInUrlsWithoutParams);
        }
        if (StringUtils.hasText((String)strategy)) {
            bean.getPropertyValues().addPropertyValue("strategy", (Object)Strategy.valueOf((String)strategy.toUpperCase()));
        }
        if (StringUtils.hasText((String)randomName)) {
            bean.getPropertyValues().addPropertyValue("randomName", (Object)randomName);
        }
        if (StringUtils.hasText((String)errorPage)) {
            bean.getPropertyValues().addPropertyValue("errorPage", (Object)errorPage);
        }
        if (StringUtils.hasText((String)protectedExtensions)) {
            bean.getPropertyValues().addPropertyValue("protectedExtensions", this.convertToList(protectedExtensions));
        }
        if (StringUtils.hasText((String)excludedExtensions)) {
            bean.getPropertyValues().addPropertyValue("excludedExtensions", this.convertToList(excludedExtensions));
        }
        if (StringUtils.hasText((String)debugMode)) {
            bean.getPropertyValues().addPropertyValue("debugMode", (Object)debugMode);
        }
        if (StringUtils.hasText((String)showErrorPageOnEditableValidation)) {
            bean.getPropertyValues().addPropertyValue("showErrorPageOnEditableValidation", (Object)showErrorPageOnEditableValidation);
        }
        if (StringUtils.hasText((String)reuseExistingPageInAjaxRequest)) {
            bean.getPropertyValues().addPropertyValue("reuseExistingPageInAjaxRequest", (Object)reuseExistingPageInAjaxRequest);
        }
        bean.getPropertyValues().addPropertyValue("validations", (Object)new RuntimeBeanReference("org.hdiv.editableValidations"));
        if (!parserContext.getRegistry().containsBeanDefinition("org.hdiv.editableValidations")) {
            this.createDefaultEditableParametersValidations(element, source, parserContext);
        }
        this.processChilds(element, bean);
        return bean;
    }

    protected RuntimeBeanReference createDefaultEditableParametersValidations(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(HDIVValidations.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("urls", new HashMap());
        parserContext.getRegistry().registerBeanDefinition("org.hdiv.editableValidations", (BeanDefinition)bean);
        return new RuntimeBeanReference("org.hdiv.editableValidations");
    }

    protected RuntimeBeanReference createFacesEventListener(Element element, Object source, ParserContext parserContext) {
        RuntimeBeanReference requestParameterValidatorRef = this.createRequestParameterValidator(element, source, parserContext);
        RuntimeBeanReference uiCommandValidatorRef = this.createSimpleBean(element, source, parserContext, UICommandValidator.class);
        RuntimeBeanReference htmlInputHiddenValidatorRef = this.createSimpleBean(element, source, parserContext, HtmlInputHiddenValidator.class);
        RuntimeBeanReference editableValidatorRef = this.createEditableValidator(element, source, parserContext);
        RootBeanDefinition bean = new RootBeanDefinition(HDIVFacesEventListener.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("config", (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue("logger", (Object)this.loggerRef);
        bean.getPropertyValues().addPropertyValue("htmlInputHiddenValidator", (Object)htmlInputHiddenValidatorRef);
        bean.getPropertyValues().addPropertyValue("requestParamValidator", (Object)requestParameterValidatorRef);
        bean.getPropertyValues().addPropertyValue("uiCommandValidator", (Object)uiCommandValidatorRef);
        bean.getPropertyValues().addPropertyValue("editableValidator", (Object)editableValidatorRef);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createJsfValidatorHelper(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(JsfValidatorHelper.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setInitMethodName("init");
        bean.getPropertyValues().addPropertyValue("logger", (Object)this.loggerRef);
        bean.getPropertyValues().addPropertyValue("stateUtil", (Object)this.stateUtilRef);
        bean.getPropertyValues().addPropertyValue("hdivConfig", (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue("session", (Object)this.sessionRef);
        bean.getPropertyValues().addPropertyValue("dataValidator", (Object)this.dataValidatorRef);
        bean.getPropertyValues().addPropertyValue("urlProcessor", (Object)this.basicUrlProcessorRef);
        bean.getPropertyValues().addPropertyValue("dataComposerFactory", (Object)this.dataComposerFactoryRef);
        bean.getPropertyValues().addPropertyValue("stateScopeManager", (Object)this.stateScopeManagerRef);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createRequestParameterValidator(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(RequestParameterValidator.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("hdivConfig", (Object)this.configRef);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createEditableValidator(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(EditableValidator.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("hdivConfig", (Object)this.configRef);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createRedirectHelper(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(RedirectHelper.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("linkUrlProcessor", (Object)this.linkUrlProcessorRef);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createStringBean(String name, String value, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(String.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)value);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createSimpleBean(Element element, Object source, ParserContext parserContext, Class<?> clazz) {
        RootBeanDefinition bean = new RootBeanDefinition(clazz);
        bean.setSource(source);
        bean.setRole(2);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createSimpleBean(Element element, Object source, ParserContext parserContext, Class<?> clazz, String beanName) {
        boolean exist = parserContext.getRegistry().containsBeanDefinition(beanName);
        if (!exist) {
            RootBeanDefinition bean = new RootBeanDefinition(clazz);
            bean.setSource(source);
            bean.setRole(2);
            parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)bean);
            return new RuntimeBeanReference(beanName);
        }
        return new RuntimeBeanReference(beanName);
    }

    protected void processChilds(Element element, RootBeanDefinition bean) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equalsIgnoreCase("startPages")) {
                this.processStartPages(node, bean);
                continue;
            }
            if (node.getLocalName().equalsIgnoreCase("startParameters")) {
                this.processStartParameters(node, bean);
                continue;
            }
            if (node.getLocalName().equalsIgnoreCase("paramsWithoutValidation")) {
                this.processParamsWithoutValidation(node, bean);
                continue;
            }
            if (node.getLocalName().equalsIgnoreCase("sessionExpired")) {
                this.processSessionExpired(node, bean);
                continue;
            }
            if (!node.getLocalName().equalsIgnoreCase("longLivingPages")) continue;
            this.processLongLivingPages(node, bean);
        }
    }

    protected void processStartPages(Node node, RootBeanDefinition bean) {
        String method = null;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            method = element.getAttribute("method");
        }
        String value = node.getTextContent();
        List<String> patterns = this.convertToList(value);
        for (int i = 0; i < patterns.size(); ++i) {
            String pattern = patterns.get(i);
            StartPage startPage = new StartPage(method, pattern);
            this.startPages.add(startPage);
        }
        bean.getPropertyValues().addPropertyValue("userStartPages", this.startPages);
    }

    protected void processStartParameters(Node node, RootBeanDefinition bean) {
        String value = node.getTextContent();
        bean.getPropertyValues().addPropertyValue("userStartParameters", this.convertToList(value));
    }

    protected void processParamsWithoutValidation(Node node, RootBeanDefinition bean) {
        NodeList nodeList = node.getChildNodes();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        bean.getPropertyValues().addPropertyValue("paramsWithoutValidation", map);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node mappingNode = nodeList.item(i);
            if (mappingNode.getNodeType() != 1 || !mappingNode.getLocalName().equalsIgnoreCase("mapping")) continue;
            this.processMapping(mappingNode, map);
        }
    }

    protected void processSessionExpired(Node node, RootBeanDefinition bean) {
        NamedNodeMap attributes = node.getAttributes();
        Node named = attributes.getNamedItem("loginPage");
        if (named != null) {
            String loginPage = named.getTextContent();
            bean.getPropertyValues().addPropertyValue("sessionExpiredLoginPage", (Object)loginPage);
        }
        if ((named = attributes.getNamedItem("homePage")) != null) {
            String homePage = named.getTextContent();
            bean.getPropertyValues().addPropertyValue("sessionExpiredHomePage", (Object)homePage);
        }
    }

    protected void processLongLivingPages(Node node, RootBeanDefinition bean) {
        NamedNodeMap attributes = node.getAttributes();
        Node named = attributes.getNamedItem("scope");
        String scope = named.getTextContent();
        String value = node.getTextContent();
        List<String> patterns = this.convertToList(value);
        for (String pattern : patterns) {
            this.longLivingPages.put(pattern, scope);
        }
        bean.getPropertyValues().addPropertyValue("longLivingPages", this.longLivingPages);
    }

    protected void processMapping(Node node, Map<String, List<String>> map) {
        NamedNodeMap attributes = node.getAttributes();
        Node named = attributes.getNamedItem("url");
        if (named != null) {
            String url = named.getTextContent();
            String parameters = attributes.getNamedItem("parameters").getTextContent();
            map.put(url, this.convertToList(parameters));
        }
    }

    protected List<String> convertToList(String data) {
        String[] result = data.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < result.length; ++i) {
            list.add(StringUtils.trimWhitespace((String)result[i]));
        }
        return list;
    }
}

