/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation.springmvc;

import org.hdiv.config.annotation.condition.ConditionalOnFramework;
import org.hdiv.config.annotation.condition.SupportedFramework;
import org.hdiv.config.multipart.IMultipartConfig;
import org.hdiv.config.multipart.SpringMVCMultipartConfig;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.web.servlet.support.HdivRequestDataValueProcessor;
import org.hdiv.web.validator.EditableParameterValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

@Configuration
@ConditionalOnFramework(value=SupportedFramework.SPRING_MVC)
public class SpringMvcConfigurationSupport {
    protected static final boolean jsr303Present = ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)SpringMvcConfigurationSupport.class.getClassLoader());
    protected static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor", (ClassLoader)SpringMvcConfigurationSupport.class.getClassLoader());
    @Autowired
    protected FormUrlProcessor formUrlProcessor;
    @Autowired
    protected LinkUrlProcessor linkUrlProcessor;

    @Bean(name={"requestDataValueProcessor"})
    public RequestDataValueProcessor requestDataValueProcessor() {
        HdivRequestDataValueProcessor dataValueProcessor = new HdivRequestDataValueProcessor();
        dataValueProcessor.setFormUrlProcessor(this.formUrlProcessor);
        dataValueProcessor.setLinkUrlProcessor(this.linkUrlProcessor);
        if (springSecurityPresent) {
            dataValueProcessor.setInnerRequestDataValueProcessor((RequestDataValueProcessor)new CsrfRequestDataValueProcessor());
        }
        return dataValueProcessor;
    }

    @Bean(name={"hdivEditableValidator"})
    public Validator editableParameterValidator() {
        EditableParameterValidator validator = new EditableParameterValidator();
        if (jsr303Present) {
            validator.setInnerValidator((Validator)new LocalValidatorFactoryBean());
        }
        return validator;
    }

    @Bean
    public IMultipartConfig securityMultipartConfig() {
        SpringMVCMultipartConfig multipartConfig = new SpringMVCMultipartConfig();
        return multipartConfig;
    }
}

