/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation.condition;

import java.util.Collection;
import java.util.List;
import org.hdiv.config.annotation.condition.ConditionalOnFramework;
import org.hdiv.config.annotation.condition.SupportedFramework;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;

public class OnFrameworkCondition
implements ConfigurationCondition {
    protected final boolean springMvcModulePresent = ClassUtils.isPresent((String)"org.hdiv.web.servlet.support.HdivRequestDataValueProcessor", (ClassLoader)OnFrameworkCondition.class.getClassLoader());
    protected final boolean grailsModulePresent = ClassUtils.isPresent((String)"org.hdiv.web.servlet.support.GrailsHdivRequestDataValueProcessor", (ClassLoader)OnFrameworkCondition.class.getClassLoader());
    protected final boolean grailsPresent = ClassUtils.isPresent((String)"org.codehaus.groovy.grails.web.servlet.GrailsDispatcherServlet", (ClassLoader)OnFrameworkCondition.class.getClassLoader());
    protected final boolean jsfPresent = ClassUtils.isPresent((String)"javax.faces.webapp.FacesServlet", (ClassLoader)OnFrameworkCondition.class.getClassLoader());
    protected final boolean jsfModulePresent = ClassUtils.isPresent((String)"org.hdiv.filter.JsfValidatorHelper", (ClassLoader)OnFrameworkCondition.class.getClassLoader());
    protected final boolean thymeleafModulePresent = ClassUtils.isPresent((String)"org.hdiv.web.servlet.support.ThymeleafHdivRequestDataValueProcessor", (ClassLoader)OnFrameworkCondition.class.getClassLoader());

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(ConditionalOnFramework.class.getName(), true);
        List values = (List)attributes.get((Object)"value");
        Assert.notEmpty((Collection)values);
        SupportedFramework frwk = (SupportedFramework)((Object)values.get(0));
        if (frwk == SupportedFramework.SPRING_MVC) {
            return this.springMvcModulePresent;
        }
        if (frwk == SupportedFramework.THYMELEAF) {
            return this.thymeleafModulePresent;
        }
        if (frwk == SupportedFramework.GRAILS) {
            return this.grailsPresent && this.grailsModulePresent;
        }
        if (frwk == SupportedFramework.JSF) {
            return this.jsfPresent && this.jsfModulePresent;
        }
        return false;
    }
}

