/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.tests.common;

import java.util.List;
import org.hawkular.btm.api.model.btxn.Consumer;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.Producer;
import org.hawkular.btm.tests.server.TestBTMServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class ClientTestBase {
    private TestBTMServer testBTMServer = new TestBTMServer();

    public int getPort() {
        return 8080;
    }

    @Before
    public void init() {
        try {
            this.testBTMServer.setPort(this.getPort());
            this.testBTMServer.setShutdownTimer(-1);
            this.testBTMServer.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void close() {
        try {
            this.testBTMServer.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ClientTestBase e = this;
            synchronized (e) {
                this.wait(2000L);
            }
        }
        catch (Exception e) {
            Assert.fail((String)"Failed to wait after test close");
        }
    }

    public TestBTMServer getTestBTMServer() {
        return this.testBTMServer;
    }

    public void setTestBTMServer(TestBTMServer testBTMServer) {
        this.testBTMServer = testBTMServer;
    }

    protected void checkInteractionCorrelationIdentifiers(Producer producer, Consumer consumer) {
        CorrelationIdentifier pcid = (CorrelationIdentifier)producer.getCorrelationIds().iterator().next();
        CorrelationIdentifier ccid = (CorrelationIdentifier)consumer.getCorrelationIds().iterator().next();
        Assert.assertEquals((Object)pcid, (Object)ccid);
    }

    protected <T extends Node> void findNodes(List<Node> nodes, Class<T> cls, List<T> results) {
        for (Node n : nodes) {
            if (n instanceof ContainerNode) {
                this.findNodes(((ContainerNode)n).getNodes(), cls, results);
            }
            if (!cls.isAssignableFrom(n.getClass())) continue;
            results.add(n);
        }
    }
}

