/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.junit;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.rules.Verifier;
import org.junit.runners.model.MultipleFailureException;

public class ErrorCollector
extends Verifier {
    private List<Throwable> errors = new ArrayList<Throwable>();

    protected void verify() throws Throwable {
        MultipleFailureException.assertEmpty(this.errors);
    }

    public void addError(Throwable error) {
        this.errors.add(error);
    }

    public <T> void checkThat(T value, Matcher<T> matcher) {
        this.checkThat("", value, matcher);
    }

    public <T> void checkThat(final String reason, final T value, final Matcher<T> matcher) {
        this.checkSucceeds(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                MatcherAssert.assertThat(reason, value, matcher);
                return value;
            }
        });
    }

    public Object checkSucceeds(Callable<Object> callable) {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            this.addError(e);
            return null;
        }
    }
}

