/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.io.IOException;
import java.io.PrintStream;
import org.hamcrest.generator.FactoryMethod;
import org.hamcrest.generator.FactoryWriter;

public class QuickReferenceWriter
implements FactoryWriter {
    private final PrintStream out;
    private int columnPosition = 14;

    public QuickReferenceWriter(PrintStream out) {
        this.out = out;
    }

    public QuickReferenceWriter() {
        this(System.out);
    }

    public void setColumnPosition(int columnPosition) {
        this.columnPosition = columnPosition;
    }

    public void writeHeader() throws IOException {
    }

    public void writeMethod(String generatedMethodName, FactoryMethod factoryMethod) throws IOException {
        String actsOn = this.removePackageNames(factoryMethod.getGenerifiedType());
        for (int i = actsOn.length(); i < this.columnPosition; ++i) {
            this.out.append(' ');
        }
        this.out.append('[').append(actsOn).append("] ");
        this.out.append(generatedMethodName);
        this.out.append('(');
        boolean seenFirst = false;
        for (FactoryMethod.Parameter parameter : factoryMethod.getParameters()) {
            if (seenFirst) {
                this.out.append(", ");
            } else {
                seenFirst = true;
            }
            this.out.append(this.removePackageNames(parameter.getType()));
        }
        this.out.append(')');
        this.out.println();
    }

    private String removePackageNames(String in) {
        return in == null ? "" : in.replaceAll("[^<>]*\\.([^\\.])", "$1");
    }

    public void writeFooter() throws IOException {
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }
}

