/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryMethod {
    private final String matcherClass;
    private final String factoryMethod;
    private String generifiedType;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<String> exceptions = new ArrayList<String>();
    private List<String> genericTypeParameters = new ArrayList<String>();
    private String javaDoc;

    public FactoryMethod(String matcherClass, String factoryMethod) {
        this.matcherClass = matcherClass;
        this.factoryMethod = factoryMethod;
    }

    public String getMatcherClass() {
        return this.matcherClass;
    }

    public String getName() {
        return this.factoryMethod;
    }

    public void setGenerifiedType(String generifiedType) {
        this.generifiedType = generifiedType;
    }

    public String getGenerifiedType() {
        return this.generifiedType;
    }

    public void addParameter(String type, String name) {
        this.parameters.add(new Parameter(type, name));
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void addException(String exception) {
        this.exceptions.add(exception);
    }

    public List<String> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public void addGenericTypeParameter(String genericTypeParameter) {
        this.genericTypeParameters.add(genericTypeParameter);
    }

    public List<String> getGenericTypeParameters() {
        return Collections.unmodifiableList(this.genericTypeParameters);
    }

    public void setJavaDoc(String javaDoc) {
        this.javaDoc = javaDoc;
    }

    public String getJavaDoc() {
        return this.javaDoc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactoryMethod that = (FactoryMethod)o;
        if (this.exceptions != null ? !((Object)this.exceptions).equals(that.exceptions) : that.exceptions != null) {
            return false;
        }
        if (this.factoryMethod != null ? !this.factoryMethod.equals(that.factoryMethod) : that.factoryMethod != null) {
            return false;
        }
        if (this.genericTypeParameters != null ? !((Object)this.genericTypeParameters).equals(that.genericTypeParameters) : that.genericTypeParameters != null) {
            return false;
        }
        if (this.generifiedType != null ? !this.generifiedType.equals(that.generifiedType) : that.generifiedType != null) {
            return false;
        }
        if (this.javaDoc != null ? !this.javaDoc.equals(that.javaDoc) : that.javaDoc != null) {
            return false;
        }
        if (this.matcherClass != null ? !this.matcherClass.equals(that.matcherClass) : that.matcherClass != null) {
            return false;
        }
        return !(this.parameters != null ? !((Object)this.parameters).equals(that.parameters) : that.parameters != null);
    }

    public int hashCode() {
        int result = this.matcherClass != null ? this.matcherClass.hashCode() : 0;
        result = 31 * result + (this.factoryMethod != null ? this.factoryMethod.hashCode() : 0);
        result = 31 * result + (this.generifiedType != null ? this.generifiedType.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? ((Object)this.parameters).hashCode() : 0);
        result = 31 * result + (this.exceptions != null ? ((Object)this.exceptions).hashCode() : 0);
        result = 31 * result + (this.genericTypeParameters != null ? ((Object)this.genericTypeParameters).hashCode() : 0);
        result = 31 * result + (this.javaDoc != null ? this.javaDoc.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "{FactoryMethod: \n  matcherClass = " + this.matcherClass + "\n" + "  factoryMethod = " + this.factoryMethod + "\n" + "  generifiedType = " + this.generifiedType + "\n" + "  parameters = " + this.parameters + "\n" + "  exceptions = " + this.exceptions + "\n" + "  genericTypeParameters = " + this.genericTypeParameters + "\n" + "  javaDoc = " + this.javaDoc + "\n" + "}";
    }

    public static class Parameter {
        private final String type;
        private final String name;

        public Parameter(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            if (this.name != null ? !this.name.equals(parameter.name) : parameter.name != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(parameter.type) : parameter.type != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.type + " " + this.name;
        }
    }
}

