/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.core;

import java.util.Arrays;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyOf<T>
extends BaseMatcher<T> {
    private final Iterable<Matcher<T>> matchers;

    public AnyOf(Iterable<Matcher<T>> matchers) {
        this.matchers = matchers;
    }

    @Override
    public boolean matches(Object o) {
        for (Matcher<T> matcher : this.matchers) {
            if (!matcher.matches(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("(");
        boolean seenFirst = false;
        for (Matcher<T> matcher : this.matchers) {
            if (seenFirst) {
                description.appendText(" or ");
            } else {
                seenFirst = true;
            }
            matcher.describeTo(description);
        }
        description.appendText(")");
    }

    @Factory
    public static <T> Matcher<T> anyOf(Matcher<T> ... matchers) {
        return AnyOf.anyOf(Arrays.asList(matchers));
    }

    @Factory
    public static <T> Matcher<T> anyOf(Iterable<Matcher<T>> matchers) {
        return new AnyOf<T>(matchers);
    }
}

