/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.beans.PropertyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasPropertyWithValue<T>
extends TypeSafeMatcher<T> {
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private final String propertyName;
    private final Matcher value;

    public HasPropertyWithValue(String propertyName, Matcher value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    @Override
    public boolean matchesSafely(T argument) {
        try {
            Method readMethod = this.getReadMethod(argument);
            return readMethod != null && this.value.matches(readMethod.invoke(argument, NO_ARGUMENTS));
        }
        catch (IntrospectionException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    private Method getReadMethod(Object argument) throws IntrospectionException {
        PropertyDescriptor property = PropertyUtil.getPropertyDescriptor(this.propertyName, argument);
        return property == null ? null : property.getReadMethod();
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("hasProperty(");
        description.appendValue(this.propertyName);
        description.appendText(", ");
        this.value.describeTo(description);
        description.appendText(")");
    }

    @Factory
    public static <T> Matcher<T> hasProperty(String propertyName, Matcher value) {
        return new HasPropertyWithValue<T>(propertyName, value);
    }
}

