/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "km" locale.
 */
public class LocalizedNamesImpl_km extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "KH",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "KH",
        "CA",
        "QA",
        "CV",
        "CM",
        "KZ",
        "CD",
        "CG",
        "CI",
        "KM",
        "CW",
        "KP",
        "KR",
        "KW",
        "XK",
        "CR",
        "CO",
        "KG",
        "KE",
        "IC",
        "CC",
        "KY",
        "CK",
        "CX",
        "CP",
        "NF",
        "TC",
        "BV",
        "PN",
        "MP",
        "MH",
        "VG",
        "VI",
        "SB",
        "HM",
        "FK",
        "FO",
        "GS",
        "AC",
        "AX",
        "UM",
        "GR",
        "HR",
        "GT",
        "KI",
        "CU",
        "GB",
        "CN",
        "TD",
        "CZ",
        "JP",
        "DJ",
        "EA",
        "JE",
        "DK",
        "DM",
        "TF",
        "PS",
        "IO",
        "DG",
        "NA",
        "NR",
        "NU",
        "TZ",
        "TJ",
        "TO",
        "TK",
        "TG",
        "TR",
        "TM",
        "TW",
        "EZ",
        "QO",
        "TH",
        "TL",
        "TN",
        "TV",
        "TT",
        "TA",
        "NI",
        "NE",
        "NG",
        "NC",
        "NZ",
        "NP",
        "NO",
        "BD",
        "BB",
        "FR",
        "BH",
        "BS",
        "BW",
        "VA",
        "BO",
        "BA",
        "BF",
        "BJ",
        "BZ",
        "BY",
        "BE",
        "PK",
        "PA",
        "PG",
        "PY",
        "PF",
        "PL",
        "PE",
        "BM",
        "BG",
        "BT",
        "BI",
        "BR",
        "PW",
        "PR",
        "PT",
        "BN",
        "FM",
        "MM",
        "MO",
        "MG",
        "MQ",
        "YT",
        "MA",
        "ML",
        "MV",
        "MT",
        "MK",
        "MW",
        "MY",
        "MX",
        "ME",
        "MS",
        "MN",
        "MD",
        "MC",
        "MR",
        "MU",
        "MZ",
        "YE",
        "RW",
        "RU",
        "RO",
        "RE",
        "LI",
        "LT",
        "LB",
        "LR",
        "LY",
        "LU",
        "VN",
        "VU",
        "WF",
        "VE",
        "PM",
        "SH",
        "EU",
        "US",
        "DO",
        "CF",
        "SM",
        "WS",
        "AS",
        "EH",
        "KN",
        "BL",
        "MF",
        "LC",
        "VC",
        "SG",
        "SX",
        "SC",
        "SO",
        "SR",
        "SL",
        "SN",
        "RS",
        "ST",
        "ZM",
        "CY",
        "ZW",
        "SY",
        "CL",
        "SE",
        "SD",
        "SS",
        "LK",
        "SI",
        "SK",
        "SJ",
        "SZ",
        "CH",
        "HK",
        "HU",
        "HN",
        "NL",
        "BQ",
        "HT",
        "JO",
        "GH",
        "GA",
        "GU",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "GG",
        "GP",
        "GM",
        "GD",
        "GL",
        "FI",
        "FJ",
        "PH",
        "GE",
        "JM",
        "GI",
        "LA",
        "LV",
        "LS",
        "AD",
        "AQ",
        "AG",
        "AI",
        "AO",
        "UN",
        "AM",
        "AW",
        "SA",
        "AL",
        "DZ",
        "DE",
        "AZ",
        "AF",
        "ZA",
        "AR",
        "AT",
        "OM",
        "AU",
        "IE",
        "EC",
        "ET",
        "AE",
        "ER",
        "EE",
        "ES",
        "EG",
        "SV",
        "IM",
        "IT",
        "IR",
        "IQ",
        "IL",
        "IS",
        "UA",
        "UY",
        "UZ",
        "UG",
        "IN",
        "ID",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ពិភពលោក");
    namesMap.put("002", "អាហ្វ្រិក");
    namesMap.put("003", "អាមេរិក​ខាង​ជើង");
    namesMap.put("005", "អាមេរិក​ខាង​ត្បូង");
    namesMap.put("009", "អូសេអានី");
    namesMap.put("011", "អាហ្វ្រិក​ខាង​លិច");
    namesMap.put("013", "អាមេរិក​កណ្ដាល");
    namesMap.put("014", "អាហ្វ្រិកខាងកើត");
    namesMap.put("015", "អាហ្វ្រិក​ខាង​ជើង");
    namesMap.put("017", "អាហ្វ្រិក​កណ្តាល");
    namesMap.put("018", "អាហ្វ្រិកភាគខាងត្បូង");
    namesMap.put("019", "អាមេរិក");
    namesMap.put("021", "អាមេរិក​ភាគ​ខាង​ជើង");
    namesMap.put("029", "ការ៉ាប៊ីន");
    namesMap.put("030", "អាស៊ី​ខាង​កើត");
    namesMap.put("034", "អាស៊ី​ខាង​ត្បូង");
    namesMap.put("035", "អាស៊ីអាគ្នេយ៍");
    namesMap.put("039", "អឺរ៉ុប​ខាង​ត្បូង");
    namesMap.put("053", "អូស្ត្រាឡាស៊ី");
    namesMap.put("054", "មេឡាណេស៊ី");
    namesMap.put("057", "តំបន់​មីក្រូណេស៊ី");
    namesMap.put("061", "ប៉ូលីណេស៊ី");
    namesMap.put("142", "អាស៊ី");
    namesMap.put("143", "អាស៊ី​កណ្ដាល");
    namesMap.put("145", "អាស៊ី​ខាង​លិច");
    namesMap.put("150", "អឺរ៉ុប");
    namesMap.put("151", "អឺរ៉ុប​ខាង​កើត");
    namesMap.put("154", "អឺរ៉ុប​ខាង​ជើង");
    namesMap.put("155", "អឺរ៉ុប​ខាង​លិច");
    namesMap.put("202", "អនុតំបន់សាហារ៉ាអាហ្វ្រិក");
    namesMap.put("419", "អាមេរិក​ឡាទីន");
    namesMap.put("AC", "កោះ​អាសេនសិន");
    namesMap.put("AD", "អង់ដូរ៉ា");
    namesMap.put("AE", "អេមីរ៉ាត​អារ៉ាប់​រួម");
    namesMap.put("AF", "អាហ្វហ្គានីស្ថាន");
    namesMap.put("AG", "អង់ទីហ្គា និង បាប៊ុយដា");
    namesMap.put("AI", "អង់ហ្គីឡា");
    namesMap.put("AL", "អាល់បានី");
    namesMap.put("AM", "អាមេនី");
    namesMap.put("AO", "អង់ហ្គោឡា");
    namesMap.put("AQ", "អង់តាក់ទិក");
    namesMap.put("AR", "អាហ្សង់ទីន");
    namesMap.put("AS", "សាម័រ អាមេរិកាំង");
    namesMap.put("AT", "អូទ្រីស");
    namesMap.put("AU", "អូស្ត្រាលី");
    namesMap.put("AW", "អារូបា");
    namesMap.put("AX", "កោះ​អាឡង់");
    namesMap.put("AZ", "អាស៊ែបៃហ្សង់");
    namesMap.put("BA", "បូស្នី និងហឺហ្សីហ្គូវីណា");
    namesMap.put("BB", "បាបាដុស");
    namesMap.put("BD", "បង់ក្លាដែស");
    namesMap.put("BE", "បែលហ្ស៊ិក");
    namesMap.put("BF", "បួគីណាហ្វាសូ");
    namesMap.put("BG", "ប៊ុលហ្គារី");
    namesMap.put("BH", "បារ៉ែន");
    namesMap.put("BI", "ប៊ូរុនឌី");
    namesMap.put("BJ", "បេណាំង");
    namesMap.put("BL", "សាំង​បាថេឡេមី");
    namesMap.put("BM", "ប៊ឺមុយដា");
    namesMap.put("BN", "ព្រុយណេ");
    namesMap.put("BO", "បូលីវី");
    namesMap.put("BQ", "ហូឡង់ ការ៉ាប៊ីន");
    namesMap.put("BR", "ប្រេស៊ីល");
    namesMap.put("BS", "បាហាម៉ា");
    namesMap.put("BT", "ប៊ូតង់");
    namesMap.put("BV", "កោះ​ប៊ូវ៉េត");
    namesMap.put("BW", "បុតស្វាណា");
    namesMap.put("BY", "បេឡារុស");
    namesMap.put("BZ", "បេលី");
    namesMap.put("CA", "កាណាដា");
    namesMap.put("CC", "កោះ​កូកូស (គីលីង)");
    namesMap.put("CD", "កុងហ្គោ- គីនស្ហាសា");
    namesMap.put("CF", "សាធារណរដ្ឋអាហ្វ្រិកកណ្ដាល");
    namesMap.put("CG", "កុងហ្គោ - ប្រាហ្សាវីល");
    namesMap.put("CH", "ស្វីស");
    namesMap.put("CI", "កូតឌីវ័រ");
    namesMap.put("CK", "កោះ​ខូក");
    namesMap.put("CL", "ស៊ីលី");
    namesMap.put("CM", "កាមេរូន");
    namesMap.put("CN", "ចិន");
    namesMap.put("CO", "កូឡុំប៊ី");
    namesMap.put("CP", "កោះ​ឃ្លីភឺតុន");
    namesMap.put("CR", "កូស្តារីកា");
    namesMap.put("CU", "គុយបា");
    namesMap.put("CV", "កាប់វែរ");
    namesMap.put("CW", "កូរ៉ាកៅ");
    namesMap.put("CX", "កោះ​គ្រីស្មាស");
    namesMap.put("CY", "ស៊ីប");
    namesMap.put("CZ", "ឆែគា");
    namesMap.put("DE", "អាល្លឺម៉ង់");
    namesMap.put("DG", "ឌៀហ្គោហ្គាស៊ី");
    namesMap.put("DJ", "ជីប៊ូទី");
    namesMap.put("DK", "ដាណឺម៉ាក");
    namesMap.put("DM", "ដូមីនីក");
    namesMap.put("DO", "សាធារណរដ្ឋ​ដូមីនីក");
    namesMap.put("DZ", "អាល់ហ្សេរី");
    namesMap.put("EA", "ជឺតា និង​ម៉េលីឡា");
    namesMap.put("EC", "អេក្វាទ័រ");
    namesMap.put("EE", "អេស្តូនី");
    namesMap.put("EG", "អេហ្ស៊ីប");
    namesMap.put("EH", "សាហារ៉ាខាងលិច");
    namesMap.put("ER", "អេរីត្រេ");
    namesMap.put("ES", "អេស្ប៉ាញ");
    namesMap.put("ET", "អេត្យូពី");
    namesMap.put("EU", "សហភាព​អឺរ៉ុប");
    namesMap.put("EZ", "តំបន់ចាយលុយអឺរ៉ូ");
    namesMap.put("FI", "ហ្វាំងឡង់");
    namesMap.put("FJ", "ហ្វីជី");
    namesMap.put("FK", "កោះ​ហ្វក់ឡែន");
    namesMap.put("FM", "មីក្រូណេស៊ី");
    namesMap.put("FO", "កោះ​ហ្វារ៉ូ");
    namesMap.put("FR", "បារាំង");
    namesMap.put("GA", "ហ្គាបុង");
    namesMap.put("GB", "ចក្រភព​អង់គ្លេស");
    namesMap.put("GD", "ហ្គ្រើណាដ");
    namesMap.put("GE", "ហ្សកហ្ស៊ី");
    namesMap.put("GF", "ហ្គីអាណា បារាំង");
    namesMap.put("GG", "ហ្គេនស៊ី");
    namesMap.put("GH", "ហ្គាណា");
    namesMap.put("GI", "ហ្ស៊ីប្រាល់តា");
    namesMap.put("GL", "ហ្គ្រោអង់ឡង់");
    namesMap.put("GM", "ហ្គំប៊ី");
    namesMap.put("GN", "ហ្គីណេ");
    namesMap.put("GP", "ហ្គោដឺឡុប");
    namesMap.put("GQ", "ហ្គីណេអេក្វាទ័រ");
    namesMap.put("GR", "ក្រិក");
    namesMap.put("GS", "កោះ​ហ្សកហ្ស៊ី​ខាងត្បូង និង សង់វិច​ខាងត្បូង");
    namesMap.put("GT", "ក្វាតេម៉ាឡា");
    namesMap.put("GU", "ហ្គាំ");
    namesMap.put("GW", "ហ្គីណេប៊ីស្សូ");
    namesMap.put("GY", "ហ្គីយ៉ាន");
    namesMap.put("HK", "ហុងកុង");
    namesMap.put("HM", "កោះ​ហឺដ និង​ម៉ាក់ដូណាល់");
    namesMap.put("HN", "ហុងឌូរ៉ាស");
    namesMap.put("HR", "ក្រូអាស៊ី");
    namesMap.put("HT", "ហៃទី");
    namesMap.put("HU", "ហុងគ្រី");
    namesMap.put("IC", "កោះ​កាណារី");
    namesMap.put("ID", "ឥណ្ឌូណេស៊ី");
    namesMap.put("IE", "អៀរឡង់");
    namesMap.put("IL", "អ៊ីស្រាអែល");
    namesMap.put("IM", "អែលអុហ្វមែន");
    namesMap.put("IN", "ឥណ្ឌា");
    namesMap.put("IO", "ដែនដី​អង់គ្លេស​នៅ​មហា​សមុទ្រ​ឥណ្ឌា");
    namesMap.put("IQ", "អ៊ីរ៉ាក់");
    namesMap.put("IR", "អ៊ីរ៉ង់");
    namesMap.put("IS", "អ៊ីស្លង់");
    namesMap.put("IT", "អ៊ីតាលី");
    namesMap.put("JE", "ជឺស៊ី");
    namesMap.put("JM", "ហ្សាម៉ាអ៊ីក");
    namesMap.put("JO", "ហ៊្សកដានី");
    namesMap.put("JP", "ជប៉ុន");
    namesMap.put("KE", "កេនយ៉ា");
    namesMap.put("KG", "កៀហ្ស៊ីស៊ីស្ថាន");
    namesMap.put("KH", "កម្ពុជា");
    namesMap.put("KI", "គិរីបាទី");
    namesMap.put("KM", "កូម័រ");
    namesMap.put("KN", "សាំង​គីត និង ណេវីស");
    namesMap.put("KP", "កូរ៉េ​ខាង​ជើង");
    namesMap.put("KR", "កូរ៉េ​ខាង​ត្បូង");
    namesMap.put("KW", "កូវ៉ែត");
    namesMap.put("KY", "កោះ​កៃម៉ង់");
    namesMap.put("KZ", "កាហ្សាក់ស្ថាន");
    namesMap.put("LA", "ឡាវ");
    namesMap.put("LB", "លីបង់");
    namesMap.put("LC", "សាំងលូស៊ី");
    namesMap.put("LI", "លិចតិនស្ដាញ");
    namesMap.put("LK", "ស្រីលង្កា");
    namesMap.put("LR", "លីបេរីយ៉ា");
    namesMap.put("LS", "ឡេសូតូ");
    namesMap.put("LT", "លីទុយអានី");
    namesMap.put("LU", "លុចសំបួ");
    namesMap.put("LV", "ឡេតូនី");
    namesMap.put("LY", "លីប៊ី");
    namesMap.put("MA", "ម៉ារ៉ុក");
    namesMap.put("MC", "ម៉ូណាកូ");
    namesMap.put("MD", "ម៉ុលដាវី");
    namesMap.put("ME", "ម៉ុងតេណេហ្គ្រោ");
    namesMap.put("MF", "សាំង​ម៉ាទីន");
    namesMap.put("MG", "ម៉ាដាហ្គាស្កា");
    namesMap.put("MH", "កោះ​ម៉ាស់សល");
    namesMap.put("MK", "ម៉ាសេដ្វាន");
    namesMap.put("ML", "ម៉ាលី");
    namesMap.put("MM", "មីយ៉ាន់ម៉ា (ភូមា)");
    namesMap.put("MN", "ម៉ុងហ្គោលី");
    namesMap.put("MO", "ម៉ាកាវ តំបន់រដ្ឋបាលពិសេសចិន");
    namesMap.put("MP", "កោះ​ម៉ារីណា​ខាង​ជើង");
    namesMap.put("MQ", "ម៉ាទីនីក");
    namesMap.put("MR", "ម៉ូរីតានី");
    namesMap.put("MS", "ម៉ុងស៊ែរ៉ា");
    namesMap.put("MT", "ម៉ាល់ត៍");
    namesMap.put("MU", "ម៉ូរីស");
    namesMap.put("MV", "ម៉ាល់ឌីវ");
    namesMap.put("MW", "ម៉ាឡាវី");
    namesMap.put("MX", "ម៉ិកស៊ិក");
    namesMap.put("MY", "ម៉ាឡេស៊ី");
    namesMap.put("MZ", "ម៉ូសំប៊ិក");
    namesMap.put("NA", "ណាមីប៊ី");
    namesMap.put("NC", "នូវែល​កាឡេដូនី");
    namesMap.put("NE", "នីហ្សេ");
    namesMap.put("NF", "កោះ​ណ័រហ្វក់");
    namesMap.put("NG", "នីហ្សេរីយ៉ា");
    namesMap.put("NI", "នីការ៉ាហ្គា");
    namesMap.put("NL", "ហូឡង់");
    namesMap.put("NO", "ន័រវែស");
    namesMap.put("NP", "នេប៉ាល់");
    namesMap.put("NR", "ណូរូ");
    namesMap.put("NU", "ណៀ");
    namesMap.put("NZ", "នូវែល​សេឡង់");
    namesMap.put("OM", "អូម៉ង់");
    namesMap.put("PA", "ប៉ាណាម៉ា");
    namesMap.put("PE", "ប៉េរូ");
    namesMap.put("PF", "ប៉ូលី​ណេស៊ី​បារាំង");
    namesMap.put("PG", "ប៉ាពូអាស៊ី​នូវែលហ្គីណេ");
    namesMap.put("PH", "ហ្វីលីពីន");
    namesMap.put("PK", "ប៉ាគីស្ថាន");
    namesMap.put("PL", "ប៉ូឡូញ");
    namesMap.put("PM", "សង់ព្យែរ និង​មីគីឡុង");
    namesMap.put("PN", "កោះ​ភីតកាន");
    namesMap.put("PR", "ព័រតូរីកូ");
    namesMap.put("PS", "ដែន​ដីប៉ាលេស្ទីន");
    namesMap.put("PT", "ព័រទុយហ្គាល់");
    namesMap.put("PW", "ផៅឡូ");
    namesMap.put("PY", "ប៉ារ៉ាហ្គាយ");
    namesMap.put("QA", "កាតា");
    namesMap.put("QO", "តំបន់ជាយអូសេអានី");
    namesMap.put("RE", "រេអុយញ៉ុង");
    namesMap.put("RO", "រូម៉ានី");
    namesMap.put("RS", "សែប៊ី");
    namesMap.put("RU", "រុស្ស៊ី");
    namesMap.put("RW", "រវ៉ាន់ដា");
    namesMap.put("SA", "អារ៉ាប៊ីសាអូឌីត");
    namesMap.put("SB", "កោះ​សូឡូម៉ុង");
    namesMap.put("SC", "សីស្ហែល");
    namesMap.put("SD", "ស៊ូដង់");
    namesMap.put("SE", "ស៊ុយអែត");
    namesMap.put("SG", "សិង្ហបុរី");
    namesMap.put("SH", "សង់​ហេឡេណា");
    namesMap.put("SI", "ស្លូវេនី");
    namesMap.put("SJ", "ស្វាលបាដ និង ហ្សង់ម៉ាយេន");
    namesMap.put("SK", "ស្លូវ៉ាគី");
    namesMap.put("SL", "សៀរ៉ាឡេអូន");
    namesMap.put("SM", "សាន​ម៉ារីណូ");
    namesMap.put("SN", "សេណេហ្គាល់");
    namesMap.put("SO", "សូម៉ាលី");
    namesMap.put("SR", "សូរីណាម");
    namesMap.put("SS", "ស៊ូដង់​ខាង​ត្បូង");
    namesMap.put("ST", "សៅតូម៉េ និង ប្រាំងស៊ីប");
    namesMap.put("SV", "អែលសាល់វ៉ាឌ័រ");
    namesMap.put("SX", "សីង​ម៉ាធីន");
    namesMap.put("SY", "ស៊ីរី");
    namesMap.put("SZ", "ស្វាស៊ីឡង់");
    namesMap.put("TA", "ទ្រីស្តង់​ដា​ចូនហា");
    namesMap.put("TC", "កោះ​ទួគ និង កៃកូស");
    namesMap.put("TD", "ឆាដ");
    namesMap.put("TF", "ដែនដី​បារាំង​នៅ​ភាគខាងត្បូង");
    namesMap.put("TG", "តូហ្គោ");
    namesMap.put("TH", "ថៃ");
    namesMap.put("TJ", "តាហ្ស៊ីគីស្ថាន");
    namesMap.put("TK", "តូខេឡៅ");
    namesMap.put("TL", "ទីម័រលីស");
    namesMap.put("TM", "តួកម៉េនីស្ថាន");
    namesMap.put("TN", "ទុយនីស៊ី");
    namesMap.put("TO", "តុងហ្គា");
    namesMap.put("TR", "តួកគី");
    namesMap.put("TT", "ទ្រីនីដាត និង​តូបាហ្គោ");
    namesMap.put("TV", "ទូវ៉ាលូ");
    namesMap.put("TW", "តៃវ៉ាន់");
    namesMap.put("TZ", "តង់សានី");
    namesMap.put("UA", "អ៊ុយក្រែន");
    namesMap.put("UG", "អ៊ូហ្គង់ដា");
    namesMap.put("UM", "កោះ​អៅឡាយីង​អាមេរិក");
    namesMap.put("UN", "អង្គការសហប្រជាជាតិ");
    namesMap.put("US", "សហរដ្ឋអាមេរិក");
    namesMap.put("UY", "អ៊ុយរូហ្គាយ");
    namesMap.put("UZ", "អ៊ូសបេគីស្ថាន");
    namesMap.put("VA", "បុរី​វ៉ាទីកង់");
    namesMap.put("VC", "សាំង​វ៉ាំងសង់ និង ហ្គ្រេណាឌីន");
    namesMap.put("VE", "វ៉េណេស៊ុយអេឡា");
    namesMap.put("VG", "កោះ​វឺជិន​ចក្រភព​អង់គ្លេស");
    namesMap.put("VI", "កោះ​វឺជីន​អាមេរិក");
    namesMap.put("VN", "វៀតណាម");
    namesMap.put("VU", "វ៉ានូទូ");
    namesMap.put("WF", "វ៉ាលីស និង​ហ្វូទូណា");
    namesMap.put("WS", "សាម័រ");
    namesMap.put("XK", "កូសូវ៉ូ");
    namesMap.put("YE", "យេម៉ែន");
    namesMap.put("YT", "ម៉ាយុត");
    namesMap.put("ZA", "អាហ្វ្រិកខាងត្បូង");
    namesMap.put("ZM", "សំប៊ី");
    namesMap.put("ZW", "ស៊ីមបាវ៉េ");
    namesMap.put("ZZ", "តំបន់មិនស្គាល់");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ពិភពលោក",
        "002": "អាហ្វ្រិក",
        "003": "អាមេរិក​ខាង​ជើង",
        "005": "អាមេរិក​ខាង​ត្បូង",
        "009": "អូសេអានី",
        "011": "អាហ្វ្រិក​ខាង​លិច",
        "013": "អាមេរិក​កណ្ដាល",
        "014": "អាហ្វ្រិកខាងកើត",
        "015": "អាហ្វ្រិក​ខាង​ជើង",
        "017": "អាហ្វ្រិក​កណ្តាល",
        "018": "អាហ្វ្រិកភាគខាងត្បូង",
        "019": "អាមេរិក",
        "021": "អាមេរិក​ភាគ​ខាង​ជើង",
        "029": "ការ៉ាប៊ីន",
        "030": "អាស៊ី​ខាង​កើត",
        "034": "អាស៊ី​ខាង​ត្បូង",
        "035": "អាស៊ីអាគ្នេយ៍",
        "039": "អឺរ៉ុប​ខាង​ត្បូង",
        "053": "អូស្ត្រាឡាស៊ី",
        "054": "មេឡាណេស៊ី",
        "057": "តំបន់​មីក្រូណេស៊ី",
        "061": "ប៉ូលីណេស៊ី",
        "142": "អាស៊ី",
        "143": "អាស៊ី​កណ្ដាល",
        "145": "អាស៊ី​ខាង​លិច",
        "150": "អឺរ៉ុប",
        "151": "អឺរ៉ុប​ខាង​កើត",
        "154": "អឺរ៉ុប​ខាង​ជើង",
        "155": "អឺរ៉ុប​ខាង​លិច",
        "202": "អនុតំបន់សាហារ៉ាអាហ្វ្រិក",
        "419": "អាមេរិក​ឡាទីន",
        "AC": "កោះ​អាសេនសិន",
        "AD": "អង់ដូរ៉ា",
        "AE": "អេមីរ៉ាត​អារ៉ាប់​រួម",
        "AF": "អាហ្វហ្គានីស្ថាន",
        "AG": "អង់ទីហ្គា និង បាប៊ុយដា",
        "AI": "អង់ហ្គីឡា",
        "AL": "អាល់បានី",
        "AM": "អាមេនី",
        "AO": "អង់ហ្គោឡា",
        "AQ": "អង់តាក់ទិក",
        "AR": "អាហ្សង់ទីន",
        "AS": "សាម័រ អាមេរិកាំង",
        "AT": "អូទ្រីស",
        "AU": "អូស្ត្រាលី",
        "AW": "អារូបា",
        "AX": "កោះ​អាឡង់",
        "AZ": "អាស៊ែបៃហ្សង់",
        "BA": "បូស្នី និងហឺហ្សីហ្គូវីណា",
        "BB": "បាបាដុស",
        "BD": "បង់ក្លាដែស",
        "BE": "បែលហ្ស៊ិក",
        "BF": "បួគីណាហ្វាសូ",
        "BG": "ប៊ុលហ្គារី",
        "BH": "បារ៉ែន",
        "BI": "ប៊ូរុនឌី",
        "BJ": "បេណាំង",
        "BL": "សាំង​បាថេឡេមី",
        "BM": "ប៊ឺមុយដា",
        "BN": "ព្រុយណេ",
        "BO": "បូលីវី",
        "BQ": "ហូឡង់ ការ៉ាប៊ីន",
        "BR": "ប្រេស៊ីល",
        "BS": "បាហាម៉ា",
        "BT": "ប៊ូតង់",
        "BV": "កោះ​ប៊ូវ៉េត",
        "BW": "បុតស្វាណា",
        "BY": "បេឡារុស",
        "BZ": "បេលី",
        "CA": "កាណាដា",
        "CC": "កោះ​កូកូស (គីលីង)",
        "CD": "កុងហ្គោ- គីនស្ហាសា",
        "CF": "សាធារណរដ្ឋអាហ្វ្រិកកណ្ដាល",
        "CG": "កុងហ្គោ - ប្រាហ្សាវីល",
        "CH": "ស្វីស",
        "CI": "កូតឌីវ័រ",
        "CK": "កោះ​ខូក",
        "CL": "ស៊ីលី",
        "CM": "កាមេរូន",
        "CN": "ចិន",
        "CO": "កូឡុំប៊ី",
        "CP": "កោះ​ឃ្លីភឺតុន",
        "CR": "កូស្តារីកា",
        "CU": "គុយបា",
        "CV": "កាប់វែរ",
        "CW": "កូរ៉ាកៅ",
        "CX": "កោះ​គ្រីស្មាស",
        "CY": "ស៊ីប",
        "CZ": "ឆែគា",
        "DE": "អាល្លឺម៉ង់",
        "DG": "ឌៀហ្គោហ្គាស៊ី",
        "DJ": "ជីប៊ូទី",
        "DK": "ដាណឺម៉ាក",
        "DM": "ដូមីនីក",
        "DO": "សាធារណរដ្ឋ​ដូមីនីក",
        "DZ": "អាល់ហ្សេរី",
        "EA": "ជឺតា និង​ម៉េលីឡា",
        "EC": "អេក្វាទ័រ",
        "EE": "អេស្តូនី",
        "EG": "អេហ្ស៊ីប",
        "EH": "សាហារ៉ាខាងលិច",
        "ER": "អេរីត្រេ",
        "ES": "អេស្ប៉ាញ",
        "ET": "អេត្យូពី",
        "EU": "សហភាព​អឺរ៉ុប",
        "EZ": "តំបន់ចាយលុយអឺរ៉ូ",
        "FI": "ហ្វាំងឡង់",
        "FJ": "ហ្វីជី",
        "FK": "កោះ​ហ្វក់ឡែន",
        "FM": "មីក្រូណេស៊ី",
        "FO": "កោះ​ហ្វារ៉ូ",
        "FR": "បារាំង",
        "GA": "ហ្គាបុង",
        "GB": "ចក្រភព​អង់គ្លេស",
        "GD": "ហ្គ្រើណាដ",
        "GE": "ហ្សកហ្ស៊ី",
        "GF": "ហ្គីអាណា បារាំង",
        "GG": "ហ្គេនស៊ី",
        "GH": "ហ្គាណា",
        "GI": "ហ្ស៊ីប្រាល់តា",
        "GL": "ហ្គ្រោអង់ឡង់",
        "GM": "ហ្គំប៊ី",
        "GN": "ហ្គីណេ",
        "GP": "ហ្គោដឺឡុប",
        "GQ": "ហ្គីណេអេក្វាទ័រ",
        "GR": "ក្រិក",
        "GS": "កោះ​ហ្សកហ្ស៊ី​ខាងត្បូង និង សង់វិច​ខាងត្បូង",
        "GT": "ក្វាតេម៉ាឡា",
        "GU": "ហ្គាំ",
        "GW": "ហ្គីណេប៊ីស្សូ",
        "GY": "ហ្គីយ៉ាន",
        "HK": "ហុងកុង",
        "HM": "កោះ​ហឺដ និង​ម៉ាក់ដូណាល់",
        "HN": "ហុងឌូរ៉ាស",
        "HR": "ក្រូអាស៊ី",
        "HT": "ហៃទី",
        "HU": "ហុងគ្រី",
        "IC": "កោះ​កាណារី",
        "ID": "ឥណ្ឌូណេស៊ី",
        "IE": "អៀរឡង់",
        "IL": "អ៊ីស្រាអែល",
        "IM": "អែលអុហ្វមែន",
        "IN": "ឥណ្ឌា",
        "IO": "ដែនដី​អង់គ្លេស​នៅ​មហា​សមុទ្រ​ឥណ្ឌា",
        "IQ": "អ៊ីរ៉ាក់",
        "IR": "អ៊ីរ៉ង់",
        "IS": "អ៊ីស្លង់",
        "IT": "អ៊ីតាលី",
        "JE": "ជឺស៊ី",
        "JM": "ហ្សាម៉ាអ៊ីក",
        "JO": "ហ៊្សកដានី",
        "JP": "ជប៉ុន",
        "KE": "កេនយ៉ា",
        "KG": "កៀហ្ស៊ីស៊ីស្ថាន",
        "KH": "កម្ពុជា",
        "KI": "គិរីបាទី",
        "KM": "កូម័រ",
        "KN": "សាំង​គីត និង ណេវីស",
        "KP": "កូរ៉េ​ខាង​ជើង",
        "KR": "កូរ៉េ​ខាង​ត្បូង",
        "KW": "កូវ៉ែត",
        "KY": "កោះ​កៃម៉ង់",
        "KZ": "កាហ្សាក់ស្ថាន",
        "LA": "ឡាវ",
        "LB": "លីបង់",
        "LC": "សាំងលូស៊ី",
        "LI": "លិចតិនស្ដាញ",
        "LK": "ស្រីលង្កា",
        "LR": "លីបេរីយ៉ា",
        "LS": "ឡេសូតូ",
        "LT": "លីទុយអានី",
        "LU": "លុចសំបួ",
        "LV": "ឡេតូនី",
        "LY": "លីប៊ី",
        "MA": "ម៉ារ៉ុក",
        "MC": "ម៉ូណាកូ",
        "MD": "ម៉ុលដាវី",
        "ME": "ម៉ុងតេណេហ្គ្រោ",
        "MF": "សាំង​ម៉ាទីន",
        "MG": "ម៉ាដាហ្គាស្កា",
        "MH": "កោះ​ម៉ាស់សល",
        "MK": "ម៉ាសេដ្វាន",
        "ML": "ម៉ាលី",
        "MM": "មីយ៉ាន់ម៉ា (ភូមា)",
        "MN": "ម៉ុងហ្គោលី",
        "MO": "ម៉ាកាវ តំបន់រដ្ឋបាលពិសេសចិន",
        "MP": "កោះ​ម៉ារីណា​ខាង​ជើង",
        "MQ": "ម៉ាទីនីក",
        "MR": "ម៉ូរីតានី",
        "MS": "ម៉ុងស៊ែរ៉ា",
        "MT": "ម៉ាល់ត៍",
        "MU": "ម៉ូរីស",
        "MV": "ម៉ាល់ឌីវ",
        "MW": "ម៉ាឡាវី",
        "MX": "ម៉ិកស៊ិក",
        "MY": "ម៉ាឡេស៊ី",
        "MZ": "ម៉ូសំប៊ិក",
        "NA": "ណាមីប៊ី",
        "NC": "នូវែល​កាឡេដូនី",
        "NE": "នីហ្សេ",
        "NF": "កោះ​ណ័រហ្វក់",
        "NG": "នីហ្សេរីយ៉ា",
        "NI": "នីការ៉ាហ្គា",
        "NL": "ហូឡង់",
        "NO": "ន័រវែស",
        "NP": "នេប៉ាល់",
        "NR": "ណូរូ",
        "NU": "ណៀ",
        "NZ": "នូវែល​សេឡង់",
        "OM": "អូម៉ង់",
        "PA": "ប៉ាណាម៉ា",
        "PE": "ប៉េរូ",
        "PF": "ប៉ូលី​ណេស៊ី​បារាំង",
        "PG": "ប៉ាពូអាស៊ី​នូវែលហ្គីណេ",
        "PH": "ហ្វីលីពីន",
        "PK": "ប៉ាគីស្ថាន",
        "PL": "ប៉ូឡូញ",
        "PM": "សង់ព្យែរ និង​មីគីឡុង",
        "PN": "កោះ​ភីតកាន",
        "PR": "ព័រតូរីកូ",
        "PS": "ដែន​ដីប៉ាលេស្ទីន",
        "PT": "ព័រទុយហ្គាល់",
        "PW": "ផៅឡូ",
        "PY": "ប៉ារ៉ាហ្គាយ",
        "QA": "កាតា",
        "QO": "តំបន់ជាយអូសេអានី",
        "RE": "រេអុយញ៉ុង",
        "RO": "រូម៉ានី",
        "RS": "សែប៊ី",
        "RU": "រុស្ស៊ី",
        "RW": "រវ៉ាន់ដា",
        "SA": "អារ៉ាប៊ីសាអូឌីត",
        "SB": "កោះ​សូឡូម៉ុង",
        "SC": "សីស្ហែល",
        "SD": "ស៊ូដង់",
        "SE": "ស៊ុយអែត",
        "SG": "សិង្ហបុរី",
        "SH": "សង់​ហេឡេណា",
        "SI": "ស្លូវេនី",
        "SJ": "ស្វាលបាដ និង ហ្សង់ម៉ាយេន",
        "SK": "ស្លូវ៉ាគី",
        "SL": "សៀរ៉ាឡេអូន",
        "SM": "សាន​ម៉ារីណូ",
        "SN": "សេណេហ្គាល់",
        "SO": "សូម៉ាលី",
        "SR": "សូរីណាម",
        "SS": "ស៊ូដង់​ខាង​ត្បូង",
        "ST": "សៅតូម៉េ និង ប្រាំងស៊ីប",
        "SV": "អែលសាល់វ៉ាឌ័រ",
        "SX": "សីង​ម៉ាធីន",
        "SY": "ស៊ីរី",
        "SZ": "ស្វាស៊ីឡង់",
        "TA": "ទ្រីស្តង់​ដា​ចូនហា",
        "TC": "កោះ​ទួគ និង កៃកូស",
        "TD": "ឆាដ",
        "TF": "ដែនដី​បារាំង​នៅ​ភាគខាងត្បូង",
        "TG": "តូហ្គោ",
        "TH": "ថៃ",
        "TJ": "តាហ្ស៊ីគីស្ថាន",
        "TK": "តូខេឡៅ",
        "TL": "ទីម័រលីស",
        "TM": "តួកម៉េនីស្ថាន",
        "TN": "ទុយនីស៊ី",
        "TO": "តុងហ្គា",
        "TR": "តួកគី",
        "TT": "ទ្រីនីដាត និង​តូបាហ្គោ",
        "TV": "ទូវ៉ាលូ",
        "TW": "តៃវ៉ាន់",
        "TZ": "តង់សានី",
        "UA": "អ៊ុយក្រែន",
        "UG": "អ៊ូហ្គង់ដា",
        "UM": "កោះ​អៅឡាយីង​អាមេរិក",
        "UN": "អង្គការសហប្រជាជាតិ",
        "US": "សហរដ្ឋអាមេរិក",
        "UY": "អ៊ុយរូហ្គាយ",
        "UZ": "អ៊ូសបេគីស្ថាន",
        "VA": "បុរី​វ៉ាទីកង់",
        "VC": "សាំង​វ៉ាំងសង់ និង ហ្គ្រេណាឌីន",
        "VE": "វ៉េណេស៊ុយអេឡា",
        "VG": "កោះ​វឺជិន​ចក្រភព​អង់គ្លេស",
        "VI": "កោះ​វឺជីន​អាមេរិក",
        "VN": "វៀតណាម",
        "VU": "វ៉ានូទូ",
        "WF": "វ៉ាលីស និង​ហ្វូទូណា",
        "WS": "សាម័រ",
        "XK": "កូសូវ៉ូ",
        "YE": "យេម៉ែន",
        "YT": "ម៉ាយុត",
        "ZA": "អាហ្វ្រិកខាងត្បូង",
        "ZM": "សំប៊ី",
        "ZW": "ស៊ីមបាវ៉េ",
        "ZZ": "តំបន់មិនស្គាល់"
    };
  }-*/;
}
