/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.stub;

import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.grpcmock.definitions.stub.StubScenario;
import org.grpcmock.exception.GrpcMockException;
import org.grpcmock.exception.UnimplementedStatusException;
import org.grpcmock.interceptors.RequestCaptureInterceptor;
import org.grpcmock.util.FunctionalHelpers;

public final class MethodStub<ReqT, RespT> {
    private final MethodDescriptor<ReqT, RespT> method;
    private final List<StubScenario<ReqT, RespT>> stubScenarios;

    MethodStub(@Nonnull MethodDescriptor<ReqT, RespT> method, @Nonnull List<StubScenario<ReqT, RespT>> stubScenarios) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(stubScenarios);
        Objects.requireNonNull(method.getServiceName());
        this.method = method;
        this.stubScenarios = new ArrayList<StubScenario<ReqT, RespT>>(stubScenarios);
    }

    public String serviceName() {
        return this.method.getServiceName();
    }

    public String fullMethodName() {
        return this.method.getFullMethodName();
    }

    ServerMethodDefinition<ReqT, RespT> serverMethodDefinition() {
        return ServerMethodDefinition.create(this.method, this.serverCallHandler());
    }

    MethodStub<ReqT, RespT> registerScenarios(@Nonnull MethodStub<ReqT, RespT> methodStub) {
        Objects.requireNonNull(methodStub);
        if (!this.method.getFullMethodName().equals(methodStub.fullMethodName())) {
            throw new GrpcMockException("Cannot register stub scenarios for a different method");
        }
        this.stubScenarios.addAll(methodStub.stubScenarios);
        return this;
    }

    private ServerCallHandler<ReqT, RespT> serverCallHandler() {
        switch (this.method.getType()) {
            case UNARY: {
                return ServerCalls.asyncUnaryCall(this::singleRequestCall);
            }
            case SERVER_STREAMING: {
                return ServerCalls.asyncServerStreamingCall(this::singleRequestCall);
            }
            case CLIENT_STREAMING: {
                return ServerCalls.asyncClientStreamingCall(this::streamRequestCall);
            }
            case BIDI_STREAMING: {
                return ServerCalls.asyncBidiStreamingCall(this::streamRequestCall);
            }
        }
        throw new GrpcMockException("Unsupported method type: " + this.method.getType());
    }

    private void singleRequestCall(ReqT request, StreamObserver<RespT> responseObserver) {
        Optional<StubScenario<ReqT, RespT>> maybeScenario = this.findStub();
        if (maybeScenario.isPresent()) {
            maybeScenario.get().call(request, responseObserver);
        } else {
            responseObserver.onError((Throwable)this.stubNotFoundException());
        }
    }

    private StreamObserver<ReqT> streamRequestCall(StreamObserver<RespT> responseObserver) {
        return new WrappedRequestStreamObserver(responseObserver);
    }

    private Optional<StubScenario<ReqT, RespT>> findStub() {
        return FunctionalHelpers.reverseStream(this.stubScenarios).filter(scenario -> scenario.matches(RequestCaptureInterceptor.getCapturedRequest())).findFirst();
    }

    private StatusRuntimeException stubNotFoundException() {
        return new UnimplementedStatusException("No matching stub scenario was found for this method: " + this.method.getFullMethodName());
    }

    private class WrappedRequestStreamObserver
    implements StreamObserver<ReqT> {
        private final StreamObserver<RespT> responseObserver;
        private StreamObserver<ReqT> delegate;

        private WrappedRequestStreamObserver(StreamObserver<RespT> responseObserver) {
            this.responseObserver = responseObserver;
        }

        public void onNext(ReqT request) {
            if (Objects.nonNull(this.delegate)) {
                this.delegate.onNext(request);
            } else {
                MethodStub.this.findStub().ifPresent(stub -> {
                    this.delegate = stub.call(this.responseObserver);
                    RequestCaptureInterceptor.getCapturedRequest().requests().forEach(arg_0 -> this.delegate.onNext(arg_0));
                });
            }
        }

        public void onError(Throwable error) {
            if (Objects.nonNull(this.delegate)) {
                this.delegate.onError(error);
            }
        }

        public void onCompleted() {
            if (Objects.nonNull(this.delegate)) {
                this.delegate.onCompleted();
            } else {
                this.responseObserver.onError((Throwable)MethodStub.this.stubNotFoundException());
            }
        }
    }
}

