/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.jvm.attach;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.lab.jvm.attach.JvmThreadInfo;
import org.gridkit.lab.jvm.attach.StackTraceElementParser;

public class JvmThreadInfoParser
implements Appendable {
    private List<JvmThreadInfo> threads = new ArrayList<JvmThreadInfo>();
    private StringBuilder line = new StringBuilder();
    private boolean threadPending = false;
    private String threadName;
    private long nativeThreadId;
    private boolean isDaemon;
    private String extThreadState;
    private boolean parseTrace = false;
    private StackTraceElementParser stackParser;
    private boolean expectTrace = false;
    private List<StackTraceElement> lastTrace = new ArrayList<StackTraceElement>();
    private Matcher threadState = Pattern.compile("\\s+ java\\.lang\\.Thread\\.State:\\s+([A-Z_]+)").matcher("");
    private Matcher threadLine = Pattern.compile("\\s+(daemon)?.+nid=0x([0-9a-fA-F]+)\\s+([^\\[]*)(\\[0x([a-fA-F0-9]*)\\])?").matcher("");

    public JvmThreadInfoParser() {
        this(false);
    }

    public JvmThreadInfoParser(boolean parseTrace) {
        this.parseTrace = parseTrace;
        if (parseTrace) {
            this.stackParser = StackTraceElementParser.DEFAULT;
        }
    }

    public void setStackElementParser(StackTraceElementParser parser) {
        this.stackParser = parser;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        for (int i = start; i != end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public Appendable append(char c) {
        if (c == '\n') {
            this.lineComplete();
        } else {
            this.line.append(c);
        }
        return this;
    }

    private void lineComplete() {
        if (this.line.length() > 0) {
            if (this.line.charAt(this.line.length() - 1) == '\r') {
                this.line.setLength(this.line.length() - 1);
            }
            if (this.threadPending) {
                this.threadState.reset(this.line);
                if (this.threadState.lookingAt()) {
                    String tstate = this.threadState.group(1);
                    Thread.State state = null;
                    try {
                        state = Thread.State.valueOf(tstate);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.appendJavaThread(state);
                } else {
                    this.appendNonJavaThread();
                }
            } else if (this.line.length() > 0 && this.line.charAt(0) == '\"') {
                int n = this.line.lastIndexOf("\"");
                this.threadLine.reset(this.line);
                if (this.threadLine.find(n + 1)) {
                    this.threadName = this.line.substring(1, n);
                    this.isDaemon = this.threadLine.group(1) != null;
                    this.nativeThreadId = 0L;
                    try {
                        this.nativeThreadId = Long.parseLong(this.threadLine.group(2), 16);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    this.extThreadState = this.threadLine.group(3);
                    if (this.extThreadState != null) {
                        this.extThreadState = this.extThreadState.trim();
                    }
                    this.completeStackTrace();
                    this.threadPending = true;
                    this.expectTrace = true;
                }
            }
            if (this.parseTrace && this.expectTrace) {
                StackTraceElement ste;
                int n;
                for (n = 0; n < this.line.length() && Character.isWhitespace(this.line.charAt(n)); ++n) {
                }
                if (n < this.line.length() + 3 && this.line.charAt(n) == 'a' && this.line.charAt(n + 1) == 't' && this.line.charAt(n + 2) == ' ' && (ste = this.stackParser.paser(this.line.substring(n += 3))) != null) {
                    this.lastTrace.add(ste);
                }
            }
        } else {
            if (this.threadPending) {
                this.appendNonJavaThread();
            }
            this.completeStackTrace();
        }
        this.line.setLength(0);
    }

    private void completeStackTrace() {
        if (this.parseTrace) {
            if (!this.lastTrace.isEmpty() && !this.threads.isEmpty()) {
                StackTraceElement[] trace = this.lastTrace.toArray(new StackTraceElement[this.lastTrace.size()]);
                this.threads.get(this.threads.size() - 1).setJavaStackTrace(trace);
            }
            this.lastTrace.clear();
        }
        this.expectTrace = false;
    }

    private void appendJavaThread(Thread.State state) {
        this.threads.add(new JvmThreadInfo(this.threadName, this.isDaemon, true, this.nativeThreadId, state, this.extThreadState));
        this.threadPending = false;
    }

    private void appendNonJavaThread() {
        this.threads.add(new JvmThreadInfo(this.threadName, this.isDaemon, false, this.nativeThreadId, null, this.extThreadState));
        this.threadPending = false;
    }

    public JvmThreadInfo[] getThreads() {
        this.append('\n');
        if (this.threadPending) {
            this.appendNonJavaThread();
        }
        return this.threads.toArray(new JvmThreadInfo[this.threads.size()]);
    }
}

