/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.jvm.attach;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.gridkit.lab.jvm.attach.AttachAPI;
import org.gridkit.lab.jvm.attach.JavaProcessDetails;
import org.gridkit.lab.jvm.attach.JavaProcessId;
import org.gridkit.lab.jvm.attach.JavaProcessMatcher;
import org.gridkit.lab.jvm.attach.LogStream;
import sun.tools.attach.HotSpotVirtualMachine;

public class AttachManager {
    private static final LogStream LOG_WARN = LogStream.warn();
    private static final LogStream LOG_INFO = LogStream.info();
    private static final LogStream LOG_DEBUG = LogStream.debug();
    private static long ATTACH_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(500L);
    private static long VM_LIST_EXPIRY = TimeUnit.SECONDS.toNanos(1L);
    private static long VM_PROPS_EXPIRY = TimeUnit.SECONDS.toNanos(1L);
    private static long VM_MBEAN_SERVER_EXPIRY = TimeUnit.SECONDS.toNanos(30L);
    private static AttachManagerInt INSTANCE;
    private static ExecutorService threadPool;

    public static void ensureToolsJar() {
    }

    public static JavaProcessDetails getDetails(long pid) {
        return INSTANCE.internalGetDetails(pid);
    }

    public static JavaProcessDetails getDetails(JavaProcessId jpid) {
        return AttachManager.getDetails(jpid.getPID());
    }

    public static List<JavaProcessId> listJavaProcesses() {
        return INSTANCE.internalListJavaProcesses();
    }

    public static List<JavaProcessId> listJavaProcesses(JavaProcessMatcher matcher) {
        return INSTANCE.internalListJavaProcesses(matcher);
    }

    public static MBeanServerConnection getJmxConnection(long pid) {
        return INSTANCE.internalGetJmxConnection(pid);
    }

    public static MBeanServerConnection getJmxConnection(JavaProcessId jpid) {
        return AttachManager.getJmxConnection(jpid.getPID());
    }

    public static void loadAgent(long pid, String agentPath, String agentArgs, long timeoutMs) throws Exception {
        INSTANCE.internalLoadAgent(pid, agentPath, agentArgs, timeoutMs);
    }

    public static List<String> getHeapHisto(long pid, Object[] args, long timeoutMs) throws Exception {
        return INSTANCE.internalHeapHisto(pid, args, timeoutMs);
    }

    public static String getHeapDump(long pid, Object[] args, long timeoutMs) throws Exception {
        return INSTANCE.internalHeapDump(pid, args, timeoutMs);
    }

    static {
        AttachAPI.ensureToolsJar();
        INSTANCE = new AttachManagerInt();
        threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 500L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            int counter = 0;

            @Override
            public synchronized Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("JvmAttachWorker-" + this.counter++);
                return t;
            }
        });
    }

    static class AttachManagerInt {
        private List<VirtualMachineDescriptor> vmList;
        private long vmListEndOfLife;
        private Map<Long, Expirable<Properties>> vmPropsCache = new HashMap<Long, Expirable<Properties>>();
        private Map<Long, Expirable<MBeanServerConnection>> vmMBeanCache = new HashMap<Long, Expirable<MBeanServerConnection>>();
        private Map<Long, AttachRequest> attachQueue = new HashMap<Long, AttachRequest>();

        AttachManagerInt() {
        }

        JavaProcessDetails internalGetDetails(long pid) {
            String name = this.getProcesssName(pid);
            return new ProcessDetails(pid, name);
        }

        private String getProcesssName(long pid) {
            List<VirtualMachineDescriptor> vms = this.getVmList();
            for (VirtualMachineDescriptor vm : vms) {
                if (!vm.id().equals(String.valueOf(pid))) continue;
                return vm.displayName();
            }
            return "";
        }

        private synchronized List<VirtualMachineDescriptor> getVmList() {
            if (this.vmList == null || this.vmListEndOfLife < System.nanoTime()) {
                this.vmList = VirtualMachine.list();
                this.vmListEndOfLife = System.nanoTime() + VM_LIST_EXPIRY;
            }
            return this.vmList;
        }

        List<JavaProcessId> internalListJavaProcesses() {
            List<VirtualMachineDescriptor> vms = this.getVmList();
            List<JavaProcessId> result = this.refine(vms);
            return result;
        }

        private List<JavaProcessId> refine(List<VirtualMachineDescriptor> vms) {
            JavaProcessId[] jpids = new JavaProcessId[vms.size()];
            for (int i = 0; i != jpids.length; ++i) {
                VirtualMachineDescriptor vm = vms.get(i);
                jpids[i] = new JavaProcessId(Long.parseLong(vm.id()), vm.displayName());
            }
            List<JavaProcessId> result = Arrays.asList(jpids);
            return result;
        }

        List<JavaProcessId> internalListJavaProcesses(final JavaProcessMatcher matcher) {
            ArrayList<Future<JavaProcessId>> futures = new ArrayList<Future<JavaProcessId>>();
            List<VirtualMachineDescriptor> vms = this.getVmList();
            for (final VirtualMachineDescriptor vm : vms) {
                futures.add(threadPool.submit(new Callable<JavaProcessId>(){

                    @Override
                    public JavaProcessId call() throws Exception {
                        ProcessDetails pd = new ProcessDetails(Long.parseLong(vm.id()), vm.displayName());
                        if (matcher.evaluate(pd)) {
                            return new JavaProcessId(pd.pid, pd.name);
                        }
                        return null;
                    }
                }));
            }
            ArrayList<JavaProcessId> result = new ArrayList<JavaProcessId>();
            for (Future future : futures) {
                try {
                    JavaProcessId p = (JavaProcessId)future.get();
                    if (p == null) continue;
                    result.add(p);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    return Collections.emptyList();
                }
                catch (ExecutionException e) {
                    LOG_DEBUG.log("Process filtering exception", e.getCause());
                }
            }
            return result;
        }

        synchronized MBeanServerConnection internalGetJmxConnection(long pid) {
            Expirable<MBeanServerConnection> mbh = this.vmMBeanCache.get(pid);
            if (mbh == null || mbh.expiryDeadline < System.nanoTime()) {
                MBeanServerConnection mserver = this.getMBeanServer(pid);
                mbh = new Expirable<MBeanServerConnection>(System.nanoTime() + VM_MBEAN_SERVER_EXPIRY, mserver);
                this.vmMBeanCache.put(pid, mbh);
            }
            return (MBeanServerConnection)mbh.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Properties internalGetSystemProperties(long pid) {
            Expirable<Properties> proph;
            AttachManagerInt attachManagerInt = this;
            synchronized (attachManagerInt) {
                proph = this.vmPropsCache.get(pid);
            }
            if (proph == null || proph.expiryDeadline < System.nanoTime()) {
                Properties props = this.getSysProps(pid);
                proph = new Expirable<Properties>(System.nanoTime() + VM_PROPS_EXPIRY, props);
                AttachManagerInt attachManagerInt2 = this;
                synchronized (attachManagerInt2) {
                    this.vmPropsCache.put(pid, proph);
                }
            }
            return (Properties)proph.value;
        }

        Properties internalGetAgentProperties(long pid) {
            return this.getAgentProps(pid);
        }

        void internalLoadAgent(long pid, String agentPath, String agentArgs, long timeoutMs) throws Exception {
            try {
                this.attachAndPerform(pid, new LoadAgent(agentPath, agentArgs), TimeUnit.MILLISECONDS.toNanos(timeoutMs));
            }
            catch (ExecutionException e) {
                if (this.isAttachException(e.getCause())) {
                    throw new Exception(e.getCause().toString());
                }
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        }

        List<String> internalHeapHisto(long pid, Object[] args, long timeoutMs) throws Exception {
            try {
                return this.attachAndPerform(pid, new HeapHisto(args), TimeUnit.MILLISECONDS.toNanos(timeoutMs));
            }
            catch (ExecutionException e) {
                if (this.isAttachException(e.getCause())) {
                    throw new Exception(e.getCause().toString());
                }
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        }

        String internalHeapDump(long pid, Object[] args, long timeoutMs) throws Exception {
            try {
                return this.attachAndPerform(pid, new HeapDump(args), TimeUnit.MILLISECONDS.toNanos(timeoutMs));
            }
            catch (ExecutionException e) {
                if (this.isAttachException(e.getCause())) {
                    throw new Exception(e.getCause().toString());
                }
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        }

        String internalPrintFlag(long pid, String flag, long timeoutMs) throws Exception {
            try {
                return this.attachAndPerform(pid, new PrintVmFlag(flag), TimeUnit.MILLISECONDS.toNanos(timeoutMs));
            }
            catch (ExecutionException e) {
                if (this.isAttachException(e.getCause())) {
                    throw new Exception(e.getCause().toString());
                }
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
        }

        private boolean isAttachException(Throwable e) {
            return e.getClass().getName().startsWith("com.sun.tools.attach.");
        }

        private MBeanServerConnection getMBeanServer(long pid) {
            try {
                String uri;
                try {
                    uri = this.attachAndPerform(pid, new GetManagementAgent(), ATTACH_TIMEOUT);
                }
                catch (InterruptedException e) {
                    LOG_WARN.log("Cannot connect to JVM (" + pid + ") - interrupted");
                    return null;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof AgentLoadException || cause instanceof AgentInitializationException) {
                        LOG_DEBUG.log("Cannot connect to JVM (" + pid + "). Agent error: " + e.toString());
                        return null;
                    }
                    LOG_DEBUG.log("Cannot connect to JVM (" + pid + ") - " + e.toString());
                    return null;
                }
                catch (TimeoutException e) {
                    LOG_DEBUG.log("Cannot connect to JVM (" + pid + ") - timeout");
                    return null;
                }
                JMXServiceURL jmxurl = new JMXServiceURL(uri);
                JMXConnector conn = JMXConnectorFactory.connect(jmxurl);
                MBeanServerConnection mserver = conn.getMBeanServerConnection();
                return mserver;
            }
            catch (Exception e) {
                LOG_DEBUG.log("Cannot connect to JVM (" + pid + ") - " + e.toString());
                return null;
            }
        }

        private Properties getSysProps(long pid) {
            try {
                return this.attachAndPerform(pid, new GetVmSysProps(), ATTACH_TIMEOUT);
            }
            catch (InterruptedException e) {
                LOG_WARN.log("Failed to read system properties, JVM pid: " + pid + ", interrupted");
                return new Properties();
            }
            catch (ExecutionException e) {
                LOG_INFO.log("Failed to read system properties, JVM pid: " + pid + ", error: " + e.getCause().toString());
                return new Properties();
            }
            catch (TimeoutException e) {
                LOG_INFO.log("Failed to read system properties, JVM pid: " + pid + ", read timeout");
                return new Properties();
            }
        }

        private Properties getAgentProps(long pid) {
            try {
                return this.attachAndPerform(pid, new GetVmAgentProps(), ATTACH_TIMEOUT);
            }
            catch (InterruptedException e) {
                LOG_WARN.log("Failed to read agent properties, JVM pid: " + pid + ", interrupted");
                return new Properties();
            }
            catch (ExecutionException e) {
                LOG_INFO.log("Failed to read agent properties, JVM pid: " + pid + ", error: " + e.getCause().toString());
                return new Properties();
            }
            catch (TimeoutException e) {
                LOG_INFO.log("Failed to read agent properties, JVM pid: " + pid + ", read timeout");
                return new Properties();
            }
        }

        private static String attachManagementAgent(VirtualMachine vm) throws IOException, AgentLoadException, AgentInitializationException {
            Properties localProperties = vm.getAgentProperties();
            if (localProperties.containsKey("com.sun.management.jmxremote.localConnectorAddress")) {
                return (String)localProperties.get("com.sun.management.jmxremote.localConnectorAddress");
            }
            String jhome = vm.getSystemProperties().getProperty("java.home");
            String localObject = jhome + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
            File localFile = new File(localObject);
            if (!localFile.exists() && !(localFile = new File(localObject = jhome + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
                throw new IOException("Management agent not found");
            }
            localObject = localFile.getCanonicalPath();
            vm.loadAgent(localObject, "com.sun.management.jmxremote");
            localProperties = vm.getAgentProperties();
            return (String)localProperties.get("com.sun.management.jmxremote.localConnectorAddress");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <V> V attachAndPerform(long pid, VMAction<V> action, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
            AttachRequest ar;
            VMTask<V> task = new VMTask<V>(action);
            boolean spawnThread = false;
            Map<Long, AttachRequest> map = this.attachQueue;
            synchronized (map) {
                ar = this.attachQueue.get(pid);
                if (ar != null) {
                    ar.tasks.add(task);
                } else {
                    ar = new AttachRequest(pid);
                    ar.tasks.add(task);
                    spawnThread = true;
                    this.attachQueue.put(pid, ar);
                }
            }
            if (spawnThread) {
                Thread attacher = new Thread(ar);
                attacher.setName("AttachToJVM-" + pid);
                attacher.setDaemon(true);
                attacher.start();
            }
            try {
                Object result;
                Object v = result = task.box.get(timeout, TimeUnit.MILLISECONDS);
                return v;
            }
            finally {
                task.box.cancel(false);
            }
        }

        private static VirtualMachine attachToJvm(final String id) throws AttachNotSupportedException, IOException {
            FutureTask<VirtualMachine> vmf = new FutureTask<VirtualMachine>(new Callable<VirtualMachine>(){

                @Override
                public VirtualMachine call() throws Exception {
                    return VirtualMachine.attach(id);
                }
            });
            Thread attacher = new Thread(vmf);
            attacher.setName("AttachManager::attachToJvm(" + id + ")");
            attacher.setDaemon(true);
            attacher.start();
            try {
                return vmf.get(ATTACH_TIMEOUT, TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                IOException er = e instanceof ExecutionException ? new IOException(e.getCause()) : new IOException(e);
                if (attacher.isAlive()) {
                    attacher.interrupt();
                }
                throw er;
            }
        }

        private static Properties getSysPropsAsync(final String id) {
            FutureTask<Properties> vmf = new FutureTask<Properties>(new Callable<Properties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Properties call() throws Exception {
                    VirtualMachine vm = null;
                    try {
                        vm = VirtualMachine.attach(id);
                        Properties properties = vm.getSystemProperties();
                        return properties;
                    }
                    finally {
                        if (vm != null) {
                            vm.detach();
                        }
                    }
                }
            });
            Thread attacher = new Thread(vmf);
            attacher.setName("AttachManager::getSysPropsAsync(" + id + ")");
            attacher.setDaemon(true);
            attacher.start();
            try {
                return vmf.get(ATTACH_TIMEOUT, TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                Throwable x = e;
                if (e instanceof ExecutionException) {
                    x = e.getCause();
                }
                if (attacher.isAlive()) {
                    attacher.interrupt();
                }
                LOG_INFO.log("Attach to (" + id + ") has failed: " + x.toString());
                LOG_DEBUG.log("Attach to (" + id + ") has failed", x);
                return new Properties();
            }
        }

        private static class HeapDump
        implements VMAction<String> {
            private final Object[] args;

            public HeapDump(Object[] args) {
                this.args = args;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String perform(VirtualMachine vm) throws Exception {
                StringWriter sw = new StringWriter();
                InputStream is = ((HotSpotVirtualMachine)vm).dumpHeap(this.args);
                try {
                    int m;
                    InputStreamReader r = new InputStreamReader(is);
                    char[] buf = new char[16384];
                    while ((m = r.read(buf)) >= 0) {
                        sw.write(buf, 0, m);
                    }
                    String string = sw.toString();
                    return string;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        private static class HeapHisto
        implements VMAction<List<String>> {
            private final Object[] args;

            public HeapHisto(Object[] args) {
                this.args = args;
            }

            @Override
            public List<String> perform(VirtualMachine vm) throws Exception {
                String line;
                InputStream is = ((HotSpotVirtualMachine)vm).heapHisto(this.args);
                ArrayList<String> result = new ArrayList<String>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while (null != (line = reader.readLine())) {
                    result.add(line);
                }
                return result;
            }
        }

        private static class LoadAgent
        implements VMAction<Void> {
            private final String agentPath;
            private final String agentArgs;

            public LoadAgent(String agentPath, String agentArgs) {
                this.agentPath = agentPath;
                this.agentArgs = agentArgs;
            }

            @Override
            public Void perform(VirtualMachine vm) throws Exception {
                vm.loadAgent(this.agentPath, this.agentArgs);
                return null;
            }
        }

        private static class GetManagementAgent
        implements VMAction<String> {
            private GetManagementAgent() {
            }

            @Override
            public String perform(VirtualMachine vm) throws IOException, AgentLoadException, AgentInitializationException {
                Properties localProperties = vm.getAgentProperties();
                if (localProperties.containsKey("com.sun.management.jmxremote.localConnectorAddress")) {
                    return (String)localProperties.get("com.sun.management.jmxremote.localConnectorAddress");
                }
                String jhome = vm.getSystemProperties().getProperty("java.home");
                String localObject = jhome + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
                File localFile = new File(localObject);
                if (!localFile.exists() && !(localFile = new File(localObject = jhome + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
                    throw new IOException("Management agent not found");
                }
                localObject = localFile.getCanonicalPath();
                vm.loadAgent(localObject, "com.sun.management.jmxremote");
                localProperties = vm.getAgentProperties();
                return (String)localProperties.get("com.sun.management.jmxremote.localConnectorAddress");
            }
        }

        private static class PrintVmFlag
        implements VMAction<String> {
            private String flag;

            public PrintVmFlag(String flag) {
                this.flag = flag;
            }

            @Override
            public String perform(VirtualMachine vm) throws IOException {
                try {
                    Method m = vm.getClass().getMethod("printFlag", String.class);
                    m.setAccessible(true);
                    InputStream is = (InputStream)m.invoke((Object)vm, this.flag);
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    return br.readLine();
                }
                catch (Exception e) {
                    return null;
                }
            }
        }

        private static class GetVmAgentProps
        implements VMAction<Properties> {
            private GetVmAgentProps() {
            }

            @Override
            public Properties perform(VirtualMachine vm) throws IOException {
                return vm.getAgentProperties();
            }
        }

        private static class GetVmSysProps
        implements VMAction<Properties> {
            private GetVmSysProps() {
            }

            @Override
            public Properties perform(VirtualMachine vm) throws IOException {
                return vm.getSystemProperties();
            }
        }

        private static interface VMAction<V> {
            public V perform(VirtualMachine var1) throws Exception;
        }

        private static class VMTask<V> {
            VirtualMachine vm;
            VMAction<V> action;
            FutureBox<V> box;

            public VMTask(VMAction<V> action) {
                this.action = action;
                this.box = new FutureBox(new Callable<V>(){

                    @Override
                    public V call() throws Exception {
                        return VMTask.this.action.perform(VMTask.this.vm);
                    }
                });
            }

            public void perform(VirtualMachine vm) {
                this.vm = vm;
                this.box.run();
                this.vm = null;
            }

            public void fail(Throwable e) {
                this.box.setException(e);
            }
        }

        private static class FutureBox<V>
        extends FutureTask<V> {
            private FutureBox(Callable<V> callable) {
                super(callable);
            }

            @Override
            public void setException(Throwable t) {
                super.setException(t);
            }
        }

        private class AttachRequest
        implements Runnable {
            final long pid;
            final List<VMTask<?>> tasks;

            public AttachRequest(long pid) {
                this.pid = pid;
                this.tasks = new ArrayList();
            }

            @Override
            public void run() {
                VirtualMachine vm;
                try {
                    try {
                        vm = VirtualMachine.attach(String.valueOf(this.pid));
                    }
                    catch (IOException e) {
                        vm = VirtualMachine.attach(String.valueOf(this.pid));
                    }
                    this.dispatch(vm);
                }
                catch (Throwable e) {
                    this.fail(e);
                    return;
                }
                try {
                    vm.detach();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void dispatch(VirtualMachine vm) {
                while (true) {
                    VMTask<?> task;
                    Map map = AttachManagerInt.this.attachQueue;
                    synchronized (map) {
                        if (this.tasks.isEmpty()) {
                            AttachManagerInt.this.attachQueue.remove(this.pid);
                            return;
                        }
                        task = this.tasks.remove(0);
                    }
                    task.perform(vm);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fail(Throwable e) {
                LOG_INFO.log("Attach to (" + this.pid + ") has failed: " + e.toString());
                LOG_DEBUG.log("Attach to (" + this.pid + ") has failed", e);
                while (true) {
                    VMTask<?> task;
                    Map map = AttachManagerInt.this.attachQueue;
                    synchronized (map) {
                        if (this.tasks.isEmpty()) {
                            AttachManagerInt.this.attachQueue.remove(this.pid);
                            return;
                        }
                        task = this.tasks.remove(0);
                    }
                    task.fail(e);
                }
            }
        }

        private static class Expirable<V> {
            long expiryDeadline;
            V value;

            public Expirable(long expiryDeadline, V value) {
                this.expiryDeadline = expiryDeadline;
                this.value = value;
            }
        }

        private class ProcessDetails
        implements JavaProcessDetails {
            private final long pid;
            private final String name;

            public ProcessDetails(long pid, String name) {
                this.pid = pid;
                this.name = name;
            }

            @Override
            public long getPid() {
                return this.pid;
            }

            @Override
            public String getDescription() {
                return this.name;
            }

            @Override
            public JavaProcessId getJavaProcId() {
                return new JavaProcessId(this.pid, this.name);
            }

            @Override
            public Properties getSystemProperties() {
                return AttachManagerInt.this.internalGetSystemProperties(this.pid);
            }

            @Override
            public Properties getAgentProperties() {
                return AttachManagerInt.this.internalGetAgentProperties(this.pid);
            }

            @Override
            public String getVmFlag(String flag) {
                try {
                    return AttachManagerInt.this.internalPrintFlag(this.pid, flag, 5L * ATTACH_TIMEOUT);
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public MBeanServerConnection getMBeans() {
                return AttachManagerInt.this.internalGetJmxConnection(this.pid);
            }
        }
    }
}

