/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.nps;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.gridkit.jvmtool.event.EventDumpParser;

public class NetbeansSnapshotParserBootstrapper {
    private static final String PARSER_PACKAGE = "org.gridkit.jvmtool.nps.parser";
    private static final String PARSER_CLASS = "org.gridkit.jvmtool.nps.parser.NetbeansSnapshotParser";
    List<URL> visualvmPath = new ArrayList<URL>();

    public EventDumpParser load() {
        String javaHome = System.getProperty("java.home");
        File f = new File(javaHome);
        this.scanDir(this.path(f, "lib/visualvm/profiler/modules"));
        this.scanDir(this.path(f, "lib/visualvm/platform/lib"));
        if (javaHome.endsWith("jre")) {
            f = new File(javaHome.substring(0, javaHome.length() - 4));
            this.scanDir(this.path(f, "lib/visualvm/profiler/modules"));
            this.scanDir(this.path(f, "lib/visualvm/platform/lib"));
        }
        if (this.visualvmPath.isEmpty()) {
            return null;
        }
        this.visualvmPath.addAll(Arrays.asList(((URLClassLoader)this.getClass().getClassLoader()).getURLs()));
        NbClassLoader cl = new NbClassLoader(this.visualvmPath.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        try {
            return new Instantiator(cl).call();
        }
        catch (Throwable e) {
            try {
                return new Instantiator(Thread.currentThread().getContextClassLoader()).call();
            }
            catch (Throwable e2) {
                return null;
            }
        }
    }

    private void scanDir(File path) {
        if (path.isDirectory() && path.listFiles() != null) {
            for (File j : path.listFiles()) {
                this.matchFile(j, "org-netbeans-modules-profiler.jar", "");
                this.matchFile(j, "org-netbeans-lib-profiler.jar", "");
                this.matchFile(j, "org-netbeans-lib-profiler-common.jar", "");
                this.matchFile(j, "org-openide-util.jar", "");
                this.matchFile(j, "org-openide-util-lookup.jar", "");
            }
        }
    }

    private void matchFile(File j, String s, String e) {
        try {
            if (j.isFile() && j.getName().startsWith(s) && j.getName().endsWith(e)) {
                this.visualvmPath.add(j.toURI().toURL());
            }
        }
        catch (MalformedURLException ee) {
            // empty catch block
        }
    }

    private File path(File f, String path) {
        File ff = f;
        for (String s : path.split("[/]")) {
            ff = new File(ff, s);
        }
        return ff;
    }

    static class Instantiator
    implements Callable<EventDumpParser> {
        final ClassLoader cl;

        public Instantiator(ClassLoader cl) {
            this.cl = cl;
        }

        @Override
        public EventDumpParser call() throws Exception {
            return (EventDumpParser)this.cl.loadClass(NetbeansSnapshotParserBootstrapper.PARSER_CLASS).newInstance();
        }
    }

    static class NbClassLoader
    extends URLClassLoader {
        private final ClassLoader baseClassloader;

        public NbClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, (ClassLoader)null);
            this.baseClassloader = parent;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.shouldLoad(name)) {
                String bytepath = name.replace('.', '/') + ".class";
                URL url = this.getResource(bytepath);
                if (url == null) {
                    throw new ClassNotFoundException(name);
                }
                Class<?> cl = this.findLoadedClass(name);
                if (cl == null) {
                    cl = this.findClass(name);
                }
                if (cl == null) {
                    throw new ClassNotFoundException(name);
                }
                return cl;
            }
            Class<?> cc = this.baseClassloader.loadClass(name);
            return cc;
        }

        private boolean shouldLoad(String name) {
            return name.startsWith(NetbeansSnapshotParserBootstrapper.PARSER_PACKAGE) || name.startsWith("org.netbeans");
        }
    }
}

