/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;
import org.gridkit.jvmtool.JvmProcessFilter;
import org.gridkit.jvmtool.JvmProcessPrinter;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.lab.jvm.attach.AttachManager;
import org.gridkit.lab.jvm.attach.JavaProcessId;
import org.gridkit.util.formating.GridExportHelper;
import org.gridkit.util.formating.GridSink;
import org.gridkit.util.formating.PrintStreamGridSink;

public class ProcListCmd
implements CommandLauncher.CmdRef {
    @Override
    public String getCommandName() {
        return "jps";
    }

    @Override
    public Runnable newCommand(CommandLauncher host) {
        return new JPS(host);
    }

    @Parameters(commandDescription="[JPS] Enhanced version of JDK's jps tool")
    public static class JPS
    implements Runnable {
        @ParametersDelegate
        private final CommandLauncher host;
        @ParametersDelegate
        private JvmProcessFilter filter = new JvmProcessFilter();
        @ParametersDelegate
        private JvmProcessPrinter printer;
        @Parameter(names={"--csv"}, description="Output in csv format")
        private boolean csv = false;
        @Parameter(names={"--json"}, description="Output in JSON format")
        private boolean json = false;
        @Parameter(names={"--output"}, description="Output file, use std out if not specified")
        private String outFile = null;

        public JPS(CommandLauncher host) {
            this.host = host;
            this.printer = new JvmProcessPrinter(host);
        }

        @Override
        public void run() {
            PrintStream out = System.out;
            if (this.outFile != null) {
                File f = new File(this.outFile);
                if (f.getParentFile() != null) {
                    f.getParentFile().mkdirs();
                }
                try {
                    out = new PrintStream(f);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            GridExportHelper exportHelper = null;
            GridSink sink = null;
            if (this.csv || this.json) {
                if (this.printer.isDefined()) {
                    exportHelper = new GridExportHelper();
                    sink = exportHelper;
                    this.printer.describeHeader(sink);
                } else {
                    this.host.fail("--process-details option is required for cvs/json export");
                }
            } else {
                sink = new PrintStreamGridSink(out);
            }
            this.filter.prepare();
            List<JavaProcessId> procList = this.filter.isDefined() || this.printer.isDefined() ? AttachManager.listJavaProcesses(this.filter) : AttachManager.listJavaProcesses();
            for (JavaProcessId jpid : procList) {
                if (this.printer.isDefined()) {
                    this.printer.describe(jpid, sink);
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(jpid.getPID()).append('\t');
                sb.append(jpid.getDescription());
                System.out.println(sb);
            }
            if (exportHelper != null) {
                if (this.csv) {
                    exportHelper.exportAsCsv(out);
                } else if (this.json) {
                    exportHelper.exportAsJson(out);
                }
            }
        }
    }
}

