/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.util.formating;

import java.io.PrintStream;
import org.gridkit.util.formating.GridSink;

public class PrintStreamGridSink
implements GridSink {
    private final PrintStream out;
    private final String separator;
    private boolean leftMost = true;

    public PrintStreamGridSink(PrintStream out) {
        this(out, "\t");
    }

    public PrintStreamGridSink(PrintStream out, String separator) {
        this.out = out;
        this.separator = separator;
    }

    @Override
    public GridSink append(Object value) {
        if (!this.leftMost) {
            this.out.print(this.separator);
        }
        if (value != null) {
            this.out.print(String.valueOf(value));
        }
        this.leftMost = false;
        return this;
    }

    @Override
    public GridSink endOfRow() {
        this.out.println();
        this.leftMost = true;
        return this;
    }
}

