/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEventPojo;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;

public class LinuxPerfImporter {
    private static final Comparator<PerfTrace> TRACE_CMP = new Comparator<PerfTrace>(){

        @Override
        public int compare(PerfTrace o1, PerfTrace o2) {
            return Double.compare(o1.timestamp, o2.timestamp);
        }
    };
    private static final Comparator<ThreadStream> THREAD_CMP = new Comparator<ThreadStream>(){

        @Override
        public int compare(ThreadStream o1, ThreadStream o2) {
            return Double.compare(o1.getNextTimestamp(), o2.getNextTimestamp());
        }
    };
    private static final Pattern HEADER_PATTERN = Pattern.compile("(.*) (\\d+) (\\d+\\.\\d+):\\s+(\\d+)\\s+(\\w.+):.*");
    private static final Pattern FRAME_PATTERN = Pattern.compile("\t\\s*([a-f0-9]+) (.*) \\((.*)\\)");

    public static Iterator<ThreadSnapshot> parseAndConvert(Reader reader, String eventFilter, double upscale, long timebase) {
        final Converter cnv = new Converter(eventFilter, upscale, timebase);
        Iterator<PerfTrace> it = LinuxPerfImporter.parse(reader);
        while (it.hasNext()) {
            PerfTrace trace = it.next();
            if (cnv.filter == null) {
                cnv.filter = trace.eventType;
            }
            cnv.add(trace);
        }
        System.out.println("Read " + cnv.total + " '" + cnv.filter + "' perf events from source");
        if (cnv.total == 0L) {
            throw new IllegalArgumentException("No matching samples found");
        }
        cnv.rescale();
        return new Iterator<ThreadSnapshot>(){
            ThreadSnapshot next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = cnv.poll();
                }
                return this.next != null;
            }

            @Override
            public ThreadSnapshot next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ThreadSnapshot that = this.next;
                this.next = null;
                return that;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StackFrame convertFrame(PerfFrame frame) {
        String classPrefix = "";
        String className = "";
        String methodName = "";
        String fileName = "";
        int lineNumber = -2;
        if (frame.symbol.equals("[unknown]")) {
            if (LinuxPerfImporter.isKernel(frame)) {
                className = "linux";
                methodName = "kernel";
                return new StackFrame(classPrefix, className, methodName, fileName, lineNumber);
            }
            className = LinuxPerfImporter.refine(LinuxPerfImporter.getLib(frame.module));
            methodName = LinuxPerfImporter.refine(LinuxPerfImporter.striptOffset(frame.symbol));
            return new StackFrame(classPrefix, className, methodName, fileName, lineNumber);
        }
        if (!frame.module.endsWith(".map")) {
            String method = LinuxPerfImporter.stripReturnType(LinuxPerfImporter.striptOffset(frame.symbol));
            method = method.replace("::", ".");
            String lib = LinuxPerfImporter.getLib(frame.module);
            if (lib.length() <= 0) return StackFrame.parseFrame(method);
            String sf = LinuxPerfImporter.refine(lib) + "." + method;
            return StackFrame.parseFrame(sf + "(" + lib + ")");
        }
        String method = LinuxPerfImporter.stripReturnType(LinuxPerfImporter.striptOffset(frame.symbol));
        if (!method.equals("StubRoutines") && !method.equals("Interpreter")) {
            if ((method = LinuxPerfImporter.stripParenthesis(method)).indexOf(46) <= 0) return StackFrame.parseFrame("JVM." + method + "(Unknown source)");
            return StackFrame.parseFrame(method + "(Unknown source)");
        }
        className = "JVM";
        methodName = method;
        return new StackFrame(classPrefix, className, methodName, fileName, lineNumber);
    }

    private static String getLib(String module) {
        String lib = module;
        int ch = module.lastIndexOf(47);
        if (ch >= 0) {
            lib = lib.substring(ch + 1);
        }
        if (lib.endsWith(".so")) {
            lib = lib.substring(0, lib.length() - 3);
        }
        return lib;
    }

    private static String stripParenthesis(String method) {
        int ch = method.indexOf(40);
        if (ch > 0) {
            return method.substring(0, ch);
        }
        return method;
    }

    private static String stripReturnType(String symbol) {
        if (symbol.startsWith("StubRoutines ")) {
            return "StubRoutines";
        }
        int ch = symbol.indexOf(32);
        if (ch > 0) {
            return symbol.substring(ch + 1);
        }
        return symbol;
    }

    private static String striptOffset(String symbol) {
        int ch = symbol.lastIndexOf(43);
        if (ch > 0) {
            return symbol.substring(0, ch);
        }
        return symbol;
    }

    private static String refine(String module) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < module.length(); ++i) {
            char ch = module.charAt(i);
            if ("[]()".indexOf(ch) >= 0) continue;
            if (":./- ".indexOf(ch) >= 0) {
                sb.append('_');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static boolean isKernel(PerfFrame frame) {
        return frame.address < 0L;
    }

    public static Iterator<PerfTrace> parse(final Reader reader) {
        return new Iterator<PerfTrace>(){
            final BufferedReader lineReader;
            PerfTrace next;
            {
                this.lineReader = new BufferedReader(reader);
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.parseNext(this.lineReader);
                }
                return this.next != null;
            }

            @Override
            public PerfTrace next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                PerfTrace that = this.next;
                this.next = null;
                return that;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private final PerfTrace parseNext(BufferedReader reader2) {
                try {
                    PerfTrace trace = this.readHeader(reader2);
                    if (trace == null) {
                        return null;
                    }
                    while (true) {
                        PerfFrame frame;
                        if ((frame = this.readFrame(reader2)) == null) {
                            return trace;
                        }
                        trace.stack.add(frame);
                    }
                }
                catch (IOException e) {
                    return null;
                }
            }

            private PerfFrame readFrame(BufferedReader reader2) throws IOException {
                String line;
                PerfFrame pf;
                do {
                    if ((line = reader2.readLine()) != null && line.trim().length() != 0) continue;
                    return null;
                } while ((pf = LinuxPerfImporter.parseFrame(line)) == null);
                return pf;
            }

            private PerfTrace readHeader(BufferedReader reader2) throws IOException {
                String line;
                Matcher m;
                PerfTrace hdr = new PerfTrace();
                do {
                    if ((line = reader2.readLine()) != null) continue;
                    return null;
                } while (!(m = HEADER_PATTERN.matcher(line)).matches());
                hdr.threadName = m.group(1);
                hdr.tid = Long.parseLong(m.group(2));
                hdr.timestamp = Double.parseDouble(m.group(3));
                hdr.weight = Long.parseLong(m.group(4));
                hdr.eventType = m.group(5);
                return hdr;
            }
        };
    }

    public static PerfFrame parseFrame(String line) {
        Matcher m = FRAME_PATTERN.matcher(line);
        if (m.matches()) {
            PerfFrame frame = new PerfFrame();
            frame.address = LinuxPerfImporter.parseHex(m.group(1));
            frame.symbol = m.group(2);
            frame.module = m.group(3);
            return frame;
        }
        return null;
    }

    private static String toHex(long hex) {
        if (hex < 0L) {
            return Long.toHexString(hex >>> 52 & 0xFL) + Long.toHexString(hex & 0x1FFFFFFFL).substring(1);
        }
        return Long.toHexString(hex);
    }

    private static long parseHex(String hex) {
        if (hex.length() < 16) {
            return Long.parseLong(hex, 16);
        }
        long h1 = Long.parseLong(hex.substring(0, 8), 16);
        long h2 = Long.parseLong(hex.substring(8), 16);
        return h1 << 32 | h2;
    }

    static /* synthetic */ Comparator access$600() {
        return THREAD_CMP;
    }

    private static class ThreadStream {
        private long threadId;
        private PerfTrace next;
        private List<PerfTrace> traces = new ArrayList<PerfTrace>();
        private long rollingWeight;
        private long rollingThreshold;

        public ThreadStream(long tid) {
            this.threadId = tid;
        }

        public void initSeek() {
            this.next = this.traces.remove(0);
            this.rollingWeight += this.next.weight;
            this.rollingThreshold = 0L;
        }

        public PerfTrace getNext(long sampleStep) {
            PerfTrace result = this.next;
            this.rollingThreshold += sampleStep;
            while (this.rollingWeight <= this.rollingThreshold) {
                if (this.traces.isEmpty()) {
                    this.next = null;
                    break;
                }
                this.next = this.traces.remove(0);
                this.rollingWeight += this.next.weight;
            }
            return result;
        }

        public double getNextTimestamp() {
            return this.next == null ? Double.MAX_VALUE : this.next.timestamp;
        }
    }

    private static class Converter {
        private final Map<StackFrame, StackFrame> frameDic = new HashMap<StackFrame, StackFrame>();
        private final Map<Long, ThreadStream> threads = new HashMap<Long, ThreadStream>();
        private final PriorityQueue<ThreadStream> streams = new PriorityQueue(16, LinuxPerfImporter.access$600());
        private long total = 0L;
        private String filter;
        private double upscale;
        private long timebase;
        private long sampleStep;

        public Converter(String filter, double upscale, long timebase) {
            this.filter = filter;
            this.upscale = upscale;
            this.timebase = timebase;
        }

        private void add(PerfTrace ptrace) {
            if (this.filter.equals(ptrace.eventType)) {
                ++this.total;
                this.convertTrace(ptrace);
                if (!this.threads.containsKey(ptrace.tid)) {
                    this.threads.put(ptrace.tid, new ThreadStream(ptrace.tid));
                }
                ThreadStream ts = this.threads.get(ptrace.tid);
                ts.traces.add(ptrace);
                ts.rollingWeight += ptrace.weight;
            }
        }

        private void rescale() {
            long maxWeight = 0L;
            long maxEvents = 0L;
            for (ThreadStream ts : this.threads.values()) {
                maxWeight = Math.max(maxWeight, ts.rollingWeight);
                maxEvents = Math.max(maxEvents, (long)ts.traces.size());
            }
            this.sampleStep = (long)((double)maxWeight / (double)maxEvents / this.upscale);
            if (this.sampleStep == 0L) {
                throw new IllegalArgumentException("Failed to calculate rescale rate");
            }
            for (ThreadStream ts : this.threads.values()) {
                ts.rollingWeight = 0L;
                Collections.sort(ts.traces, TRACE_CMP);
                this.streams.add(ts);
                ts.initSeek();
            }
        }

        private ThreadSnapshotEvent poll() {
            if (this.streams.isEmpty()) {
                return null;
            }
            ThreadStream stream = this.streams.poll();
            PerfTrace trace = stream.getNext(this.sampleStep);
            ThreadSnapshotEventPojo event = new ThreadSnapshotEventPojo();
            event.stackTrace(trace.trace);
            event.threadName(trace.threadName + " (" + trace.tid + ")");
            event.timestamp(this.timebase + (long)(trace.timestamp * 1000.0));
            if (stream.getNextTimestamp() < Double.MAX_VALUE) {
                this.streams.add(stream);
            }
            return event;
        }

        private void convertTrace(PerfTrace ptrace) {
            StackFrameArray sfa;
            ArrayList<StackFrame> trace = new ArrayList<StackFrame>();
            StackFrame kframe = null;
            for (PerfFrame pf : ptrace.stack) {
                if (pf.address == 0L) continue;
                if (LinuxPerfImporter.isKernel(pf) && trace.isEmpty()) {
                    if (kframe != null) continue;
                    kframe = this.convert(pf);
                    continue;
                }
                if (kframe != null) {
                    trace.add(kframe);
                    kframe = null;
                }
                trace.add(this.convert(pf));
            }
            ptrace.trace = sfa = new StackFrameArray(trace);
            ptrace.stack = null;
        }

        private StackFrame convert(PerfFrame pf) {
            StackFrame sf = LinuxPerfImporter.convertFrame(pf);
            if (!this.frameDic.containsKey(sf)) {
                this.frameDic.put(sf, sf);
                return sf;
            }
            return this.frameDic.get(sf);
        }
    }

    public static class PerfFrame {
        long address;
        String symbol;
        String module;
    }

    public static class PerfTrace {
        public String threadName;
        public long tid;
        public double timestamp;
        public String eventType;
        public long weight;
        public List<PerfFrame> stack = new ArrayList<PerfFrame>();
        public StackFrameArray trace;
    }
}

